@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.drds.kotlin

import com.pulumi.alicloud.drds.DrdsFunctions.getInstancesPlain
import com.pulumi.alicloud.drds.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.drds.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.drds.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.drds.kotlin.outputs.GetInstancesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object DrdsFunctions {
    /**
     * The `alicloud.drds.Instance` data source provides a collection of DRDS instances available in Alibaba Cloud account.
     * Filters support regular expression for the instance name, searches by tags, and other filters which are listed below.
     * > **NOTE:** Available in 1.35.0+.
     * ## Example Usage
     *  <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const drdsInstancesDs = alicloud.drds.getInstances({
     *     nameRegex: "drds-\\d+",
     *     ids: ["drdsabc123456"],
     * });
     * export const firstDbInstanceId = drdsInstancesDs.then(drdsInstancesDs => drdsInstancesDs.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * drds_instances_ds = alicloud.drds.get_instances(name_regex="drds-\\d+",
     *     ids=["drdsabc123456"])
     * pulumi.export("firstDbInstanceId", drds_instances_ds.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var drdsInstancesDs = AliCloud.Drds.GetInstances.Invoke(new()
     *     {
     *         NameRegex = "drds-\\d+",
     *         Ids = new[]
     *         {
     *             "drdsabc123456",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstDbInstanceId"] = drdsInstancesDs&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/drds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		drdsInstancesDs, err := drds.GetInstances(ctx, &drds.GetInstancesArgs{
     * 			NameRegex: pulumi.StringRef("drds-\\d+"),
     * 			Ids: []string{
     * 				"drdsabc123456",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstDbInstanceId", drdsInstancesDs.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.drds.DrdsFunctions;
     * import com.pulumi.alicloud.drds.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var drdsInstancesDs = DrdsFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("drds-\\d+")
     *             .ids("drdsabc123456")
     *             .build());
     *         ctx.export("firstDbInstanceId", drdsInstancesDs.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   drdsInstancesDs:
     *     fn::invoke:
     *       Function: alicloud:drds:getInstances
     *       Arguments:
     *         nameRegex: drds-\d+
     *         ids:
     *           - drdsabc123456
     * outputs:
     *   firstDbInstanceId: ${drdsInstancesDs.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        toKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param descriptionRegex A regex string to filter results by instance description.
     * @param ids A list of DRDS instance IDs.
     * @param nameRegex A regex string to filter results by instance description. It is deprecated since v1.91.0 and will be removed in a future release, please use 'description_regex' instead.
     * @param outputFile
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        descriptionRegex: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            descriptionRegex = descriptionRegex,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return toKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;drds&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }
}
