@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.drds.kotlin

import com.pulumi.alicloud.drds.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Distributed Relational Database Service (DRDS) is a lightweight (stateless), flexible, stable, and efficient middleware product independently developed by Alibaba Group to resolve scalability issues with single-host relational databases.
 * With its compatibility with MySQL protocols and syntaxes, DRDS enables database/table sharding, smooth scaling, configuration upgrade/downgrade,
 * transparent read/write splitting, and distributed transactions, providing O&M capabilities for distributed databases throughout their entire lifecycle.
 * For information about DRDS and how to use it, see [What is DRDS](https://www.alibabacloud.com/help/product/29657.htm).
 * > **NOTE:** At present, DRDS instance only can be supported in the regions: cn-shenzhen, cn-beijing, cn-hangzhou, cn-hongkong, cn-qingdao, ap-southeast-1.
 * > **NOTE:** Currently, this resource only support `Domestic Site Account`.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const config = new pulumi.Config();
 * const instanceSeries = config.get("instanceSeries") || "drds.sn1.4c8g";
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "default-NODELETING",
 * });
 * const defaultGetSwitches = defaultGetNetworks.then(defaultGetNetworks => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 * }));
 * const defaultInstance = new alicloud.drds.Instance("default", {
 *     description: "drds instance",
 *     instanceChargeType: "PostPaid",
 *     zoneId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.zoneId),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.id),
 *     instanceSeries: instanceSeries,
 *     specification: "drds.sn1.4c8g.8C16G",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * config = pulumi.Config()
 * instance_series = config.get("instanceSeries")
 * if instance_series is None:
 *     instance_series = "drds.sn1.4c8g"
 * default_get_networks = alicloud.vpc.get_networks(name_regex="default-NODELETING")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0])
 * default_instance = alicloud.drds.Instance("default",
 *     description="drds instance",
 *     instance_charge_type="PostPaid",
 *     zone_id=default_get_switches.vswitches[0].zone_id,
 *     vswitch_id=default_get_switches.vswitches[0].id,
 *     instance_series=instance_series,
 *     specification="drds.sn1.4c8g.8C16G")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var config = new Config();
 *     var instanceSeries = config.Get("instanceSeries") ?? "drds.sn1.4c8g";
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "default-NODELETING",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *     });
 *     var defaultInstance = new AliCloud.Drds.Instance("default", new()
 *     {
 *         Description = "drds instance",
 *         InstanceChargeType = "PostPaid",
 *         ZoneId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.ZoneId),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.Id),
 *         InstanceSeries = instanceSeries,
 *         Specification = "drds.sn1.4c8g.8C16G",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/drds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cfg := config.New(ctx, "")
 * 		instanceSeries := "drds.sn1.4c8g"
 * 		if param := cfg.Get("instanceSeries"); param != "" {
 * 			instanceSeries = param
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("default-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId: pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = drds.NewInstance(ctx, "default", &drds.InstanceArgs{
 * 			Description:        pulumi.String("drds instance"),
 * 			InstanceChargeType: pulumi.String("PostPaid"),
 * 			ZoneId:             pulumi.String(defaultGetSwitches.Vswitches[0].ZoneId),
 * 			VswitchId:          pulumi.String(defaultGetSwitches.Vswitches[0].Id),
 * 			InstanceSeries:     pulumi.String(instanceSeries),
 * 			Specification:      pulumi.String("drds.sn1.4c8g.8C16G"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.drds.Instance;
 * import com.pulumi.alicloud.drds.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var instanceSeries = config.get("instanceSeries").orElse("drds.sn1.4c8g");
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("default-NODELETING")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .description("drds instance")
 *             .instanceChargeType("PostPaid")
 *             .zoneId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].zoneId()))
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].id()))
 *             .instanceSeries(instanceSeries)
 *             .specification("drds.sn1.4c8g.8C16G")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   instanceSeries:
 *     type: string
 *     default: drds.sn1.4c8g
 * resources:
 *   defaultInstance:
 *     type: alicloud:drds:Instance
 *     name: default
 *     properties:
 *       description: drds instance
 *       instanceChargeType: PostPaid
 *       zoneId: ${defaultGetSwitches.vswitches[0].zoneId}
 *       vswitchId: ${defaultGetSwitches.vswitches[0].id}
 *       instanceSeries: ${instanceSeries}
 *       specification: drds.sn1.4c8g.8C16G
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: default-NODELETING
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Distributed Relational Database Service (DRDS) can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:drds/instance:Instance example drds-abc123456
 * ```
 * @property description Description of the DRDS instance, This description can have a string of 2 to 256 characters.
 * @property instanceChargeType Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
 * @property instanceSeries The parameter of the instance series. **NOTE:**  `drds.sn1.4c8g`,`drds.sn1.8c16g`,`drds.sn1.16c32g`,`drds.sn1.32c64g` are no longer supported. Valid values:
 * - `drds.sn2.4c16g` Starter Edition.
 * - `drds.sn2.8c32g` Standard Edition.
 * - `drds.sn2.16c64g` Enterprise Edition.
 * @property mysqlVersion The MySQL version supported by the instance, with the following range of values. `5`: Fully compatible with MySQL 5.x (default) `8`: Fully compatible with MySQL 8.0. This parameter takes effect when the primary instance is created, and the read-only instance has the same MySQL version as the primary instance by default.
 * @property specification User-defined DRDS instance specification. Value range:
 * - `drds.sn1.4c8g` for DRDS instance Starter version;
 * - value range : `drds.sn1.4c8g.8c16g`, `drds.sn1.4c8g.16c32g`, `drds.sn1.4c8g.32c64g`, `drds.sn1.4c8g.64c128g`
 * - `drds.sn1.8c16g` for DRDS instance Standard edition;
 * - value range : `drds.sn1.8c16g.16c32g`, `drds.sn1.8c16g.32c64g`, `drds.sn1.8c16g.64c128g`
 * - `drds.sn1.16c32g` for DRDS instance Enterprise Edition;
 * - value range : `drds.sn1.16c32g.32c64g`, `drds.sn1.16c32g.64c128g`
 * - `drds.sn1.32c64g` for DRDS instance Extreme Edition;
 * - value range : `drds.sn1.32c64g.128c256g`
 * @property vpcId The id of the VPC.
 * @property vswitchId The VSwitch ID to launch in.
 * @property zoneId The Zone to launch the DRDS instance.
 */
public data class InstanceArgs(
    public val description: Output<String>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val instanceSeries: Output<String>? = null,
    public val mysqlVersion: Output<Int>? = null,
    public val specification: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.drds.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.drds.InstanceArgs =
        com.pulumi.alicloud.drds.InstanceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .instanceSeries(instanceSeries?.applyValue({ args0 -> args0 }))
            .mysqlVersion(mysqlVersion?.applyValue({ args0 -> args0 }))
            .specification(specification?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var instanceSeries: Output<String>? = null

    private var mysqlVersion: Output<Int>? = null

    private var specification: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Description of the DRDS instance, This description can have a string of 2 to 256 characters.
     */
    @JvmName("nxfigqsbkgmjkfgb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
     */
    @JvmName("pgaxfatejpbbfvot")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value The parameter of the instance series. **NOTE:**  `drds.sn1.4c8g`,`drds.sn1.8c16g`,`drds.sn1.16c32g`,`drds.sn1.32c64g` are no longer supported. Valid values:
     * - `drds.sn2.4c16g` Starter Edition.
     * - `drds.sn2.8c32g` Standard Edition.
     * - `drds.sn2.16c64g` Enterprise Edition.
     */
    @JvmName("mobrxokudhqavrml")
    public suspend fun instanceSeries(`value`: Output<String>) {
        this.instanceSeries = value
    }

    /**
     * @param value The MySQL version supported by the instance, with the following range of values. `5`: Fully compatible with MySQL 5.x (default) `8`: Fully compatible with MySQL 8.0. This parameter takes effect when the primary instance is created, and the read-only instance has the same MySQL version as the primary instance by default.
     */
    @JvmName("lxyjngmkgopxqwai")
    public suspend fun mysqlVersion(`value`: Output<Int>) {
        this.mysqlVersion = value
    }

    /**
     * @param value User-defined DRDS instance specification. Value range:
     * - `drds.sn1.4c8g` for DRDS instance Starter version;
     * - value range : `drds.sn1.4c8g.8c16g`, `drds.sn1.4c8g.16c32g`, `drds.sn1.4c8g.32c64g`, `drds.sn1.4c8g.64c128g`
     * - `drds.sn1.8c16g` for DRDS instance Standard edition;
     * - value range : `drds.sn1.8c16g.16c32g`, `drds.sn1.8c16g.32c64g`, `drds.sn1.8c16g.64c128g`
     * - `drds.sn1.16c32g` for DRDS instance Enterprise Edition;
     * - value range : `drds.sn1.16c32g.32c64g`, `drds.sn1.16c32g.64c128g`
     * - `drds.sn1.32c64g` for DRDS instance Extreme Edition;
     * - value range : `drds.sn1.32c64g.128c256g`
     */
    @JvmName("kpgfpfwsjlvmhjtn")
    public suspend fun specification(`value`: Output<String>) {
        this.specification = value
    }

    /**
     * @param value The id of the VPC.
     */
    @JvmName("axnugyvrflglvadx")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The VSwitch ID to launch in.
     */
    @JvmName("pyfebruuxqjasbku")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The Zone to launch the DRDS instance.
     */
    @JvmName("edawrnlvjafmgdvo")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Description of the DRDS instance, This description can have a string of 2 to 256 characters.
     */
    @JvmName("ijtxgfwwgiwhdrhb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
     */
    @JvmName("dpaurfrprhwchiao")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value The parameter of the instance series. **NOTE:**  `drds.sn1.4c8g`,`drds.sn1.8c16g`,`drds.sn1.16c32g`,`drds.sn1.32c64g` are no longer supported. Valid values:
     * - `drds.sn2.4c16g` Starter Edition.
     * - `drds.sn2.8c32g` Standard Edition.
     * - `drds.sn2.16c64g` Enterprise Edition.
     */
    @JvmName("bupwdqlykuwaamuk")
    public suspend fun instanceSeries(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceSeries = mapped
    }

    /**
     * @param value The MySQL version supported by the instance, with the following range of values. `5`: Fully compatible with MySQL 5.x (default) `8`: Fully compatible with MySQL 8.0. This parameter takes effect when the primary instance is created, and the read-only instance has the same MySQL version as the primary instance by default.
     */
    @JvmName("apjtoywkbcggafia")
    public suspend fun mysqlVersion(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mysqlVersion = mapped
    }

    /**
     * @param value User-defined DRDS instance specification. Value range:
     * - `drds.sn1.4c8g` for DRDS instance Starter version;
     * - value range : `drds.sn1.4c8g.8c16g`, `drds.sn1.4c8g.16c32g`, `drds.sn1.4c8g.32c64g`, `drds.sn1.4c8g.64c128g`
     * - `drds.sn1.8c16g` for DRDS instance Standard edition;
     * - value range : `drds.sn1.8c16g.16c32g`, `drds.sn1.8c16g.32c64g`, `drds.sn1.8c16g.64c128g`
     * - `drds.sn1.16c32g` for DRDS instance Enterprise Edition;
     * - value range : `drds.sn1.16c32g.32c64g`, `drds.sn1.16c32g.64c128g`
     * - `drds.sn1.32c64g` for DRDS instance Extreme Edition;
     * - value range : `drds.sn1.32c64g.128c256g`
     */
    @JvmName("nskvdmbwiinpwqry")
    public suspend fun specification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specification = mapped
    }

    /**
     * @param value The id of the VPC.
     */
    @JvmName("khiatmbtchmpsach")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The VSwitch ID to launch in.
     */
    @JvmName("qxcfftwijencfjne")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The Zone to launch the DRDS instance.
     */
    @JvmName("wewxmsppyetpxdsk")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        description = description,
        instanceChargeType = instanceChargeType,
        instanceSeries = instanceSeries,
        mysqlVersion = mysqlVersion,
        specification = specification,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
