@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.drds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PolardbxInstance].
 */
@PulumiTagMarker
public class PolardbxInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolardbxInstanceArgs = PolardbxInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolardbxInstanceArgsBuilder.() -> Unit) {
        val builder = PolardbxInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PolardbxInstance {
        val builtJavaResource = com.pulumi.alicloud.drds.PolardbxInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PolardbxInstance(builtJavaResource)
    }
}

/**
 * Provides a DRDS Polardb X Instance resource.
 * For information about DRDS Polardb X Instance and how to use it, see [What is Polardb X Instance](https://www.alibabacloud.com/help/en/polardb/polardb-for-xscale/api-createdbinstance-1).
 * > **NOTE:** Available since v1.211.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const example = new alicloud.vpc.Network("example", {vpcName: name});
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vpcId: example.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     cidrBlock: "172.16.0.0/24",
 *     vswitchName: name,
 * });
 * const defaultPolardbxInstance = new alicloud.drds.PolardbxInstance("default", {
 *     topologyType: "3azones",
 *     vswitchId: exampleSwitch.id,
 *     primaryZone: "ap-southeast-1a",
 *     cnNodeCount: 2,
 *     dnClass: "mysql.n4.medium.25",
 *     cnClass: "polarx.x4.medium.2e",
 *     dnNodeCount: 2,
 *     secondaryZone: "ap-southeast-1b",
 *     tertiaryZone: "ap-southeast-1c",
 *     vpcId: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * example = alicloud.vpc.Network("example", vpc_name=name)
 * example_switch = alicloud.vpc.Switch("example",
 *     vpc_id=example.id,
 *     zone_id=default.zones[0].id,
 *     cidr_block="172.16.0.0/24",
 *     vswitch_name=name)
 * default_polardbx_instance = alicloud.drds.PolardbxInstance("default",
 *     topology_type="3azones",
 *     vswitch_id=example_switch.id,
 *     primary_zone="ap-southeast-1a",
 *     cn_node_count=2,
 *     dn_class="mysql.n4.medium.25",
 *     cn_class="polarx.x4.medium.2e",
 *     dn_node_count=2,
 *     secondary_zone="ap-southeast-1b",
 *     tertiary_zone="ap-southeast-1c",
 *     vpc_id=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = name,
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VpcId = example.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         CidrBlock = "172.16.0.0/24",
 *         VswitchName = name,
 *     });
 *     var defaultPolardbxInstance = new AliCloud.Drds.PolardbxInstance("default", new()
 *     {
 *         TopologyType = "3azones",
 *         VswitchId = exampleSwitch.Id,
 *         PrimaryZone = "ap-southeast-1a",
 *         CnNodeCount = 2,
 *         DnClass = "mysql.n4.medium.25",
 *         CnClass = "polarx.x4.medium.2e",
 *         DnNodeCount = 2,
 *         SecondaryZone = "ap-southeast-1b",
 *         TertiaryZone = "ap-southeast-1c",
 *         VpcId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/drds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VpcId:       example.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = drds.NewPolardbxInstance(ctx, "default", &drds.PolardbxInstanceArgs{
 * 			TopologyType:  pulumi.String("3azones"),
 * 			VswitchId:     exampleSwitch.ID(),
 * 			PrimaryZone:   pulumi.String("ap-southeast-1a"),
 * 			CnNodeCount:   pulumi.Int(2),
 * 			DnClass:       pulumi.String("mysql.n4.medium.25"),
 * 			CnClass:       pulumi.String("polarx.x4.medium.2e"),
 * 			DnNodeCount:   pulumi.Int(2),
 * 			SecondaryZone: pulumi.String("ap-southeast-1b"),
 * 			TertiaryZone:  pulumi.String("ap-southeast-1c"),
 * 			VpcId:         example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.drds.PolardbxInstance;
 * import com.pulumi.alicloud.drds.PolardbxInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName(name)
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vpcId(example.id())
 *             .zoneId(default_.zones()[0].id())
 *             .cidrBlock("172.16.0.0/24")
 *             .vswitchName(name)
 *             .build());
 *         var defaultPolardbxInstance = new PolardbxInstance("defaultPolardbxInstance", PolardbxInstanceArgs.builder()
 *             .topologyType("3azones")
 *             .vswitchId(exampleSwitch.id())
 *             .primaryZone("ap-southeast-1a")
 *             .cnNodeCount("2")
 *             .dnClass("mysql.n4.medium.25")
 *             .cnClass("polarx.x4.medium.2e")
 *             .dnNodeCount("2")
 *             .secondaryZone("ap-southeast-1b")
 *             .tertiaryZone("ap-southeast-1c")
 *             .vpcId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   example:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vpcId: ${example.id}
 *       zoneId: ${default.zones[0].id}
 *       cidrBlock: 172.16.0.0/24
 *       vswitchName: ${name}
 *   defaultPolardbxInstance:
 *     type: alicloud:drds:PolardbxInstance
 *     name: default
 *     properties:
 *       topologyType: 3azones
 *       vswitchId: ${exampleSwitch.id}
 *       primaryZone: ap-southeast-1a
 *       cnNodeCount: '2'
 *       dnClass: mysql.n4.medium.25
 *       cnClass: polarx.x4.medium.2e
 *       dnNodeCount: '2'
 *       secondaryZone: ap-southeast-1b
 *       tertiaryZone: ap-southeast-1c
 *       vpcId: ${example.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DRDS Polardb X Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:drds/polardbxInstance:PolardbxInstance example <id>
 * ```
 */
public class PolardbxInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.drds.PolardbxInstance,
) : KotlinCustomResource(javaResource, PolardbxInstanceMapper) {
    /**
     * Compute node specifications.
     */
    public val cnClass: Output<String>
        get() = javaResource.cnClass().applyValue({ args0 -> args0 })

    /**
     * Number of computing nodes.
     */
    public val cnNodeCount: Output<Int>
        get() = javaResource.cnNodeCount().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Storage node specifications.
     */
    public val dnClass: Output<String>
        get() = javaResource.dnClass().applyValue({ args0 -> args0 })

    /**
     * The number of storage nodes.
     */
    public val dnNodeCount: Output<Int>
        get() = javaResource.dnNodeCount().applyValue({ args0 -> args0 })

    /**
     * Primary Availability Zone.
     */
    public val primaryZone: Output<String>
        get() = javaResource.primaryZone().applyValue({ args0 -> args0 })

    /**
     * The resource group ID can be empty. This parameter is not supported for the time being.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Secondary availability zone.
     */
    public val secondaryZone: Output<String>?
        get() = javaResource.secondaryZone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Third Availability Zone.
     */
    public val tertiaryZone: Output<String>?
        get() = javaResource.tertiaryZone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Topology type:
     * - **3azones**: three available areas;
     * - **1azone**: Single zone.
     */
    public val topologyType: Output<String>
        get() = javaResource.topologyType().applyValue({ args0 -> args0 })

    /**
     * The VPC ID.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The ID of the virtual switch.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object PolardbxInstanceMapper : ResourceMapper<PolardbxInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.drds.PolardbxInstance::class == javaResource::class

    override fun map(javaResource: Resource): PolardbxInstance = PolardbxInstance(
        javaResource as
            com.pulumi.alicloud.drds.PolardbxInstance,
    )
}

/**
 * @see [PolardbxInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolardbxInstance].
 */
public suspend fun polardbxInstance(
    name: String,
    block: suspend PolardbxInstanceResourceBuilder.() -> Unit,
): PolardbxInstance {
    val builder = PolardbxInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolardbxInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun polardbxInstance(name: String): PolardbxInstance {
    val builder = PolardbxInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
