@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.drds.kotlin

import com.pulumi.alicloud.drds.PolardbxInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DRDS Polardb X Instance resource.
 * For information about DRDS Polardb X Instance and how to use it, see [What is Polardb X Instance](https://www.alibabacloud.com/help/en/polardb/polardb-for-xscale/api-createdbinstance-1).
 * > **NOTE:** Available since v1.211.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const example = new alicloud.vpc.Network("example", {vpcName: name});
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vpcId: example.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     cidrBlock: "172.16.0.0/24",
 *     vswitchName: name,
 * });
 * const defaultPolardbxInstance = new alicloud.drds.PolardbxInstance("default", {
 *     topologyType: "3azones",
 *     vswitchId: exampleSwitch.id,
 *     primaryZone: "ap-southeast-1a",
 *     cnNodeCount: 2,
 *     dnClass: "mysql.n4.medium.25",
 *     cnClass: "polarx.x4.medium.2e",
 *     dnNodeCount: 2,
 *     secondaryZone: "ap-southeast-1b",
 *     tertiaryZone: "ap-southeast-1c",
 *     vpcId: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * example = alicloud.vpc.Network("example", vpc_name=name)
 * example_switch = alicloud.vpc.Switch("example",
 *     vpc_id=example.id,
 *     zone_id=default.zones[0].id,
 *     cidr_block="172.16.0.0/24",
 *     vswitch_name=name)
 * default_polardbx_instance = alicloud.drds.PolardbxInstance("default",
 *     topology_type="3azones",
 *     vswitch_id=example_switch.id,
 *     primary_zone="ap-southeast-1a",
 *     cn_node_count=2,
 *     dn_class="mysql.n4.medium.25",
 *     cn_class="polarx.x4.medium.2e",
 *     dn_node_count=2,
 *     secondary_zone="ap-southeast-1b",
 *     tertiary_zone="ap-southeast-1c",
 *     vpc_id=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = name,
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VpcId = example.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         CidrBlock = "172.16.0.0/24",
 *         VswitchName = name,
 *     });
 *     var defaultPolardbxInstance = new AliCloud.Drds.PolardbxInstance("default", new()
 *     {
 *         TopologyType = "3azones",
 *         VswitchId = exampleSwitch.Id,
 *         PrimaryZone = "ap-southeast-1a",
 *         CnNodeCount = 2,
 *         DnClass = "mysql.n4.medium.25",
 *         CnClass = "polarx.x4.medium.2e",
 *         DnNodeCount = 2,
 *         SecondaryZone = "ap-southeast-1b",
 *         TertiaryZone = "ap-southeast-1c",
 *         VpcId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/drds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VpcId:       example.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = drds.NewPolardbxInstance(ctx, "default", &drds.PolardbxInstanceArgs{
 * 			TopologyType:  pulumi.String("3azones"),
 * 			VswitchId:     exampleSwitch.ID(),
 * 			PrimaryZone:   pulumi.String("ap-southeast-1a"),
 * 			CnNodeCount:   pulumi.Int(2),
 * 			DnClass:       pulumi.String("mysql.n4.medium.25"),
 * 			CnClass:       pulumi.String("polarx.x4.medium.2e"),
 * 			DnNodeCount:   pulumi.Int(2),
 * 			SecondaryZone: pulumi.String("ap-southeast-1b"),
 * 			TertiaryZone:  pulumi.String("ap-southeast-1c"),
 * 			VpcId:         example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.drds.PolardbxInstance;
 * import com.pulumi.alicloud.drds.PolardbxInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName(name)
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vpcId(example.id())
 *             .zoneId(default_.zones()[0].id())
 *             .cidrBlock("172.16.0.0/24")
 *             .vswitchName(name)
 *             .build());
 *         var defaultPolardbxInstance = new PolardbxInstance("defaultPolardbxInstance", PolardbxInstanceArgs.builder()
 *             .topologyType("3azones")
 *             .vswitchId(exampleSwitch.id())
 *             .primaryZone("ap-southeast-1a")
 *             .cnNodeCount("2")
 *             .dnClass("mysql.n4.medium.25")
 *             .cnClass("polarx.x4.medium.2e")
 *             .dnNodeCount("2")
 *             .secondaryZone("ap-southeast-1b")
 *             .tertiaryZone("ap-southeast-1c")
 *             .vpcId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   example:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vpcId: ${example.id}
 *       zoneId: ${default.zones[0].id}
 *       cidrBlock: 172.16.0.0/24
 *       vswitchName: ${name}
 *   defaultPolardbxInstance:
 *     type: alicloud:drds:PolardbxInstance
 *     name: default
 *     properties:
 *       topologyType: 3azones
 *       vswitchId: ${exampleSwitch.id}
 *       primaryZone: ap-southeast-1a
 *       cnNodeCount: '2'
 *       dnClass: mysql.n4.medium.25
 *       cnClass: polarx.x4.medium.2e
 *       dnNodeCount: '2'
 *       secondaryZone: ap-southeast-1b
 *       tertiaryZone: ap-southeast-1c
 *       vpcId: ${example.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DRDS Polardb X Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:drds/polardbxInstance:PolardbxInstance example <id>
 * ```
 * @property cnClass Compute node specifications.
 * @property cnNodeCount Number of computing nodes.
 * @property dnClass Storage node specifications.
 * @property dnNodeCount The number of storage nodes.
 * @property primaryZone Primary Availability Zone.
 * @property resourceGroupId The resource group ID can be empty. This parameter is not supported for the time being.
 * @property secondaryZone Secondary availability zone.
 * @property tertiaryZone Third Availability Zone.
 * @property topologyType Topology type:
 * - **3azones**: three available areas;
 * - **1azone**: Single zone.
 * @property vpcId The VPC ID.
 * @property vswitchId The ID of the virtual switch.
 */
public data class PolardbxInstanceArgs(
    public val cnClass: Output<String>? = null,
    public val cnNodeCount: Output<Int>? = null,
    public val dnClass: Output<String>? = null,
    public val dnNodeCount: Output<Int>? = null,
    public val primaryZone: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val secondaryZone: Output<String>? = null,
    public val tertiaryZone: Output<String>? = null,
    public val topologyType: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.drds.PolardbxInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.drds.PolardbxInstanceArgs =
        com.pulumi.alicloud.drds.PolardbxInstanceArgs.builder()
            .cnClass(cnClass?.applyValue({ args0 -> args0 }))
            .cnNodeCount(cnNodeCount?.applyValue({ args0 -> args0 }))
            .dnClass(dnClass?.applyValue({ args0 -> args0 }))
            .dnNodeCount(dnNodeCount?.applyValue({ args0 -> args0 }))
            .primaryZone(primaryZone?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .secondaryZone(secondaryZone?.applyValue({ args0 -> args0 }))
            .tertiaryZone(tertiaryZone?.applyValue({ args0 -> args0 }))
            .topologyType(topologyType?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolardbxInstanceArgs].
 */
@PulumiTagMarker
public class PolardbxInstanceArgsBuilder internal constructor() {
    private var cnClass: Output<String>? = null

    private var cnNodeCount: Output<Int>? = null

    private var dnClass: Output<String>? = null

    private var dnNodeCount: Output<Int>? = null

    private var primaryZone: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var secondaryZone: Output<String>? = null

    private var tertiaryZone: Output<String>? = null

    private var topologyType: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value Compute node specifications.
     */
    @JvmName("udjmoijfsxfijqgw")
    public suspend fun cnClass(`value`: Output<String>) {
        this.cnClass = value
    }

    /**
     * @param value Number of computing nodes.
     */
    @JvmName("fbweyywufrkcbfbi")
    public suspend fun cnNodeCount(`value`: Output<Int>) {
        this.cnNodeCount = value
    }

    /**
     * @param value Storage node specifications.
     */
    @JvmName("ysrykkbsnvlncjaf")
    public suspend fun dnClass(`value`: Output<String>) {
        this.dnClass = value
    }

    /**
     * @param value The number of storage nodes.
     */
    @JvmName("wxeryserrrojsfuj")
    public suspend fun dnNodeCount(`value`: Output<Int>) {
        this.dnNodeCount = value
    }

    /**
     * @param value Primary Availability Zone.
     */
    @JvmName("cnoohalvktcmawrl")
    public suspend fun primaryZone(`value`: Output<String>) {
        this.primaryZone = value
    }

    /**
     * @param value The resource group ID can be empty. This parameter is not supported for the time being.
     */
    @JvmName("eyygrbjkasrqcinh")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Secondary availability zone.
     */
    @JvmName("ixjkwfeeqtoqdrsp")
    public suspend fun secondaryZone(`value`: Output<String>) {
        this.secondaryZone = value
    }

    /**
     * @param value Third Availability Zone.
     */
    @JvmName("hdwgmlmpiltaossg")
    public suspend fun tertiaryZone(`value`: Output<String>) {
        this.tertiaryZone = value
    }

    /**
     * @param value Topology type:
     * - **3azones**: three available areas;
     * - **1azone**: Single zone.
     */
    @JvmName("hkhgnmxkedofsawy")
    public suspend fun topologyType(`value`: Output<String>) {
        this.topologyType = value
    }

    /**
     * @param value The VPC ID.
     */
    @JvmName("ybosbtvtvbbvrnqp")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the virtual switch.
     */
    @JvmName("auhkqfjpsmbqkduf")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Compute node specifications.
     */
    @JvmName("owcgrejlwsiftogo")
    public suspend fun cnClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cnClass = mapped
    }

    /**
     * @param value Number of computing nodes.
     */
    @JvmName("dwskwtbtampqxhfj")
    public suspend fun cnNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cnNodeCount = mapped
    }

    /**
     * @param value Storage node specifications.
     */
    @JvmName("nxceiwgwcjdsvaaw")
    public suspend fun dnClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnClass = mapped
    }

    /**
     * @param value The number of storage nodes.
     */
    @JvmName("ijtqodqbtfnimvuq")
    public suspend fun dnNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnNodeCount = mapped
    }

    /**
     * @param value Primary Availability Zone.
     */
    @JvmName("pkwalswjdvndorci")
    public suspend fun primaryZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryZone = mapped
    }

    /**
     * @param value The resource group ID can be empty. This parameter is not supported for the time being.
     */
    @JvmName("qcgarhmfodgrvwma")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Secondary availability zone.
     */
    @JvmName("lcvmywjaaolsfnnq")
    public suspend fun secondaryZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryZone = mapped
    }

    /**
     * @param value Third Availability Zone.
     */
    @JvmName("gaaqjhgpotqxwrit")
    public suspend fun tertiaryZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tertiaryZone = mapped
    }

    /**
     * @param value Topology type:
     * - **3azones**: three available areas;
     * - **1azone**: Single zone.
     */
    @JvmName("hrnmnakhdjrictnd")
    public suspend fun topologyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topologyType = mapped
    }

    /**
     * @param value The VPC ID.
     */
    @JvmName("kicdtlvcjrcdjyal")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the virtual switch.
     */
    @JvmName("csdjipvwmilujlhm")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): PolardbxInstanceArgs = PolardbxInstanceArgs(
        cnClass = cnClass,
        cnNodeCount = cnNodeCount,
        dnClass = dnClass,
        dnNodeCount = dnNodeCount,
        primaryZone = primaryZone,
        resourceGroupId = resourceGroupId,
        secondaryZone = secondaryZone,
        tertiaryZone = tertiaryZone,
        topologyType = topologyType,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
