@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.drds.kotlin.inputs

import com.pulumi.alicloud.drds.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property descriptionRegex A regex string to filter results by instance description.
 * @property ids A list of DRDS instance IDs.
 * @property nameRegex A regex string to filter results by instance description. It is deprecated since v1.91.0 and will be removed in a future release, please use 'description_regex' instead.
 * @property outputFile
 */
public data class GetInstancesPlainArgs(
    public val descriptionRegex: String? = null,
    public val ids: List<String>? = null,
    @Deprecated(
        message = """
  Field 'name_regex' is deprecated and will be removed in a future release. Please use
      'description_regex' instead.
  """,
    )
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.drds.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.drds.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.drds.inputs.GetInstancesPlainArgs.builder()
            .descriptionRegex(descriptionRegex?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var descriptionRegex: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A regex string to filter results by instance description.
     */
    @JvmName("wfifwfhawghfkwnl")
    public suspend fun descriptionRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.descriptionRegex = mapped
    }

    /**
     * @param value A list of DRDS instance IDs.
     */
    @JvmName("xplfwkxwlmhvfqnx")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of DRDS instance IDs.
     */
    @JvmName("unfrtmdlgmtnjfmt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by instance description. It is deprecated since v1.91.0 and will be removed in a future release, please use 'description_regex' instead.
     */
    @Deprecated(
        message = """
  Field 'name_regex' is deprecated and will be removed in a future release. Please use
      'description_regex' instead.
  """,
    )
    @JvmName("ifvaaxhgxtiilvol")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("gjtfgjvkkqkccvgg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        descriptionRegex = descriptionRegex,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
