@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.drds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property connectionString (Available in 1.196.0+) The connection string of the DRDS instance.
 * @property createTime Creation time of the instance.
 * @property description The DRDS instance description.
 * @property id The ID of the DRDS instance.
 * @property networkType `Classic` for public classic network or `VPC` for private network.
 * @property port (Available in 1.196.0+) The connection port of the DRDS instance.
 * @property status Status of the instance.
 * @property type The DRDS Instance type.
 * @property version The DRDS Instance version.
 * @property zoneId Zone ID the instance belongs to.
 */
public data class GetInstancesInstance(
    public val connectionString: String,
    public val createTime: Int,
    public val description: String,
    public val id: String,
    public val networkType: String,
    public val port: String,
    public val status: String,
    public val type: String,
    public val version: Int,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.drds.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            connectionString = javaType.connectionString(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            networkType = javaType.networkType(),
            port = javaType.port(),
            status = javaType.status(),
            type = javaType.type(),
            version = javaType.version(),
            zoneId = javaType.zoneId(),
        )
    }
}
