@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.drds.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstances.
 * @property descriptionRegex
 * @property descriptions A list of DRDS descriptions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of DRDS instance IDs.
 * @property instances A list of DRDS instances.
 * @property nameRegex
 * @property outputFile
 */
public data class GetInstancesResult(
    public val descriptionRegex: String? = null,
    public val descriptions: List<String>,
    public val id: String,
    public val ids: List<String>,
    public val instances: List<GetInstancesInstance>,
    @Deprecated(
        message = """
  Field 'name_regex' is deprecated and will be removed in a future release. Please use
      'description_regex' instead.
  """,
    )
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.drds.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            descriptionRegex = javaType.descriptionRegex().map({ args0 -> args0 }).orElse(null),
            descriptions = javaType.descriptions().map({ args0 -> args0 }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.drds.kotlin.outputs.GetInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
