@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin

import com.pulumi.alicloud.dts.DtsFunctions.getConsumerChannelsPlain
import com.pulumi.alicloud.dts.DtsFunctions.getInstancesPlain
import com.pulumi.alicloud.dts.DtsFunctions.getMigrationJobsPlain
import com.pulumi.alicloud.dts.DtsFunctions.getSubscriptionJobsPlain
import com.pulumi.alicloud.dts.DtsFunctions.getSynchronizationJobsPlain
import com.pulumi.alicloud.dts.kotlin.inputs.GetConsumerChannelsPlainArgs
import com.pulumi.alicloud.dts.kotlin.inputs.GetConsumerChannelsPlainArgsBuilder
import com.pulumi.alicloud.dts.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.dts.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.dts.kotlin.inputs.GetMigrationJobsPlainArgs
import com.pulumi.alicloud.dts.kotlin.inputs.GetMigrationJobsPlainArgsBuilder
import com.pulumi.alicloud.dts.kotlin.inputs.GetSubscriptionJobsPlainArgs
import com.pulumi.alicloud.dts.kotlin.inputs.GetSubscriptionJobsPlainArgsBuilder
import com.pulumi.alicloud.dts.kotlin.inputs.GetSynchronizationJobsPlainArgs
import com.pulumi.alicloud.dts.kotlin.inputs.GetSynchronizationJobsPlainArgsBuilder
import com.pulumi.alicloud.dts.kotlin.outputs.GetConsumerChannelsResult
import com.pulumi.alicloud.dts.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.dts.kotlin.outputs.GetMigrationJobsResult
import com.pulumi.alicloud.dts.kotlin.outputs.GetSubscriptionJobsResult
import com.pulumi.alicloud.dts.kotlin.outputs.GetSynchronizationJobsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.dts.kotlin.outputs.GetConsumerChannelsResult.Companion.toKotlin as getConsumerChannelsResultToKotlin
import com.pulumi.alicloud.dts.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.dts.kotlin.outputs.GetMigrationJobsResult.Companion.toKotlin as getMigrationJobsResultToKotlin
import com.pulumi.alicloud.dts.kotlin.outputs.GetSubscriptionJobsResult.Companion.toKotlin as getSubscriptionJobsResultToKotlin
import com.pulumi.alicloud.dts.kotlin.outputs.GetSynchronizationJobsResult.Companion.toKotlin as getSynchronizationJobsResultToKotlin

public object DtsFunctions {
    /**
     * This data source provides the Dts Consumer Channels of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.146.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dts.getConsumerChannels({});
     * export const dtsConsumerChannelId1 = ids.then(ids => ids.channels?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dts.get_consumer_channels()
     * pulumi.export("dtsConsumerChannelId1", ids.channels[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dts.GetConsumerChannels.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["dtsConsumerChannelId1"] = ids&#46;Apply(getConsumerChannelsResult => getConsumerChannelsResult&#46;Channels[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dts.GetConsumerChannels(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dtsConsumerChannelId1", ids.Channels[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dts.DtsFunctions;
     * import com.pulumi.alicloud.dts.inputs.GetConsumerChannelsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DtsFunctions.getConsumerChannels();
     *         ctx.export("dtsConsumerChannelId1", ids.applyValue(getConsumerChannelsResult -> getConsumerChannelsResult.channels()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dts:getConsumerChannels
     *       Arguments: {}
     * outputs:
     *   dtsConsumerChannelId1: ${ids.channels[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConsumerChannels.
     * @return A collection of values returned by getConsumerChannels.
     */
    public suspend fun getConsumerChannels(argument: GetConsumerChannelsPlainArgs): GetConsumerChannelsResult =
        getConsumerChannelsResultToKotlin(getConsumerChannelsPlain(argument.toJava()).await())

    /**
     * @see [getConsumerChannels].
     * @param dtsInstanceId Subscription instance ID.
     * @param ids A list of Consumer Channel IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getConsumerChannels.
     */
    public suspend fun getConsumerChannels(
        dtsInstanceId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
    ): GetConsumerChannelsResult {
        val argument = GetConsumerChannelsPlainArgs(
            dtsInstanceId = dtsInstanceId,
            ids = ids,
            outputFile = outputFile,
        )
        return getConsumerChannelsResultToKotlin(getConsumerChannelsPlain(argument.toJava()).await())
    }

    /**
     * @see [getConsumerChannels].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dts&#46;kotlin&#46;inputs&#46;GetConsumerChannelsPlainArgs].
     * @return A collection of values returned by getConsumerChannels.
     */
    public suspend fun getConsumerChannels(argument: suspend GetConsumerChannelsPlainArgsBuilder.() -> Unit): GetConsumerChannelsResult {
        val builder = GetConsumerChannelsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConsumerChannelsResultToKotlin(getConsumerChannelsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Dts Instance available to the user.[What is Instance](https://www.alibabacloud.com/help/en/data-transmission-service/latest/createdtsinstance)
     * > **NOTE:** Available in 1.198.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.dts.getInstances({
     *     ids: [defaultAlicloudDtsInstance&#46;id],
     *     resourceGroupId: "example_value",
     * });
     * export const alicloudDtsInstanceExampleId = _default.then(_default => _default.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.dts.get_instances(ids=[default_alicloud_dts_instance["id"]],
     *     resource_group_id="example_value")
     * pulumi.export("alicloudDtsInstanceExampleId", default.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Dts.GetInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudDtsInstance.Id,
     *         },
     *         ResourceGroupId = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudDtsInstanceExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := dts.GetInstances(ctx, &dts.GetInstancesArgs{
     * Ids: interface{}{
     * defaultAlicloudDtsInstance.Id,
     * },
     * ResourceGroupId: pulumi.StringRef("example_value"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudDtsInstanceExampleId", _default.Instances[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dts.DtsFunctions;
     * import com.pulumi.alicloud.dts.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = DtsFunctions.getInstances(GetInstancesArgs.builder()
     *             .ids(defaultAlicloudDtsInstance.id())
     *             .resourceGroupId("example_value")
     *             .build());
     *         ctx.export("alicloudDtsInstanceExampleId", default_.instances()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:dts:getInstances
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudDtsInstance.id}
     *         resourceGroupId: example_value
     * outputs:
     *   alicloudDtsInstanceExampleId: ${default.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param ids A list of Instance IDs.
     * @param nameRegex A regex string to filter results by trail name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param resourceGroupId Resource Group ID
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        resourceGroupId: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            resourceGroupId = resourceGroupId,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dts&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Dts Migration Jobs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.157.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dts.getMigrationJobs({
     *     ids: ["dts_job_id"],
     * });
     * export const dtsMigrationJobId1 = ids.then(ids => ids.jobs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dts.get_migration_jobs(ids=["dts_job_id"])
     * pulumi.export("dtsMigrationJobId1", ids.jobs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dts.GetMigrationJobs.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "dts_job_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["dtsMigrationJobId1"] = ids&#46;Apply(getMigrationJobsResult => getMigrationJobsResult&#46;Jobs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dts.GetMigrationJobs(ctx, &dts.GetMigrationJobsArgs{
     * 			Ids: []string{
     * 				"dts_job_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dtsMigrationJobId1", ids.Jobs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dts.DtsFunctions;
     * import com.pulumi.alicloud.dts.inputs.GetMigrationJobsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DtsFunctions.getMigrationJobs(GetMigrationJobsArgs.builder()
     *             .ids("dts_job_id")
     *             .build());
     *         ctx.export("dtsMigrationJobId1", ids.applyValue(getMigrationJobsResult -> getMigrationJobsResult.jobs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dts:getMigrationJobs
     *       Arguments:
     *         ids:
     *           - dts_job_id
     * outputs:
     *   dtsMigrationJobId1: ${ids.jobs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMigrationJobs.
     * @return A collection of values returned by getMigrationJobs.
     */
    public suspend fun getMigrationJobs(argument: GetMigrationJobsPlainArgs): GetMigrationJobsResult =
        getMigrationJobsResultToKotlin(getMigrationJobsPlain(argument.toJava()).await())

    /**
     * @see [getMigrationJobs].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Synchronization Job IDs.
     * @param nameRegex A regex string to filter results by Migration Job name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getMigrationJobs.
     */
    public suspend fun getMigrationJobs(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetMigrationJobsResult {
        val argument = GetMigrationJobsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getMigrationJobsResultToKotlin(getMigrationJobsPlain(argument.toJava()).await())
    }

    /**
     * @see [getMigrationJobs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dts&#46;kotlin&#46;inputs&#46;GetMigrationJobsPlainArgs].
     * @return A collection of values returned by getMigrationJobs.
     */
    public suspend fun getMigrationJobs(argument: suspend GetMigrationJobsPlainArgsBuilder.() -> Unit): GetMigrationJobsResult {
        val builder = GetMigrationJobsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMigrationJobsResultToKotlin(getMigrationJobsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Dts Subscription Jobs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.138.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dts.getSubscriptionJobs({});
     * export const dtsSubscriptionJobId1 = ids.then(ids => ids.jobs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dts.get_subscription_jobs()
     * pulumi.export("dtsSubscriptionJobId1", ids.jobs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dts.GetSubscriptionJobs.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["dtsSubscriptionJobId1"] = ids&#46;Apply(getSubscriptionJobsResult => getSubscriptionJobsResult&#46;Jobs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dts.GetSubscriptionJobs(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dtsSubscriptionJobId1", ids.Jobs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dts.DtsFunctions;
     * import com.pulumi.alicloud.dts.inputs.GetSubscriptionJobsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DtsFunctions.getSubscriptionJobs();
     *         ctx.export("dtsSubscriptionJobId1", ids.applyValue(getSubscriptionJobsResult -> getSubscriptionJobsResult.jobs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dts:getSubscriptionJobs
     *       Arguments: {}
     * outputs:
     *   dtsSubscriptionJobId1: ${ids.jobs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSubscriptionJobs.
     * @return A collection of values returned by getSubscriptionJobs.
     */
    public suspend fun getSubscriptionJobs(argument: GetSubscriptionJobsPlainArgs): GetSubscriptionJobsResult =
        getSubscriptionJobsResultToKotlin(getSubscriptionJobsPlain(argument.toJava()).await())

    /**
     * @see [getSubscriptionJobs].
     * @param enableDetails
     * @param ids A list of Subscription Job IDs.
     * @param nameRegex A regex string to filter results by subscription job name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the task. Valid values: `Abnormal`, `Downgrade`, `Locked`, `Normal`, `NotStarted`, `NotStarted`, `PreCheckPass`, `PrecheckFailed`, `Prechecking`, `Retrying`, `Starting`, `Upgrade`.
     * @param tags
     * @return A collection of values returned by getSubscriptionJobs.
     */
    public suspend fun getSubscriptionJobs(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetSubscriptionJobsResult {
        val argument = GetSubscriptionJobsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            tags = tags,
        )
        return getSubscriptionJobsResultToKotlin(getSubscriptionJobsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubscriptionJobs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dts&#46;kotlin&#46;inputs&#46;GetSubscriptionJobsPlainArgs].
     * @return A collection of values returned by getSubscriptionJobs.
     */
    public suspend fun getSubscriptionJobs(argument: suspend GetSubscriptionJobsPlainArgsBuilder.() -> Unit): GetSubscriptionJobsResult {
        val builder = GetSubscriptionJobsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubscriptionJobsResultToKotlin(getSubscriptionJobsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Dts Synchronization Jobs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.138.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dts.getSynchronizationJobs({});
     * export const dtsSynchronizationJobId1 = ids.then(ids => ids.jobs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dts.get_synchronization_jobs()
     * pulumi.export("dtsSynchronizationJobId1", ids.jobs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dts.GetSynchronizationJobs.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["dtsSynchronizationJobId1"] = ids&#46;Apply(getSynchronizationJobsResult => getSynchronizationJobsResult&#46;Jobs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dts.GetSynchronizationJobs(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dtsSynchronizationJobId1", ids.Jobs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dts.DtsFunctions;
     * import com.pulumi.alicloud.dts.inputs.GetSynchronizationJobsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DtsFunctions.getSynchronizationJobs();
     *         ctx.export("dtsSynchronizationJobId1", ids.applyValue(getSynchronizationJobsResult -> getSynchronizationJobsResult.jobs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dts:getSynchronizationJobs
     *       Arguments: {}
     * outputs:
     *   dtsSynchronizationJobId1: ${ids.jobs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSynchronizationJobs.
     * @return A collection of values returned by getSynchronizationJobs.
     */
    public suspend fun getSynchronizationJobs(argument: GetSynchronizationJobsPlainArgs): GetSynchronizationJobsResult =
        getSynchronizationJobsResultToKotlin(getSynchronizationJobsPlain(argument.toJava()).await())

    /**
     * @see [getSynchronizationJobs].
     * @param enableDetails
     * @param ids A list of Synchronization Job IDs.
     * @param nameRegex A regex string to filter results by synchronization job name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `Synchronizing`, `Suspending`. `Downgrade`, `Failed`, `Finished`, `InitializeFailed`, `Locked`, `Modifying`, `NotConfigured`, `NotStarted`, `PreCheckPass`, `PrecheckFailed`, `Prechecking`, `Retrying`, `Upgrade`.
     * @return A collection of values returned by getSynchronizationJobs.
     */
    public suspend fun getSynchronizationJobs(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetSynchronizationJobsResult {
        val argument = GetSynchronizationJobsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getSynchronizationJobsResultToKotlin(getSynchronizationJobsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSynchronizationJobs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dts&#46;kotlin&#46;inputs&#46;GetSynchronizationJobsPlainArgs].
     * @return A collection of values returned by getSynchronizationJobs.
     */
    public suspend fun getSynchronizationJobs(argument: suspend GetSynchronizationJobsPlainArgsBuilder.() -> Unit): GetSynchronizationJobsResult {
        val builder = GetSynchronizationJobsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSynchronizationJobsResultToKotlin(getSynchronizationJobsPlain(builtArgument.toJava()).await())
    }
}
