@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.dts.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides a Dts Instance resource.
 * For information about Dts Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/data-transmission-service/latest/createdtsinstance).
 * > **NOTE:** Available since v1.198.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultGetRegions = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultInstance = new alicloud.dts.Instance("default", {
 *     type: "sync",
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     paymentType: "Subscription",
 *     instanceClass: "large",
 *     sourceEndpointEngineName: "MySQL",
 *     sourceRegion: defaultGetRegions.then(defaultGetRegions => defaultGetRegions.regions?.[0]?.id),
 *     destinationEndpointEngineName: "MySQL",
 *     destinationRegion: defaultGetRegions.then(defaultGetRegions => defaultGetRegions.regions?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_get_regions = alicloud.get_regions(current=True)
 * default_instance = alicloud.dts.Instance("default",
 *     type="sync",
 *     resource_group_id=default.ids[0],
 *     payment_type="Subscription",
 *     instance_class="large",
 *     source_endpoint_engine_name="MySQL",
 *     source_region=default_get_regions.regions[0].id,
 *     destination_endpoint_engine_name="MySQL",
 *     destination_region=default_get_regions.regions[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultGetRegions = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultInstance = new AliCloud.Dts.Instance("default", new()
 *     {
 *         Type = "sync",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         PaymentType = "Subscription",
 *         InstanceClass = "large",
 *         SourceEndpointEngineName = "MySQL",
 *         SourceRegion = defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id),
 *         DestinationEndpointEngineName = "MySQL",
 *         DestinationRegion = defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dts"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetRegions, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dts.NewInstance(ctx, "default", &dts.InstanceArgs{
 * 			Type:                          pulumi.String("sync"),
 * 			ResourceGroupId:               pulumi.String(_default.Ids[0]),
 * 			PaymentType:                   pulumi.String("Subscription"),
 * 			InstanceClass:                 pulumi.String("large"),
 * 			SourceEndpointEngineName:      pulumi.String("MySQL"),
 * 			SourceRegion:                  pulumi.String(defaultGetRegions.Regions[0].Id),
 * 			DestinationEndpointEngineName: pulumi.String("MySQL"),
 * 			DestinationRegion:             pulumi.String(defaultGetRegions.Regions[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.dts.Instance;
 * import com.pulumi.alicloud.dts.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         final var defaultGetRegions = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .type("sync")
 *             .resourceGroupId(default_.ids()[0])
 *             .paymentType("Subscription")
 *             .instanceClass("large")
 *             .sourceEndpointEngineName("MySQL")
 *             .sourceRegion(defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()))
 *             .destinationEndpointEngineName("MySQL")
 *             .destinationRegion(defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultInstance:
 *     type: alicloud:dts:Instance
 *     name: default
 *     properties:
 *       type: sync
 *       resourceGroupId: ${default.ids[0]}
 *       paymentType: Subscription
 *       instanceClass: large
 *       sourceEndpointEngineName: MySQL
 *       sourceRegion: ${defaultGetRegions.regions[0].id}
 *       destinationEndpointEngineName: MySQL
 *       destinationRegion: ${defaultGetRegions.regions[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 *   defaultGetRegions:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Dts Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dts/instance:Instance example <id>
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.dts.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Whether to automatically renew the fee when it expires. Valid values:
     * - **false**: No, the default value.
     * - **true**: Yes.
     */
    public val autoPay: Output<Boolean>?
        get() = javaResource.autoPay().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to start the task automatically after the purchase is completed. Value:
     * - **false**: No, the default value.
     * - **true**: Yes.
     */
    public val autoStart: Output<Boolean>?
        get() = javaResource.autoStart().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifications of ETL. The unit is compute unit (CU),1CU = 1vCPU +4GB of memory. The value range is an integer greater than or equal to 2. **NOTE:** Enter this parameter and enable ETL to clean and convert data.
     */
    public val computeUnit: Output<Int>?
        get() = javaResource.computeUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance creation time
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The number of private custom RDS instances in the PolarDB-X. The default value is **1**. **NOTE:** This parameter is required only when **source_endpoint_engine_name** is **DRDS**.
     */
    public val databaseCount: Output<Int>
        get() = javaResource.databaseCount().applyValue({ args0 -> args0 })

    /**
     * The target database engine type.
     * - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
     * - **PolarDB**:PolarDB MySQL.
     * - **polardb_o**:PolarDB O engine.
     * - **polardb_pg**:PolarDB PostgreSQL.
     * - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
     * - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
     * - **PostgreSQL**: User-created PostgreSQL.
     * - **ODPS**:MaxCompute project.
     * - **oracle**: self-built Oracle.
     * - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
     * - **tidb**:TiDB database.
     * - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
     * - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
     * - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
     * - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
     * - **kafka**:Kafka databases (including Kafka and self-built Kafka).
     * - **DataHub**: DataHub, an Alibaba cloud streaming data service.
     * - **clickhouse**: ClickHouse.
     * - **DB2**: self-built DB2 LUW.
     * - **as400**:AS/400.
     * - **Tablestore**: Tablestore.
     * - **NOTE:**
     * - The default value is **MySQL**.
     * - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www&#46;alibabacloud&#46;com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
     * - This parameter or **job_id** must be passed in.
     */
    public val destinationEndpointEngineName: Output<String>
        get() = javaResource.destinationEndpointEngineName().applyValue({ args0 -> args0 })

    /**
     * The target instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
     */
    public val destinationRegion: Output<String>?
        get() = javaResource.destinationRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the subscription instance.
     */
    public val dtsInstanceId: Output<String>
        get() = javaResource.dtsInstanceId().applyValue({ args0 -> args0 })

    /**
     * Assign a specified number of DU resources to DTS tasks in the DTS exclusive cluster. Valid values: **1** ~ **100**. **NOTE:** The value of this parameter must be within the range of the number of DUs available for the DTS dedicated cluster.
     */
    public val du: Output<Int>?
        get() = javaResource.du().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Subscription billing type, Valid values: `ONLY_CONFIGURATION_FEE`: charges only configuration fees; `CONFIGURATION_FEE_AND_DATA_FEE`: charges configuration fees and data traffic fees.
     */
    public val feeType: Output<String>?
        get() = javaResource.feeType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the migration or synchronization instance.
     * - The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.
     * - The types of synchronization instances: **large**, **medium**, **small**, **micro**.
     * - **NOTE:** For performance descriptions of different specifications, see [Data Migration Link Specifications](https://www&#46;alibabacloud&#46;com/help/en/data-transmission-service/latest/cd773b) and [Data Synchronization Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/6bce7c).
     */
    public val instanceClass: Output<String>?
        get() = javaResource.instanceClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of Dts instance.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * The ID of the task obtained by calling the **ConfigureDtsJob** operation (**DtsJobId**).> After you pass in this parameter, you do not need to pass the **source_region**, **destination_region**, **type**, **source_endpoint_engine_name**, or **destination_endpoint_engine_name** parameters. Even if the input is passed in, the configuration in **job_id** shall prevail.
     */
    public val jobId: Output<String>?
        get() = javaResource.jobId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
     */
    public val paymentType: Output<String>?
        get() = javaResource.paymentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The billing method of the subscription instance. Value: `Year`, `Month`. **NOTE:** This parameter is valid and must be passed in only when `payment_type` is `Subscription`.
     */
    public val period: Output<String>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Group ID.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Source instance database engine type.
     * - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
     * - **PolarDB**:PolarDB MySQL.
     * - **polardb_o**:PolarDB O engine.
     * - **polardb_pg**:PolarDB PostgreSQL.
     * - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
     * - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
     * - **PostgreSQL**: User-created PostgreSQL.
     * - **ODPS**:MaxCompute.
     * - **oracle**: self-built Oracle.
     * - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
     * - **tidb**:TiDB database.
     * - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
     * - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
     * - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
     * - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
     * - **kafka**:Kafka databases (including Kafka and self-built Kafka).
     * - **DataHub**: DataHub, an Alibaba cloud streaming data service.
     * - **clickhouse**: ClickHouse.
     * - **DB2**: self-built DB2 LUW.
     * - **as400**:AS/400.
     * - **Tablestore**: Tablestore.
     * - **NOTE:**
     * - The default value is **MySQL**.
     * - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www&#46;alibabacloud&#46;com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
     * - This parameter or **job_id** must be passed in.
     */
    public val sourceEndpointEngineName: Output<String>
        get() = javaResource.sourceEndpointEngineName().applyValue({ args0 -> args0 })

    /**
     * The source instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
     */
    public val sourceRegion: Output<String>?
        get() = javaResource.sourceRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Synchronization topology, value:
     * - **oneway**: one-way synchronization, the default value.
     * - **bidirectional**: two-way synchronization.
     */
    public val syncArchitecture: Output<String>?
        get() = javaResource.syncArchitecture().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The synchronization direction. Default value: `Forward`. Valid values:
     * - `Forward`: Data is synchronized from the source database to the destination database.
     * - `Reverse`: Data is synchronized from the destination database to the source database.
     * - **NOTE:** You can set this parameter to Reverse to delete the reverse synchronization task only if the topology is two-way synchronization.
     */
    public val synchronizationDirection: Output<String>?
        get() = javaResource.synchronizationDirection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The tag value corresponding to the tag key.See the following `Block Tags`.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The instance type. Valid values:
     * - **migration**: MIGRATION.
     * - **sync**: synchronization.
     * - **subscribe**: SUBSCRIBE.
     * - **NOTE:** This parameter or **job_id** must be passed in.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Prepaid instance purchase duration.
     * - When **period** is **Month**, the values are: 1, 2, 3, 4, 5, 6, 7, 8, and 9.
     * - When **Period** is **Year**, the values are 1, 2, 3, and 5.
     * - **NOTE:**
     * - This parameter is valid and must be passed in only when **payment_type** is `Subscription`.
     * - The billing method of the subscription instance. You can set the parameter `period`.
     */
    public val usedTime: Output<Int>?
        get() = javaResource.usedTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dts.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.dts.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
