@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin

import com.pulumi.alicloud.dts.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Dts Instance resource.
 * For information about Dts Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/en/data-transmission-service/latest/createdtsinstance).
 * > **NOTE:** Available since v1.198.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultGetRegions = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultInstance = new alicloud.dts.Instance("default", {
 *     type: "sync",
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     paymentType: "Subscription",
 *     instanceClass: "large",
 *     sourceEndpointEngineName: "MySQL",
 *     sourceRegion: defaultGetRegions.then(defaultGetRegions => defaultGetRegions.regions?.[0]?.id),
 *     destinationEndpointEngineName: "MySQL",
 *     destinationRegion: defaultGetRegions.then(defaultGetRegions => defaultGetRegions.regions?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_get_regions = alicloud.get_regions(current=True)
 * default_instance = alicloud.dts.Instance("default",
 *     type="sync",
 *     resource_group_id=default.ids[0],
 *     payment_type="Subscription",
 *     instance_class="large",
 *     source_endpoint_engine_name="MySQL",
 *     source_region=default_get_regions.regions[0].id,
 *     destination_endpoint_engine_name="MySQL",
 *     destination_region=default_get_regions.regions[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultGetRegions = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultInstance = new AliCloud.Dts.Instance("default", new()
 *     {
 *         Type = "sync",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         PaymentType = "Subscription",
 *         InstanceClass = "large",
 *         SourceEndpointEngineName = "MySQL",
 *         SourceRegion = defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id),
 *         DestinationEndpointEngineName = "MySQL",
 *         DestinationRegion = defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dts"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetRegions, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dts.NewInstance(ctx, "default", &dts.InstanceArgs{
 * 			Type:                          pulumi.String("sync"),
 * 			ResourceGroupId:               pulumi.String(_default.Ids[0]),
 * 			PaymentType:                   pulumi.String("Subscription"),
 * 			InstanceClass:                 pulumi.String("large"),
 * 			SourceEndpointEngineName:      pulumi.String("MySQL"),
 * 			SourceRegion:                  pulumi.String(defaultGetRegions.Regions[0].Id),
 * 			DestinationEndpointEngineName: pulumi.String("MySQL"),
 * 			DestinationRegion:             pulumi.String(defaultGetRegions.Regions[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.dts.Instance;
 * import com.pulumi.alicloud.dts.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         final var defaultGetRegions = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .type("sync")
 *             .resourceGroupId(default_.ids()[0])
 *             .paymentType("Subscription")
 *             .instanceClass("large")
 *             .sourceEndpointEngineName("MySQL")
 *             .sourceRegion(defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()))
 *             .destinationEndpointEngineName("MySQL")
 *             .destinationRegion(defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultInstance:
 *     type: alicloud:dts:Instance
 *     name: default
 *     properties:
 *       type: sync
 *       resourceGroupId: ${default.ids[0]}
 *       paymentType: Subscription
 *       instanceClass: large
 *       sourceEndpointEngineName: MySQL
 *       sourceRegion: ${defaultGetRegions.regions[0].id}
 *       destinationEndpointEngineName: MySQL
 *       destinationRegion: ${defaultGetRegions.regions[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 *   defaultGetRegions:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Dts Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dts/instance:Instance example <id>
 * ```
 * @property autoPay Whether to automatically renew the fee when it expires. Valid values:
 * - **false**: No, the default value.
 * - **true**: Yes.
 * @property autoStart Whether to start the task automatically after the purchase is completed. Value:
 * - **false**: No, the default value.
 * - **true**: Yes.
 * @property computeUnit Specifications of ETL. The unit is compute unit (CU),1CU = 1vCPU +4GB of memory. The value range is an integer greater than or equal to 2. **NOTE:** Enter this parameter and enable ETL to clean and convert data.
 * @property databaseCount The number of private custom RDS instances in the PolarDB-X. The default value is **1**. **NOTE:** This parameter is required only when **source_endpoint_engine_name** is **DRDS**.
 * @property destinationEndpointEngineName The target database engine type.
 * - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
 * - **PolarDB**:PolarDB MySQL.
 * - **polardb_o**:PolarDB O engine.
 * - **polardb_pg**:PolarDB PostgreSQL.
 * - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
 * - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
 * - **PostgreSQL**: User-created PostgreSQL.
 * - **ODPS**:MaxCompute project.
 * - **oracle**: self-built Oracle.
 * - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
 * - **tidb**:TiDB database.
 * - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
 * - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
 * - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
 * - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
 * - **kafka**:Kafka databases (including Kafka and self-built Kafka).
 * - **DataHub**: DataHub, an Alibaba cloud streaming data service.
 * - **clickhouse**: ClickHouse.
 * - **DB2**: self-built DB2 LUW.
 * - **as400**:AS/400.
 * - **Tablestore**: Tablestore.
 * - **NOTE:**
 * - The default value is **MySQL**.
 * - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www&#46;alibabacloud&#46;com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
 * - This parameter or **job_id** must be passed in.
 * @property destinationRegion The target instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
 * @property du Assign a specified number of DU resources to DTS tasks in the DTS exclusive cluster. Valid values: **1** ~ **100**. **NOTE:** The value of this parameter must be within the range of the number of DUs available for the DTS dedicated cluster.
 * @property feeType Subscription billing type, Valid values: `ONLY_CONFIGURATION_FEE`: charges only configuration fees; `CONFIGURATION_FEE_AND_DATA_FEE`: charges configuration fees and data traffic fees.
 * @property instanceClass The type of the migration or synchronization instance.
 * - The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.
 * - The types of synchronization instances: **large**, **medium**, **small**, **micro**.
 * - **NOTE:** For performance descriptions of different specifications, see [Data Migration Link Specifications](https://www&#46;alibabacloud&#46;com/help/en/data-transmission-service/latest/cd773b) and [Data Synchronization Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/6bce7c).
 * @property jobId The ID of the task obtained by calling the **ConfigureDtsJob** operation (**DtsJobId**).> After you pass in this parameter, you do not need to pass the **source_region**, **destination_region**, **type**, **source_endpoint_engine_name**, or **destination_endpoint_engine_name** parameters. Even if the input is passed in, the configuration in **job_id** shall prevail.
 * @property paymentType The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
 * @property period The billing method of the subscription instance. Value: `Year`, `Month`. **NOTE:** This parameter is valid and must be passed in only when `payment_type` is `Subscription`.
 * @property resourceGroupId Resource Group ID.
 * @property sourceEndpointEngineName Source instance database engine type.
 * - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
 * - **PolarDB**:PolarDB MySQL.
 * - **polardb_o**:PolarDB O engine.
 * - **polardb_pg**:PolarDB PostgreSQL.
 * - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
 * - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
 * - **PostgreSQL**: User-created PostgreSQL.
 * - **ODPS**:MaxCompute.
 * - **oracle**: self-built Oracle.
 * - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
 * - **tidb**:TiDB database.
 * - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
 * - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
 * - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
 * - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
 * - **kafka**:Kafka databases (including Kafka and self-built Kafka).
 * - **DataHub**: DataHub, an Alibaba cloud streaming data service.
 * - **clickhouse**: ClickHouse.
 * - **DB2**: self-built DB2 LUW.
 * - **as400**:AS/400.
 * - **Tablestore**: Tablestore.
 * - **NOTE:**
 * - The default value is **MySQL**.
 * - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www&#46;alibabacloud&#46;com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
 * - This parameter or **job_id** must be passed in.
 * @property sourceRegion The source instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
 * @property syncArchitecture Synchronization topology, value:
 * - **oneway**: one-way synchronization, the default value.
 * - **bidirectional**: two-way synchronization.
 * @property synchronizationDirection The synchronization direction. Default value: `Forward`. Valid values:
 * - `Forward`: Data is synchronized from the source database to the destination database.
 * - `Reverse`: Data is synchronized from the destination database to the source database.
 * - **NOTE:** You can set this parameter to Reverse to delete the reverse synchronization task only if the topology is two-way synchronization.
 * @property tags The tag value corresponding to the tag key.See the following `Block Tags`.
 * @property type The instance type. Valid values:
 * - **migration**: MIGRATION.
 * - **sync**: synchronization.
 * - **subscribe**: SUBSCRIBE.
 * - **NOTE:** This parameter or **job_id** must be passed in.
 * @property usedTime Prepaid instance purchase duration.
 * - When **period** is **Month**, the values are: 1, 2, 3, 4, 5, 6, 7, 8, and 9.
 * - When **Period** is **Year**, the values are 1, 2, 3, and 5.
 * - **NOTE:**
 * - This parameter is valid and must be passed in only when **payment_type** is `Subscription`.
 * - The billing method of the subscription instance. You can set the parameter `period`.
 */
public data class InstanceArgs(
    public val autoPay: Output<Boolean>? = null,
    public val autoStart: Output<Boolean>? = null,
    public val computeUnit: Output<Int>? = null,
    public val databaseCount: Output<Int>? = null,
    public val destinationEndpointEngineName: Output<String>? = null,
    public val destinationRegion: Output<String>? = null,
    public val du: Output<Int>? = null,
    public val feeType: Output<String>? = null,
    public val instanceClass: Output<String>? = null,
    public val jobId: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val sourceEndpointEngineName: Output<String>? = null,
    public val sourceRegion: Output<String>? = null,
    public val syncArchitecture: Output<String>? = null,
    public val synchronizationDirection: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val usedTime: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dts.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.dts.InstanceArgs =
        com.pulumi.alicloud.dts.InstanceArgs.builder()
            .autoPay(autoPay?.applyValue({ args0 -> args0 }))
            .autoStart(autoStart?.applyValue({ args0 -> args0 }))
            .computeUnit(computeUnit?.applyValue({ args0 -> args0 }))
            .databaseCount(databaseCount?.applyValue({ args0 -> args0 }))
            .destinationEndpointEngineName(destinationEndpointEngineName?.applyValue({ args0 -> args0 }))
            .destinationRegion(destinationRegion?.applyValue({ args0 -> args0 }))
            .du(du?.applyValue({ args0 -> args0 }))
            .feeType(feeType?.applyValue({ args0 -> args0 }))
            .instanceClass(instanceClass?.applyValue({ args0 -> args0 }))
            .jobId(jobId?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .sourceEndpointEngineName(sourceEndpointEngineName?.applyValue({ args0 -> args0 }))
            .sourceRegion(sourceRegion?.applyValue({ args0 -> args0 }))
            .syncArchitecture(syncArchitecture?.applyValue({ args0 -> args0 }))
            .synchronizationDirection(synchronizationDirection?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .usedTime(usedTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var autoPay: Output<Boolean>? = null

    private var autoStart: Output<Boolean>? = null

    private var computeUnit: Output<Int>? = null

    private var databaseCount: Output<Int>? = null

    private var destinationEndpointEngineName: Output<String>? = null

    private var destinationRegion: Output<String>? = null

    private var du: Output<Int>? = null

    private var feeType: Output<String>? = null

    private var instanceClass: Output<String>? = null

    private var jobId: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var sourceEndpointEngineName: Output<String>? = null

    private var sourceRegion: Output<String>? = null

    private var syncArchitecture: Output<String>? = null

    private var synchronizationDirection: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var usedTime: Output<Int>? = null

    /**
     * @param value Whether to automatically renew the fee when it expires. Valid values:
     * - **false**: No, the default value.
     * - **true**: Yes.
     */
    @JvmName("pdicsjnkgtxovsnn")
    public suspend fun autoPay(`value`: Output<Boolean>) {
        this.autoPay = value
    }

    /**
     * @param value Whether to start the task automatically after the purchase is completed. Value:
     * - **false**: No, the default value.
     * - **true**: Yes.
     */
    @JvmName("pglqxrqbcnnthbiy")
    public suspend fun autoStart(`value`: Output<Boolean>) {
        this.autoStart = value
    }

    /**
     * @param value Specifications of ETL. The unit is compute unit (CU),1CU = 1vCPU +4GB of memory. The value range is an integer greater than or equal to 2. **NOTE:** Enter this parameter and enable ETL to clean and convert data.
     */
    @JvmName("gylvyrfgnufihdae")
    public suspend fun computeUnit(`value`: Output<Int>) {
        this.computeUnit = value
    }

    /**
     * @param value The number of private custom RDS instances in the PolarDB-X. The default value is **1**. **NOTE:** This parameter is required only when **source_endpoint_engine_name** is **DRDS**.
     */
    @JvmName("lpkiecqwdprarqou")
    public suspend fun databaseCount(`value`: Output<Int>) {
        this.databaseCount = value
    }

    /**
     * @param value The target database engine type.
     * - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
     * - **PolarDB**:PolarDB MySQL.
     * - **polardb_o**:PolarDB O engine.
     * - **polardb_pg**:PolarDB PostgreSQL.
     * - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
     * - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
     * - **PostgreSQL**: User-created PostgreSQL.
     * - **ODPS**:MaxCompute project.
     * - **oracle**: self-built Oracle.
     * - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
     * - **tidb**:TiDB database.
     * - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
     * - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
     * - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
     * - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
     * - **kafka**:Kafka databases (including Kafka and self-built Kafka).
     * - **DataHub**: DataHub, an Alibaba cloud streaming data service.
     * - **clickhouse**: ClickHouse.
     * - **DB2**: self-built DB2 LUW.
     * - **as400**:AS/400.
     * - **Tablestore**: Tablestore.
     * - **NOTE:**
     * - The default value is **MySQL**.
     * - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www&#46;alibabacloud&#46;com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
     * - This parameter or **job_id** must be passed in.
     */
    @JvmName("ewnxxergixvprgjc")
    public suspend fun destinationEndpointEngineName(`value`: Output<String>) {
        this.destinationEndpointEngineName = value
    }

    /**
     * @param value The target instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
     */
    @JvmName("bwaggjaiprhcwsic")
    public suspend fun destinationRegion(`value`: Output<String>) {
        this.destinationRegion = value
    }

    /**
     * @param value Assign a specified number of DU resources to DTS tasks in the DTS exclusive cluster. Valid values: **1** ~ **100**. **NOTE:** The value of this parameter must be within the range of the number of DUs available for the DTS dedicated cluster.
     */
    @JvmName("kocmsgmhiesjdabu")
    public suspend fun du(`value`: Output<Int>) {
        this.du = value
    }

    /**
     * @param value Subscription billing type, Valid values: `ONLY_CONFIGURATION_FEE`: charges only configuration fees; `CONFIGURATION_FEE_AND_DATA_FEE`: charges configuration fees and data traffic fees.
     */
    @JvmName("scksiomwqeofacnn")
    public suspend fun feeType(`value`: Output<String>) {
        this.feeType = value
    }

    /**
     * @param value The type of the migration or synchronization instance.
     * - The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.
     * - The types of synchronization instances: **large**, **medium**, **small**, **micro**.
     * - **NOTE:** For performance descriptions of different specifications, see [Data Migration Link Specifications](https://www&#46;alibabacloud&#46;com/help/en/data-transmission-service/latest/cd773b) and [Data Synchronization Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/6bce7c).
     */
    @JvmName("xxjwakvhqrnpunyb")
    public suspend fun instanceClass(`value`: Output<String>) {
        this.instanceClass = value
    }

    /**
     * @param value The ID of the task obtained by calling the **ConfigureDtsJob** operation (**DtsJobId**).> After you pass in this parameter, you do not need to pass the **source_region**, **destination_region**, **type**, **source_endpoint_engine_name**, or **destination_endpoint_engine_name** parameters. Even if the input is passed in, the configuration in **job_id** shall prevail.
     */
    @JvmName("jmwsluypbfhsuspd")
    public suspend fun jobId(`value`: Output<String>) {
        this.jobId = value
    }

    /**
     * @param value The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
     */
    @JvmName("ttanwyvlfhluwvwn")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The billing method of the subscription instance. Value: `Year`, `Month`. **NOTE:** This parameter is valid and must be passed in only when `payment_type` is `Subscription`.
     */
    @JvmName("lsktguuyavpjqbjn")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value Resource Group ID.
     */
    @JvmName("hqdisrwfgfdvvmml")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Source instance database engine type.
     * - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
     * - **PolarDB**:PolarDB MySQL.
     * - **polardb_o**:PolarDB O engine.
     * - **polardb_pg**:PolarDB PostgreSQL.
     * - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
     * - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
     * - **PostgreSQL**: User-created PostgreSQL.
     * - **ODPS**:MaxCompute.
     * - **oracle**: self-built Oracle.
     * - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
     * - **tidb**:TiDB database.
     * - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
     * - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
     * - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
     * - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
     * - **kafka**:Kafka databases (including Kafka and self-built Kafka).
     * - **DataHub**: DataHub, an Alibaba cloud streaming data service.
     * - **clickhouse**: ClickHouse.
     * - **DB2**: self-built DB2 LUW.
     * - **as400**:AS/400.
     * - **Tablestore**: Tablestore.
     * - **NOTE:**
     * - The default value is **MySQL**.
     * - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www&#46;alibabacloud&#46;com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
     * - This parameter or **job_id** must be passed in.
     */
    @JvmName("qgakmdtjikwvpwqk")
    public suspend fun sourceEndpointEngineName(`value`: Output<String>) {
        this.sourceEndpointEngineName = value
    }

    /**
     * @param value The source instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
     */
    @JvmName("brgkgyxenpemquvs")
    public suspend fun sourceRegion(`value`: Output<String>) {
        this.sourceRegion = value
    }

    /**
     * @param value Synchronization topology, value:
     * - **oneway**: one-way synchronization, the default value.
     * - **bidirectional**: two-way synchronization.
     */
    @JvmName("qtrlnxhbwvyilicg")
    public suspend fun syncArchitecture(`value`: Output<String>) {
        this.syncArchitecture = value
    }

    /**
     * @param value The synchronization direction. Default value: `Forward`. Valid values:
     * - `Forward`: Data is synchronized from the source database to the destination database.
     * - `Reverse`: Data is synchronized from the destination database to the source database.
     * - **NOTE:** You can set this parameter to Reverse to delete the reverse synchronization task only if the topology is two-way synchronization.
     */
    @JvmName("fwvsmjxixwlqjhdf")
    public suspend fun synchronizationDirection(`value`: Output<String>) {
        this.synchronizationDirection = value
    }

    /**
     * @param value The tag value corresponding to the tag key.See the following `Block Tags`.
     */
    @JvmName("wbfqbbevlmfcucxl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The instance type. Valid values:
     * - **migration**: MIGRATION.
     * - **sync**: synchronization.
     * - **subscribe**: SUBSCRIBE.
     * - **NOTE:** This parameter or **job_id** must be passed in.
     */
    @JvmName("varcxpairjledoka")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Prepaid instance purchase duration.
     * - When **period** is **Month**, the values are: 1, 2, 3, 4, 5, 6, 7, 8, and 9.
     * - When **Period** is **Year**, the values are 1, 2, 3, and 5.
     * - **NOTE:**
     * - This parameter is valid and must be passed in only when **payment_type** is `Subscription`.
     * - The billing method of the subscription instance. You can set the parameter `period`.
     */
    @JvmName("rdcduncfhwpnfjkq")
    public suspend fun usedTime(`value`: Output<Int>) {
        this.usedTime = value
    }

    /**
     * @param value Whether to automatically renew the fee when it expires. Valid values:
     * - **false**: No, the default value.
     * - **true**: Yes.
     */
    @JvmName("vtqpakywfrxnhrne")
    public suspend fun autoPay(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPay = mapped
    }

    /**
     * @param value Whether to start the task automatically after the purchase is completed. Value:
     * - **false**: No, the default value.
     * - **true**: Yes.
     */
    @JvmName("gejnqycdvvwgfvnf")
    public suspend fun autoStart(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoStart = mapped
    }

    /**
     * @param value Specifications of ETL. The unit is compute unit (CU),1CU = 1vCPU +4GB of memory. The value range is an integer greater than or equal to 2. **NOTE:** Enter this parameter and enable ETL to clean and convert data.
     */
    @JvmName("gfismuwqrdmgclhp")
    public suspend fun computeUnit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeUnit = mapped
    }

    /**
     * @param value The number of private custom RDS instances in the PolarDB-X. The default value is **1**. **NOTE:** This parameter is required only when **source_endpoint_engine_name** is **DRDS**.
     */
    @JvmName("xlbinjhevvyhkppf")
    public suspend fun databaseCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseCount = mapped
    }

    /**
     * @param value The target database engine type.
     * - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
     * - **PolarDB**:PolarDB MySQL.
     * - **polardb_o**:PolarDB O engine.
     * - **polardb_pg**:PolarDB PostgreSQL.
     * - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
     * - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
     * - **PostgreSQL**: User-created PostgreSQL.
     * - **ODPS**:MaxCompute project.
     * - **oracle**: self-built Oracle.
     * - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
     * - **tidb**:TiDB database.
     * - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
     * - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
     * - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
     * - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
     * - **kafka**:Kafka databases (including Kafka and self-built Kafka).
     * - **DataHub**: DataHub, an Alibaba cloud streaming data service.
     * - **clickhouse**: ClickHouse.
     * - **DB2**: self-built DB2 LUW.
     * - **as400**:AS/400.
     * - **Tablestore**: Tablestore.
     * - **NOTE:**
     * - The default value is **MySQL**.
     * - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www&#46;alibabacloud&#46;com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
     * - This parameter or **job_id** must be passed in.
     */
    @JvmName("jdqnvriqqnumdreb")
    public suspend fun destinationEndpointEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointEngineName = mapped
    }

    /**
     * @param value The target instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
     */
    @JvmName("utsqecgbpibgquhl")
    public suspend fun destinationRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationRegion = mapped
    }

    /**
     * @param value Assign a specified number of DU resources to DTS tasks in the DTS exclusive cluster. Valid values: **1** ~ **100**. **NOTE:** The value of this parameter must be within the range of the number of DUs available for the DTS dedicated cluster.
     */
    @JvmName("jddqbdhubgxdlafw")
    public suspend fun du(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.du = mapped
    }

    /**
     * @param value Subscription billing type, Valid values: `ONLY_CONFIGURATION_FEE`: charges only configuration fees; `CONFIGURATION_FEE_AND_DATA_FEE`: charges configuration fees and data traffic fees.
     */
    @JvmName("clndxbbvtfpnnfvj")
    public suspend fun feeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.feeType = mapped
    }

    /**
     * @param value The type of the migration or synchronization instance.
     * - The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.
     * - The types of synchronization instances: **large**, **medium**, **small**, **micro**.
     * - **NOTE:** For performance descriptions of different specifications, see [Data Migration Link Specifications](https://www&#46;alibabacloud&#46;com/help/en/data-transmission-service/latest/cd773b) and [Data Synchronization Link Specifications](https://www.alibabacloud.com/help/en/data-transmission-service/latest/6bce7c).
     */
    @JvmName("yqvcltfauflammvn")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceClass = mapped
    }

    /**
     * @param value The ID of the task obtained by calling the **ConfigureDtsJob** operation (**DtsJobId**).> After you pass in this parameter, you do not need to pass the **source_region**, **destination_region**, **type**, **source_endpoint_engine_name**, or **destination_endpoint_engine_name** parameters. Even if the input is passed in, the configuration in **job_id** shall prevail.
     */
    @JvmName("hjupfcjgkiglahmr")
    public suspend fun jobId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobId = mapped
    }

    /**
     * @param value The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
     */
    @JvmName("pcfftkkxuyhhppyd")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The billing method of the subscription instance. Value: `Year`, `Month`. **NOTE:** This parameter is valid and must be passed in only when `payment_type` is `Subscription`.
     */
    @JvmName("lcdhilavcnsrsjio")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Resource Group ID.
     */
    @JvmName("aernddmkpsuutuik")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Source instance database engine type.
     * - **MySQL**:MySQL databases (including RDS MySQL and self-built MySQL).
     * - **PolarDB**:PolarDB MySQL.
     * - **polardb_o**:PolarDB O engine.
     * - **polardb_pg**:PolarDB PostgreSQL.
     * - **Redis**:Redis databases (including apsaradb for Redis and user-created Redis).
     * - **DRDS**: cloud-native distributed database PolarDB-X 1.0 and 2.0.
     * - **PostgreSQL**: User-created PostgreSQL.
     * - **ODPS**:MaxCompute.
     * - **oracle**: self-built Oracle.
     * - **mongodb**:MongoDB databases (including apsaradb for MongoDB and user-created MongoDB).
     * - **tidb**:TiDB database.
     * - **ADS**: Cloud native data warehouse AnalyticDB MySQL 2.0.
     * - **ADB30**: Cloud native data warehouse AnalyticDB MySQL 3.0.
     * - **Greenplum**: Cloud native data warehouse AnalyticDB PostgreSQL.
     * - **MSSQL**:SQL Server databases (including RDS SQL Server and self-built SQL Server).
     * - **kafka**:Kafka databases (including Kafka and self-built Kafka).
     * - **DataHub**: DataHub, an Alibaba cloud streaming data service.
     * - **clickhouse**: ClickHouse.
     * - **DB2**: self-built DB2 LUW.
     * - **as400**:AS/400.
     * - **Tablestore**: Tablestore.
     * - **NOTE:**
     * - The default value is **MySQL**.
     * - For more information about the supported source and destination databases, see [Database, Synchronization Initialization Type, and Synchronization Topology](https://www&#46;alibabacloud&#46;com/help/en/data-transmission-service/latest/overview-of-data-synchronization-scenarios-1) and [Supported Database and Migration Type](https://www.alibabacloud.com/help/en/data-transmission-service/latest/overview-of-data-migration-scenarios).
     * - This parameter or **job_id** must be passed in.
     */
    @JvmName("smmsdtxlnrfttbne")
    public suspend fun sourceEndpointEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointEngineName = mapped
    }

    /**
     * @param value The source instance region. For more information, see [List of supported regions](https://www.alibabacloud.com/help/en/data-transmission-service/latest/list-of-supported-regions). **NOTE:** This parameter or **job_id** must be passed in.
     */
    @JvmName("avqrybcaogvbsriy")
    public suspend fun sourceRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRegion = mapped
    }

    /**
     * @param value Synchronization topology, value:
     * - **oneway**: one-way synchronization, the default value.
     * - **bidirectional**: two-way synchronization.
     */
    @JvmName("tvrybsfaifwayeqm")
    public suspend fun syncArchitecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncArchitecture = mapped
    }

    /**
     * @param value The synchronization direction. Default value: `Forward`. Valid values:
     * - `Forward`: Data is synchronized from the source database to the destination database.
     * - `Reverse`: Data is synchronized from the destination database to the source database.
     * - **NOTE:** You can set this parameter to Reverse to delete the reverse synchronization task only if the topology is two-way synchronization.
     */
    @JvmName("sdmcayfqyekfcnqb")
    public suspend fun synchronizationDirection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synchronizationDirection = mapped
    }

    /**
     * @param value The tag value corresponding to the tag key.See the following `Block Tags`.
     */
    @JvmName("tqaxevtuihbiuvqk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag value corresponding to the tag key.See the following `Block Tags`.
     */
    @JvmName("ghqpsjiuslnlpxkb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The instance type. Valid values:
     * - **migration**: MIGRATION.
     * - **sync**: synchronization.
     * - **subscribe**: SUBSCRIBE.
     * - **NOTE:** This parameter or **job_id** must be passed in.
     */
    @JvmName("oxiwllxarsnceqmb")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Prepaid instance purchase duration.
     * - When **period** is **Month**, the values are: 1, 2, 3, 4, 5, 6, 7, 8, and 9.
     * - When **Period** is **Year**, the values are 1, 2, 3, and 5.
     * - **NOTE:**
     * - This parameter is valid and must be passed in only when **payment_type** is `Subscription`.
     * - The billing method of the subscription instance. You can set the parameter `period`.
     */
    @JvmName("aobhrctsjxvumihn")
    public suspend fun usedTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usedTime = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        autoPay = autoPay,
        autoStart = autoStart,
        computeUnit = computeUnit,
        databaseCount = databaseCount,
        destinationEndpointEngineName = destinationEndpointEngineName,
        destinationRegion = destinationRegion,
        du = du,
        feeType = feeType,
        instanceClass = instanceClass,
        jobId = jobId,
        paymentType = paymentType,
        period = period,
        resourceGroupId = resourceGroupId,
        sourceEndpointEngineName = sourceEndpointEngineName,
        sourceRegion = sourceRegion,
        syncArchitecture = syncArchitecture,
        synchronizationDirection = synchronizationDirection,
        tags = tags,
        type = type,
        usedTime = usedTime,
    )
}
