@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [JobMonitorRule].
 */
@PulumiTagMarker
public class JobMonitorRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobMonitorRuleArgs = JobMonitorRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobMonitorRuleArgsBuilder.() -> Unit) {
        val builder = JobMonitorRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): JobMonitorRule {
        val builtJavaResource = com.pulumi.alicloud.dts.JobMonitorRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobMonitorRule(builtJavaResource)
    }
}

/**
 * Provides a DTS Job Monitor Rule resource.
 * For information about DTS Job Monitor Rule and how to use it, see [What is Job Monitor Rule](https://www.aliyun.com/product/dts).
 * > **NOTE:** Available since v1.134.0.
 * ## Import
 * DTS Job Monitor Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dts/jobMonitorRule:JobMonitorRule example <dts_job_id>
 * ```
 */
public class JobMonitorRule internal constructor(
    override val javaResource: com.pulumi.alicloud.dts.JobMonitorRule,
) : KotlinCustomResource(javaResource, JobMonitorRuleMapper) {
    /**
     * Trigger delay alarm threshold, which is measured in seconds.
     */
    public val delayRuleTime: Output<String>
        get() = javaResource.delayRuleTime().applyValue({ args0 -> args0 })

    /**
     * Migration, synchronization or subscription task ID can be by calling the [DescribeDtsJobs] get.
     */
    public val dtsJobId: Output<String>
        get() = javaResource.dtsJobId().applyValue({ args0 -> args0 })

    /**
     * The alarm is triggered after notification of the contact phone number, A plurality of phone numbers between them with a comma (,) to separate.
     */
    public val phone: Output<String>?
        get() = javaResource.phone().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to enable monitoring rules, valid values: `Y`, `N`.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Monitoring rules of type, valid values: `delay`, `error`. **delay**: delay alarm. **error**: abnormal alarm.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobMonitorRuleMapper : ResourceMapper<JobMonitorRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dts.JobMonitorRule::class == javaResource::class

    override fun map(javaResource: Resource): JobMonitorRule = JobMonitorRule(
        javaResource as
            com.pulumi.alicloud.dts.JobMonitorRule,
    )
}

/**
 * @see [JobMonitorRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobMonitorRule].
 */
public suspend fun jobMonitorRule(
    name: String,
    block: suspend JobMonitorRuleResourceBuilder.() -> Unit,
): JobMonitorRule {
    val builder = JobMonitorRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobMonitorRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobMonitorRule(name: String): JobMonitorRule {
    val builder = JobMonitorRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
