@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin

import com.pulumi.alicloud.dts.JobMonitorRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DTS Job Monitor Rule resource.
 * For information about DTS Job Monitor Rule and how to use it, see [What is Job Monitor Rule](https://www.aliyun.com/product/dts).
 * > **NOTE:** Available since v1.134.0.
 * ## Import
 * DTS Job Monitor Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dts/jobMonitorRule:JobMonitorRule example <dts_job_id>
 * ```
 * @property delayRuleTime Trigger delay alarm threshold, which is measured in seconds.
 * @property dtsJobId Migration, synchronization or subscription task ID can be by calling the [DescribeDtsJobs] get.
 * @property phone The alarm is triggered after notification of the contact phone number, A plurality of phone numbers between them with a comma (,) to separate.
 * @property state Whether to enable monitoring rules, valid values: `Y`, `N`.
 * @property type Monitoring rules of type, valid values: `delay`, `error`. **delay**: delay alarm. **error**: abnormal alarm.
 */
public data class JobMonitorRuleArgs(
    public val delayRuleTime: Output<String>? = null,
    public val dtsJobId: Output<String>? = null,
    public val phone: Output<String>? = null,
    public val state: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dts.JobMonitorRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.dts.JobMonitorRuleArgs =
        com.pulumi.alicloud.dts.JobMonitorRuleArgs.builder()
            .delayRuleTime(delayRuleTime?.applyValue({ args0 -> args0 }))
            .dtsJobId(dtsJobId?.applyValue({ args0 -> args0 }))
            .phone(phone?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobMonitorRuleArgs].
 */
@PulumiTagMarker
public class JobMonitorRuleArgsBuilder internal constructor() {
    private var delayRuleTime: Output<String>? = null

    private var dtsJobId: Output<String>? = null

    private var phone: Output<String>? = null

    private var state: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Trigger delay alarm threshold, which is measured in seconds.
     */
    @JvmName("qquxqbftcuesgrdn")
    public suspend fun delayRuleTime(`value`: Output<String>) {
        this.delayRuleTime = value
    }

    /**
     * @param value Migration, synchronization or subscription task ID can be by calling the [DescribeDtsJobs] get.
     */
    @JvmName("xdfebyhxjuoljovk")
    public suspend fun dtsJobId(`value`: Output<String>) {
        this.dtsJobId = value
    }

    /**
     * @param value The alarm is triggered after notification of the contact phone number, A plurality of phone numbers between them with a comma (,) to separate.
     */
    @JvmName("sxboomiqxgnowohx")
    public suspend fun phone(`value`: Output<String>) {
        this.phone = value
    }

    /**
     * @param value Whether to enable monitoring rules, valid values: `Y`, `N`.
     */
    @JvmName("pjeyylgmcnlohpyh")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value Monitoring rules of type, valid values: `delay`, `error`. **delay**: delay alarm. **error**: abnormal alarm.
     */
    @JvmName("joryioipommjdnqw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Trigger delay alarm threshold, which is measured in seconds.
     */
    @JvmName("bmfnvvdmjvyhbbbg")
    public suspend fun delayRuleTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delayRuleTime = mapped
    }

    /**
     * @param value Migration, synchronization or subscription task ID can be by calling the [DescribeDtsJobs] get.
     */
    @JvmName("njkdhqeqdskbutmq")
    public suspend fun dtsJobId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dtsJobId = mapped
    }

    /**
     * @param value The alarm is triggered after notification of the contact phone number, A plurality of phone numbers between them with a comma (,) to separate.
     */
    @JvmName("oplpiusuayydnjwf")
    public suspend fun phone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phone = mapped
    }

    /**
     * @param value Whether to enable monitoring rules, valid values: `Y`, `N`.
     */
    @JvmName("xncfympvubnsqyyx")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Monitoring rules of type, valid values: `delay`, `error`. **delay**: delay alarm. **error**: abnormal alarm.
     */
    @JvmName("vnihwskirclcujdh")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JobMonitorRuleArgs = JobMonitorRuleArgs(
        delayRuleTime = delayRuleTime,
        dtsJobId = dtsJobId,
        phone = phone,
        state = state,
        type = type,
    )
}
