@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [MigrationInstance].
 */
@PulumiTagMarker
public class MigrationInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MigrationInstanceArgs = MigrationInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MigrationInstanceArgsBuilder.() -> Unit) {
        val builder = MigrationInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MigrationInstance {
        val builtJavaResource = com.pulumi.alicloud.dts.MigrationInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MigrationInstance(builtJavaResource)
    }
}

/**
 * Provides a DTS Migration Instance resource.
 * For information about DTS Migration Instance and how to use it, see [What is Synchronization Instance](https://www.alibabacloud.com/help/en/doc-detail/208270.html).
 * > **NOTE:** Available since v1.157.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultMigrationInstance = new alicloud.dts.MigrationInstance("default", {
 *     paymentType: "PayAsYouGo",
 *     sourceEndpointEngineName: "MySQL",
 *     sourceEndpointRegion: _default.then(_default => _default.regions?.[0]?.id),
 *     destinationEndpointEngineName: "MySQL",
 *     destinationEndpointRegion: _default.then(_default => _default.regions?.[0]?.id),
 *     instanceClass: "small",
 *     syncArchitecture: "oneway",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_regions(current=True)
 * default_migration_instance = alicloud.dts.MigrationInstance("default",
 *     payment_type="PayAsYouGo",
 *     source_endpoint_engine_name="MySQL",
 *     source_endpoint_region=default.regions[0].id,
 *     destination_endpoint_engine_name="MySQL",
 *     destination_endpoint_region=default.regions[0].id,
 *     instance_class="small",
 *     sync_architecture="oneway")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultMigrationInstance = new AliCloud.Dts.MigrationInstance("default", new()
 *     {
 *         PaymentType = "PayAsYouGo",
 *         SourceEndpointEngineName = "MySQL",
 *         SourceEndpointRegion = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         DestinationEndpointEngineName = "MySQL",
 *         DestinationEndpointRegion = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         InstanceClass = "small",
 *         SyncArchitecture = "oneway",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dts"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dts.NewMigrationInstance(ctx, "default", &dts.MigrationInstanceArgs{
 * 			PaymentType:                   pulumi.String("PayAsYouGo"),
 * 			SourceEndpointEngineName:      pulumi.String("MySQL"),
 * 			SourceEndpointRegion:          pulumi.String(_default.Regions[0].Id),
 * 			DestinationEndpointEngineName: pulumi.String("MySQL"),
 * 			DestinationEndpointRegion:     pulumi.String(_default.Regions[0].Id),
 * 			InstanceClass:                 pulumi.String("small"),
 * 			SyncArchitecture:              pulumi.String("oneway"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.dts.MigrationInstance;
 * import com.pulumi.alicloud.dts.MigrationInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultMigrationInstance = new MigrationInstance("defaultMigrationInstance", MigrationInstanceArgs.builder()
 *             .paymentType("PayAsYouGo")
 *             .sourceEndpointEngineName("MySQL")
 *             .sourceEndpointRegion(default_.regions()[0].id())
 *             .destinationEndpointEngineName("MySQL")
 *             .destinationEndpointRegion(default_.regions()[0].id())
 *             .instanceClass("small")
 *             .syncArchitecture("oneway")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultMigrationInstance:
 *     type: alicloud:dts:MigrationInstance
 *     name: default
 *     properties:
 *       paymentType: PayAsYouGo
 *       sourceEndpointEngineName: MySQL
 *       sourceEndpointRegion: ${default.regions[0].id}
 *       destinationEndpointEngineName: MySQL
 *       destinationEndpointRegion: ${default.regions[0].id}
 *       instanceClass: small
 *       syncArchitecture: oneway
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DTS Migration Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dts/migrationInstance:MigrationInstance example <id>
 * ```
 */
public class MigrationInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.dts.MigrationInstance,
) : KotlinCustomResource(javaResource, MigrationInstanceMapper) {
    /**
     * [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
     */
    public val computeUnit: Output<Int>?
        get() = javaResource.computeUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
     */
    public val databaseCount: Output<Int>?
        get() = javaResource.databaseCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
     */
    public val destinationEndpointEngineName: Output<String>
        get() = javaResource.destinationEndpointEngineName().applyValue({ args0 -> args0 })

    /**
     * The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
     */
    public val destinationEndpointRegion: Output<String>
        get() = javaResource.destinationEndpointRegion().applyValue({ args0 -> args0 })

    /**
     * The ID of the Migration Instance.
     */
    public val dtsInstanceId: Output<String>
        get() = javaResource.dtsInstanceId().applyValue({ args0 -> args0 })

    /**
     * The instance class. Valid values: `large`, `medium`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
     */
    public val instanceClass: Output<String>
        get() = javaResource.instanceClass().applyValue({ args0 -> args0 })

    /**
     * The payment type of the resource. Valid values: `PayAsYouGo`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
     */
    public val sourceEndpointEngineName: Output<String>
        get() = javaResource.sourceEndpointEngineName().applyValue({ args0 -> args0 })

    /**
     * The region of source instance.
     */
    public val sourceEndpointRegion: Output<String>
        get() = javaResource.sourceEndpointRegion().applyValue({ args0 -> args0 })

    /**
     * The status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The sync architecture. Valid values: `oneway`.
     */
    public val syncArchitecture: Output<String>?
        get() = javaResource.syncArchitecture().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object MigrationInstanceMapper : ResourceMapper<MigrationInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dts.MigrationInstance::class == javaResource::class

    override fun map(javaResource: Resource): MigrationInstance = MigrationInstance(
        javaResource as
            com.pulumi.alicloud.dts.MigrationInstance,
    )
}

/**
 * @see [MigrationInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MigrationInstance].
 */
public suspend fun migrationInstance(
    name: String,
    block: suspend MigrationInstanceResourceBuilder.() -> Unit,
): MigrationInstance {
    val builder = MigrationInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MigrationInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun migrationInstance(name: String): MigrationInstance {
    val builder = MigrationInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
