@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin

import com.pulumi.alicloud.dts.MigrationInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DTS Migration Instance resource.
 * For information about DTS Migration Instance and how to use it, see [What is Synchronization Instance](https://www.alibabacloud.com/help/en/doc-detail/208270.html).
 * > **NOTE:** Available since v1.157.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultMigrationInstance = new alicloud.dts.MigrationInstance("default", {
 *     paymentType: "PayAsYouGo",
 *     sourceEndpointEngineName: "MySQL",
 *     sourceEndpointRegion: _default.then(_default => _default.regions?.[0]?.id),
 *     destinationEndpointEngineName: "MySQL",
 *     destinationEndpointRegion: _default.then(_default => _default.regions?.[0]?.id),
 *     instanceClass: "small",
 *     syncArchitecture: "oneway",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_regions(current=True)
 * default_migration_instance = alicloud.dts.MigrationInstance("default",
 *     payment_type="PayAsYouGo",
 *     source_endpoint_engine_name="MySQL",
 *     source_endpoint_region=default.regions[0].id,
 *     destination_endpoint_engine_name="MySQL",
 *     destination_endpoint_region=default.regions[0].id,
 *     instance_class="small",
 *     sync_architecture="oneway")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultMigrationInstance = new AliCloud.Dts.MigrationInstance("default", new()
 *     {
 *         PaymentType = "PayAsYouGo",
 *         SourceEndpointEngineName = "MySQL",
 *         SourceEndpointRegion = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         DestinationEndpointEngineName = "MySQL",
 *         DestinationEndpointRegion = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         InstanceClass = "small",
 *         SyncArchitecture = "oneway",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dts"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dts.NewMigrationInstance(ctx, "default", &dts.MigrationInstanceArgs{
 * 			PaymentType:                   pulumi.String("PayAsYouGo"),
 * 			SourceEndpointEngineName:      pulumi.String("MySQL"),
 * 			SourceEndpointRegion:          pulumi.String(_default.Regions[0].Id),
 * 			DestinationEndpointEngineName: pulumi.String("MySQL"),
 * 			DestinationEndpointRegion:     pulumi.String(_default.Regions[0].Id),
 * 			InstanceClass:                 pulumi.String("small"),
 * 			SyncArchitecture:              pulumi.String("oneway"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.dts.MigrationInstance;
 * import com.pulumi.alicloud.dts.MigrationInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultMigrationInstance = new MigrationInstance("defaultMigrationInstance", MigrationInstanceArgs.builder()
 *             .paymentType("PayAsYouGo")
 *             .sourceEndpointEngineName("MySQL")
 *             .sourceEndpointRegion(default_.regions()[0].id())
 *             .destinationEndpointEngineName("MySQL")
 *             .destinationEndpointRegion(default_.regions()[0].id())
 *             .instanceClass("small")
 *             .syncArchitecture("oneway")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultMigrationInstance:
 *     type: alicloud:dts:MigrationInstance
 *     name: default
 *     properties:
 *       paymentType: PayAsYouGo
 *       sourceEndpointEngineName: MySQL
 *       sourceEndpointRegion: ${default.regions[0].id}
 *       destinationEndpointEngineName: MySQL
 *       destinationEndpointRegion: ${default.regions[0].id}
 *       instanceClass: small
 *       syncArchitecture: oneway
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DTS Migration Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dts/migrationInstance:MigrationInstance example <id>
 * ```
 * @property computeUnit [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
 * @property databaseCount The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
 * @property destinationEndpointEngineName The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
 * @property destinationEndpointRegion The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
 * @property instanceClass The instance class. Valid values: `large`, `medium`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
 * @property paymentType The payment type of the resource. Valid values: `PayAsYouGo`.
 * @property sourceEndpointEngineName The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
 * @property sourceEndpointRegion The region of source instance.
 * @property syncArchitecture The sync architecture. Valid values: `oneway`.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class MigrationInstanceArgs(
    public val computeUnit: Output<Int>? = null,
    public val databaseCount: Output<Int>? = null,
    public val destinationEndpointEngineName: Output<String>? = null,
    public val destinationEndpointRegion: Output<String>? = null,
    public val instanceClass: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val sourceEndpointEngineName: Output<String>? = null,
    public val sourceEndpointRegion: Output<String>? = null,
    public val syncArchitecture: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dts.MigrationInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.dts.MigrationInstanceArgs =
        com.pulumi.alicloud.dts.MigrationInstanceArgs.builder()
            .computeUnit(computeUnit?.applyValue({ args0 -> args0 }))
            .databaseCount(databaseCount?.applyValue({ args0 -> args0 }))
            .destinationEndpointEngineName(destinationEndpointEngineName?.applyValue({ args0 -> args0 }))
            .destinationEndpointRegion(destinationEndpointRegion?.applyValue({ args0 -> args0 }))
            .instanceClass(instanceClass?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .sourceEndpointEngineName(sourceEndpointEngineName?.applyValue({ args0 -> args0 }))
            .sourceEndpointRegion(sourceEndpointRegion?.applyValue({ args0 -> args0 }))
            .syncArchitecture(syncArchitecture?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MigrationInstanceArgs].
 */
@PulumiTagMarker
public class MigrationInstanceArgsBuilder internal constructor() {
    private var computeUnit: Output<Int>? = null

    private var databaseCount: Output<Int>? = null

    private var destinationEndpointEngineName: Output<String>? = null

    private var destinationEndpointRegion: Output<String>? = null

    private var instanceClass: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var sourceEndpointEngineName: Output<String>? = null

    private var sourceEndpointRegion: Output<String>? = null

    private var syncArchitecture: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
     */
    @JvmName("euwwfnnryrgtordu")
    public suspend fun computeUnit(`value`: Output<Int>) {
        this.computeUnit = value
    }

    /**
     * @param value The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
     */
    @JvmName("elpxrbqclkcjumox")
    public suspend fun databaseCount(`value`: Output<Int>) {
        this.databaseCount = value
    }

    /**
     * @param value The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
     */
    @JvmName("relagdfqnwgsglcp")
    public suspend fun destinationEndpointEngineName(`value`: Output<String>) {
        this.destinationEndpointEngineName = value
    }

    /**
     * @param value The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
     */
    @JvmName("mkndiaiidtxkvmxk")
    public suspend fun destinationEndpointRegion(`value`: Output<String>) {
        this.destinationEndpointRegion = value
    }

    /**
     * @param value The instance class. Valid values: `large`, `medium`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
     */
    @JvmName("cekoooksytflgpnd")
    public suspend fun instanceClass(`value`: Output<String>) {
        this.instanceClass = value
    }

    /**
     * @param value The payment type of the resource. Valid values: `PayAsYouGo`.
     */
    @JvmName("lnetioyqxkajfyxi")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
     */
    @JvmName("vjoerqhwfbglhpnf")
    public suspend fun sourceEndpointEngineName(`value`: Output<String>) {
        this.sourceEndpointEngineName = value
    }

    /**
     * @param value The region of source instance.
     */
    @JvmName("sonlxgeaescfwflk")
    public suspend fun sourceEndpointRegion(`value`: Output<String>) {
        this.sourceEndpointRegion = value
    }

    /**
     * @param value The sync architecture. Valid values: `oneway`.
     */
    @JvmName("ruvysivekbxsnxex")
    public suspend fun syncArchitecture(`value`: Output<String>) {
        this.syncArchitecture = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("irolagmeldudfqvu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
     */
    @JvmName("lyvvwctmvthpqvya")
    public suspend fun computeUnit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeUnit = mapped
    }

    /**
     * @param value The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
     */
    @JvmName("ejeiaqtsriyoqlrr")
    public suspend fun databaseCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseCount = mapped
    }

    /**
     * @param value The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
     */
    @JvmName("jthgexvrpttweyeo")
    public suspend fun destinationEndpointEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointEngineName = mapped
    }

    /**
     * @param value The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
     */
    @JvmName("hpemnygvsffnsvxp")
    public suspend fun destinationEndpointRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointRegion = mapped
    }

    /**
     * @param value The instance class. Valid values: `large`, `medium`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
     */
    @JvmName("iihitjtggtjatndx")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceClass = mapped
    }

    /**
     * @param value The payment type of the resource. Valid values: `PayAsYouGo`.
     */
    @JvmName("uhomkxjosrvbucbw")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
     */
    @JvmName("eqgrqvsgbhtrdnfi")
    public suspend fun sourceEndpointEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointEngineName = mapped
    }

    /**
     * @param value The region of source instance.
     */
    @JvmName("tgrlrvnpquqslcki")
    public suspend fun sourceEndpointRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointRegion = mapped
    }

    /**
     * @param value The sync architecture. Valid values: `oneway`.
     */
    @JvmName("dhlhxujtbxdrmhnf")
    public suspend fun syncArchitecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncArchitecture = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("euujetkqbeuipblc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("ilkchwpgwmjktrub")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MigrationInstanceArgs = MigrationInstanceArgs(
        computeUnit = computeUnit,
        databaseCount = databaseCount,
        destinationEndpointEngineName = destinationEndpointEngineName,
        destinationEndpointRegion = destinationEndpointRegion,
        instanceClass = instanceClass,
        paymentType = paymentType,
        sourceEndpointEngineName = sourceEndpointEngineName,
        sourceEndpointRegion = sourceEndpointRegion,
        syncArchitecture = syncArchitecture,
        tags = tags,
    )
}
