@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MigrationJob].
 */
@PulumiTagMarker
public class MigrationJobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MigrationJobArgs = MigrationJobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MigrationJobArgsBuilder.() -> Unit) {
        val builder = MigrationJobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MigrationJob {
        val builtJavaResource = com.pulumi.alicloud.dts.MigrationJob(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MigrationJob(builtJavaResource)
    }
}

/**
 * Provides a DTS Migration Job resource.
 * For information about DTS Migration Job and how to use it, see [What is Migration Job](https://www.alibabacloud.com/help/en/doc-detail/208399.html).
 * > **NOTE:** Available since v1.157.0.
 * ## Import
 * DTS Migration Job can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dts/migrationJob:MigrationJob example <id>
 * ```
 */
public class MigrationJob internal constructor(
    override val javaResource: com.pulumi.alicloud.dts.MigrationJob,
) : KotlinCustomResource(javaResource, MigrationJobMapper) {
    /**
     * Start time in Unix timestamp format.
     */
    public val checkpoint: Output<String>
        get() = javaResource.checkpoint().applyValue({ args0 -> args0 })

    /**
     * Whether to execute DTS supports schema migration.
     */
    public val dataInitialization: Output<Boolean>
        get() = javaResource.dataInitialization().applyValue({ args0 -> args0 })

    /**
     * Whether to perform incremental data migration.
     */
    public val dataSynchronization: Output<Boolean>
        get() = javaResource.dataSynchronization().applyValue({ args0 -> args0 })

    /**
     * Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, migration or subscription objects](https://help.aliyun.com/document_detail/209545.html).
     */
    public val dbList: Output<String>
        get() = javaResource.dbList().applyValue({ args0 -> args0 })

    /**
     * The name of migrate the database.
     */
    public val destinationEndpointDatabaseName: Output<String>?
        get() = javaResource.destinationEndpointDatabaseName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of destination database. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
     */
    public val destinationEndpointEngineName: Output<String>
        get() = javaResource.destinationEndpointEngineName().applyValue({ args0 -> args0 })

    /**
     * The ID of destination instance.
     */
    public val destinationEndpointInstanceId: Output<String>?
        get() = javaResource.destinationEndpointInstanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of destination instance. Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
     */
    public val destinationEndpointInstanceType: Output<String>
        get() = javaResource.destinationEndpointInstanceType().applyValue({ args0 -> args0 })

    /**
     * The ip of source endpoint.
     */
    public val destinationEndpointIp: Output<String>?
        get() = javaResource.destinationEndpointIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SID of Oracle database.
     */
    public val destinationEndpointOracleSid: Output<String>?
        get() = javaResource.destinationEndpointOracleSid().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The password of database account.
     */
    public val destinationEndpointPassword: Output<String>?
        get() = javaResource.destinationEndpointPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port of source endpoint.
     */
    public val destinationEndpointPort: Output<String>?
        get() = javaResource.destinationEndpointPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The region of destination instance.
     */
    public val destinationEndpointRegion: Output<String>?
        get() = javaResource.destinationEndpointRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The username of database account.
     */
    public val destinationEndpointUserName: Output<String>?
        get() = javaResource.destinationEndpointUserName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Migration instance ID. The ID of `alicloud.dts.MigrationInstance`.
     */
    public val dtsInstanceId: Output<String>
        get() = javaResource.dtsInstanceId().applyValue({ args0 -> args0 })

    /**
     * The name of migration job.
     */
    public val dtsJobName: Output<String>
        get() = javaResource.dtsJobName().applyValue({ args0 -> args0 })

    /**
     * The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
     */
    public val instanceClass: Output<String>
        get() = javaResource.instanceClass().applyValue({ args0 -> args0 })

    /**
     * The name of migrate the database.
     */
    public val sourceEndpointDatabaseName: Output<String>?
        get() = javaResource.sourceEndpointDatabaseName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
     */
    public val sourceEndpointEngineName: Output<String>
        get() = javaResource.sourceEndpointEngineName().applyValue({ args0 -> args0 })

    /**
     * The ID of source instance.
     */
    public val sourceEndpointInstanceId: Output<String>?
        get() = javaResource.sourceEndpointInstanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
     */
    public val sourceEndpointInstanceType: Output<String>
        get() = javaResource.sourceEndpointInstanceType().applyValue({ args0 -> args0 })

    /**
     * The ip of source endpoint.
     */
    public val sourceEndpointIp: Output<String>?
        get() = javaResource.sourceEndpointIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SID of Oracle database.
     */
    public val sourceEndpointOracleSid: Output<String>?
        get() = javaResource.sourceEndpointOracleSid().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Alibaba Cloud account ID to which the source instance belongs.
     */
    public val sourceEndpointOwnerId: Output<String>?
        get() = javaResource.sourceEndpointOwnerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The password of database account.
     */
    public val sourceEndpointPassword: Output<String>?
        get() = javaResource.sourceEndpointPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port of source endpoint.
     */
    public val sourceEndpointPort: Output<String>?
        get() = javaResource.sourceEndpointPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The region of source instance.
     */
    public val sourceEndpointRegion: Output<String>?
        get() = javaResource.sourceEndpointRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the role configured for the cloud account to which the source instance belongs.
     */
    public val sourceEndpointRole: Output<String>?
        get() = javaResource.sourceEndpointRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The username of database account.
     */
    public val sourceEndpointUserName: Output<String>?
        get() = javaResource.sourceEndpointUserName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the resource. Valid values: `Migrating`, `Suspending`. You can suspend the task by specifying `Suspending` and start the task by specifying `Migrating`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Whether to perform a database table structure to migrate.
     */
    public val structureInitialization: Output<Boolean>
        get() = javaResource.structureInitialization().applyValue({ args0 -> args0 })
}

public object MigrationJobMapper : ResourceMapper<MigrationJob> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dts.MigrationJob::class == javaResource::class

    override fun map(javaResource: Resource): MigrationJob = MigrationJob(
        javaResource as
            com.pulumi.alicloud.dts.MigrationJob,
    )
}

/**
 * @see [MigrationJob].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MigrationJob].
 */
public suspend fun migrationJob(
    name: String,
    block: suspend MigrationJobResourceBuilder.() -> Unit,
): MigrationJob {
    val builder = MigrationJobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MigrationJob].
 * @param name The _unique_ name of the resulting resource.
 */
public fun migrationJob(name: String): MigrationJob {
    val builder = MigrationJobResourceBuilder()
    builder.name(name)
    return builder.build()
}
