@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin

import com.pulumi.alicloud.dts.MigrationJobArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DTS Migration Job resource.
 * For information about DTS Migration Job and how to use it, see [What is Migration Job](https://www.alibabacloud.com/help/en/doc-detail/208399.html).
 * > **NOTE:** Available since v1.157.0.
 * ## Import
 * DTS Migration Job can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dts/migrationJob:MigrationJob example <id>
 * ```
 * @property checkpoint Start time in Unix timestamp format.
 * @property dataInitialization Whether to execute DTS supports schema migration.
 * @property dataSynchronization Whether to perform incremental data migration.
 * @property dbList Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, migration or subscription objects](https://help.aliyun.com/document_detail/209545.html).
 * @property destinationEndpointDatabaseName The name of migrate the database.
 * @property destinationEndpointEngineName The type of destination database. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
 * @property destinationEndpointInstanceId The ID of destination instance.
 * @property destinationEndpointInstanceType The type of destination instance. Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
 * @property destinationEndpointIp The ip of source endpoint.
 * @property destinationEndpointOracleSid The SID of Oracle database.
 * @property destinationEndpointPassword The password of database account.
 * @property destinationEndpointPort The port of source endpoint.
 * @property destinationEndpointRegion The region of destination instance.
 * @property destinationEndpointUserName The username of database account.
 * @property dtsInstanceId The Migration instance ID. The ID of `alicloud.dts.MigrationInstance`.
 * @property dtsJobName The name of migration job.
 * @property instanceClass The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
 * @property sourceEndpointDatabaseName The name of migrate the database.
 * @property sourceEndpointEngineName The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
 * @property sourceEndpointInstanceId The ID of source instance.
 * @property sourceEndpointInstanceType The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
 * @property sourceEndpointIp The ip of source endpoint.
 * @property sourceEndpointOracleSid The SID of Oracle database.
 * @property sourceEndpointOwnerId The Alibaba Cloud account ID to which the source instance belongs.
 * @property sourceEndpointPassword The password of database account.
 * @property sourceEndpointPort The port of source endpoint.
 * @property sourceEndpointRegion The region of source instance.
 * @property sourceEndpointRole The name of the role configured for the cloud account to which the source instance belongs.
 * @property sourceEndpointUserName The username of database account.
 * @property status The status of the resource. Valid values: `Migrating`, `Suspending`. You can suspend the task by specifying `Suspending` and start the task by specifying `Migrating`.
 * @property structureInitialization Whether to perform a database table structure to migrate.
 */
public data class MigrationJobArgs(
    public val checkpoint: Output<String>? = null,
    public val dataInitialization: Output<Boolean>? = null,
    public val dataSynchronization: Output<Boolean>? = null,
    public val dbList: Output<String>? = null,
    public val destinationEndpointDatabaseName: Output<String>? = null,
    public val destinationEndpointEngineName: Output<String>? = null,
    public val destinationEndpointInstanceId: Output<String>? = null,
    public val destinationEndpointInstanceType: Output<String>? = null,
    public val destinationEndpointIp: Output<String>? = null,
    public val destinationEndpointOracleSid: Output<String>? = null,
    public val destinationEndpointPassword: Output<String>? = null,
    public val destinationEndpointPort: Output<String>? = null,
    public val destinationEndpointRegion: Output<String>? = null,
    public val destinationEndpointUserName: Output<String>? = null,
    public val dtsInstanceId: Output<String>? = null,
    public val dtsJobName: Output<String>? = null,
    public val instanceClass: Output<String>? = null,
    public val sourceEndpointDatabaseName: Output<String>? = null,
    public val sourceEndpointEngineName: Output<String>? = null,
    public val sourceEndpointInstanceId: Output<String>? = null,
    public val sourceEndpointInstanceType: Output<String>? = null,
    public val sourceEndpointIp: Output<String>? = null,
    public val sourceEndpointOracleSid: Output<String>? = null,
    public val sourceEndpointOwnerId: Output<String>? = null,
    public val sourceEndpointPassword: Output<String>? = null,
    public val sourceEndpointPort: Output<String>? = null,
    public val sourceEndpointRegion: Output<String>? = null,
    public val sourceEndpointRole: Output<String>? = null,
    public val sourceEndpointUserName: Output<String>? = null,
    public val status: Output<String>? = null,
    public val structureInitialization: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dts.MigrationJobArgs> {
    override fun toJava(): com.pulumi.alicloud.dts.MigrationJobArgs =
        com.pulumi.alicloud.dts.MigrationJobArgs.builder()
            .checkpoint(checkpoint?.applyValue({ args0 -> args0 }))
            .dataInitialization(dataInitialization?.applyValue({ args0 -> args0 }))
            .dataSynchronization(dataSynchronization?.applyValue({ args0 -> args0 }))
            .dbList(dbList?.applyValue({ args0 -> args0 }))
            .destinationEndpointDatabaseName(destinationEndpointDatabaseName?.applyValue({ args0 -> args0 }))
            .destinationEndpointEngineName(destinationEndpointEngineName?.applyValue({ args0 -> args0 }))
            .destinationEndpointInstanceId(destinationEndpointInstanceId?.applyValue({ args0 -> args0 }))
            .destinationEndpointInstanceType(destinationEndpointInstanceType?.applyValue({ args0 -> args0 }))
            .destinationEndpointIp(destinationEndpointIp?.applyValue({ args0 -> args0 }))
            .destinationEndpointOracleSid(destinationEndpointOracleSid?.applyValue({ args0 -> args0 }))
            .destinationEndpointPassword(destinationEndpointPassword?.applyValue({ args0 -> args0 }))
            .destinationEndpointPort(destinationEndpointPort?.applyValue({ args0 -> args0 }))
            .destinationEndpointRegion(destinationEndpointRegion?.applyValue({ args0 -> args0 }))
            .destinationEndpointUserName(destinationEndpointUserName?.applyValue({ args0 -> args0 }))
            .dtsInstanceId(dtsInstanceId?.applyValue({ args0 -> args0 }))
            .dtsJobName(dtsJobName?.applyValue({ args0 -> args0 }))
            .instanceClass(instanceClass?.applyValue({ args0 -> args0 }))
            .sourceEndpointDatabaseName(sourceEndpointDatabaseName?.applyValue({ args0 -> args0 }))
            .sourceEndpointEngineName(sourceEndpointEngineName?.applyValue({ args0 -> args0 }))
            .sourceEndpointInstanceId(sourceEndpointInstanceId?.applyValue({ args0 -> args0 }))
            .sourceEndpointInstanceType(sourceEndpointInstanceType?.applyValue({ args0 -> args0 }))
            .sourceEndpointIp(sourceEndpointIp?.applyValue({ args0 -> args0 }))
            .sourceEndpointOracleSid(sourceEndpointOracleSid?.applyValue({ args0 -> args0 }))
            .sourceEndpointOwnerId(sourceEndpointOwnerId?.applyValue({ args0 -> args0 }))
            .sourceEndpointPassword(sourceEndpointPassword?.applyValue({ args0 -> args0 }))
            .sourceEndpointPort(sourceEndpointPort?.applyValue({ args0 -> args0 }))
            .sourceEndpointRegion(sourceEndpointRegion?.applyValue({ args0 -> args0 }))
            .sourceEndpointRole(sourceEndpointRole?.applyValue({ args0 -> args0 }))
            .sourceEndpointUserName(sourceEndpointUserName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .structureInitialization(structureInitialization?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrationJobArgs].
 */
@PulumiTagMarker
public class MigrationJobArgsBuilder internal constructor() {
    private var checkpoint: Output<String>? = null

    private var dataInitialization: Output<Boolean>? = null

    private var dataSynchronization: Output<Boolean>? = null

    private var dbList: Output<String>? = null

    private var destinationEndpointDatabaseName: Output<String>? = null

    private var destinationEndpointEngineName: Output<String>? = null

    private var destinationEndpointInstanceId: Output<String>? = null

    private var destinationEndpointInstanceType: Output<String>? = null

    private var destinationEndpointIp: Output<String>? = null

    private var destinationEndpointOracleSid: Output<String>? = null

    private var destinationEndpointPassword: Output<String>? = null

    private var destinationEndpointPort: Output<String>? = null

    private var destinationEndpointRegion: Output<String>? = null

    private var destinationEndpointUserName: Output<String>? = null

    private var dtsInstanceId: Output<String>? = null

    private var dtsJobName: Output<String>? = null

    private var instanceClass: Output<String>? = null

    private var sourceEndpointDatabaseName: Output<String>? = null

    private var sourceEndpointEngineName: Output<String>? = null

    private var sourceEndpointInstanceId: Output<String>? = null

    private var sourceEndpointInstanceType: Output<String>? = null

    private var sourceEndpointIp: Output<String>? = null

    private var sourceEndpointOracleSid: Output<String>? = null

    private var sourceEndpointOwnerId: Output<String>? = null

    private var sourceEndpointPassword: Output<String>? = null

    private var sourceEndpointPort: Output<String>? = null

    private var sourceEndpointRegion: Output<String>? = null

    private var sourceEndpointRole: Output<String>? = null

    private var sourceEndpointUserName: Output<String>? = null

    private var status: Output<String>? = null

    private var structureInitialization: Output<Boolean>? = null

    /**
     * @param value Start time in Unix timestamp format.
     */
    @JvmName("ugdtiyiiqywkteuv")
    public suspend fun checkpoint(`value`: Output<String>) {
        this.checkpoint = value
    }

    /**
     * @param value Whether to execute DTS supports schema migration.
     */
    @JvmName("mbxiofnwxmfmepyt")
    public suspend fun dataInitialization(`value`: Output<Boolean>) {
        this.dataInitialization = value
    }

    /**
     * @param value Whether to perform incremental data migration.
     */
    @JvmName("vaihevwcawcfnqvn")
    public suspend fun dataSynchronization(`value`: Output<Boolean>) {
        this.dataSynchronization = value
    }

    /**
     * @param value Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, migration or subscription objects](https://help.aliyun.com/document_detail/209545.html).
     */
    @JvmName("xrhocdrmufmjdqcn")
    public suspend fun dbList(`value`: Output<String>) {
        this.dbList = value
    }

    /**
     * @param value The name of migrate the database.
     */
    @JvmName("udugseehmanghaht")
    public suspend fun destinationEndpointDatabaseName(`value`: Output<String>) {
        this.destinationEndpointDatabaseName = value
    }

    /**
     * @param value The type of destination database. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
     */
    @JvmName("vykmuqpjqqnpfqyk")
    public suspend fun destinationEndpointEngineName(`value`: Output<String>) {
        this.destinationEndpointEngineName = value
    }

    /**
     * @param value The ID of destination instance.
     */
    @JvmName("eyhstpmtyurrgjty")
    public suspend fun destinationEndpointInstanceId(`value`: Output<String>) {
        this.destinationEndpointInstanceId = value
    }

    /**
     * @param value The type of destination instance. Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
     */
    @JvmName("eckheyqyhmoukbev")
    public suspend fun destinationEndpointInstanceType(`value`: Output<String>) {
        this.destinationEndpointInstanceType = value
    }

    /**
     * @param value The ip of source endpoint.
     */
    @JvmName("jgxxaxqupgcnljqb")
    public suspend fun destinationEndpointIp(`value`: Output<String>) {
        this.destinationEndpointIp = value
    }

    /**
     * @param value The SID of Oracle database.
     */
    @JvmName("phymaimqbrrntqkj")
    public suspend fun destinationEndpointOracleSid(`value`: Output<String>) {
        this.destinationEndpointOracleSid = value
    }

    /**
     * @param value The password of database account.
     */
    @JvmName("nnuuqoydqhwputaf")
    public suspend fun destinationEndpointPassword(`value`: Output<String>) {
        this.destinationEndpointPassword = value
    }

    /**
     * @param value The port of source endpoint.
     */
    @JvmName("eykuajgttycbpwiw")
    public suspend fun destinationEndpointPort(`value`: Output<String>) {
        this.destinationEndpointPort = value
    }

    /**
     * @param value The region of destination instance.
     */
    @JvmName("oraugwtnldycraqf")
    public suspend fun destinationEndpointRegion(`value`: Output<String>) {
        this.destinationEndpointRegion = value
    }

    /**
     * @param value The username of database account.
     */
    @JvmName("sckeodurcabdybia")
    public suspend fun destinationEndpointUserName(`value`: Output<String>) {
        this.destinationEndpointUserName = value
    }

    /**
     * @param value The Migration instance ID. The ID of `alicloud.dts.MigrationInstance`.
     */
    @JvmName("vjppotbbupwbpihp")
    public suspend fun dtsInstanceId(`value`: Output<String>) {
        this.dtsInstanceId = value
    }

    /**
     * @param value The name of migration job.
     */
    @JvmName("mppeplkkoykvrvml")
    public suspend fun dtsJobName(`value`: Output<String>) {
        this.dtsJobName = value
    }

    /**
     * @param value The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
     */
    @JvmName("hyjuaxviygvdwdbg")
    public suspend fun instanceClass(`value`: Output<String>) {
        this.instanceClass = value
    }

    /**
     * @param value The name of migrate the database.
     */
    @JvmName("ldqdnqvnbetutlta")
    public suspend fun sourceEndpointDatabaseName(`value`: Output<String>) {
        this.sourceEndpointDatabaseName = value
    }

    /**
     * @param value The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
     */
    @JvmName("iusftbxrumapsgre")
    public suspend fun sourceEndpointEngineName(`value`: Output<String>) {
        this.sourceEndpointEngineName = value
    }

    /**
     * @param value The ID of source instance.
     */
    @JvmName("gkyydffemmkvvbke")
    public suspend fun sourceEndpointInstanceId(`value`: Output<String>) {
        this.sourceEndpointInstanceId = value
    }

    /**
     * @param value The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
     */
    @JvmName("mguoyoiisrjdtfeq")
    public suspend fun sourceEndpointInstanceType(`value`: Output<String>) {
        this.sourceEndpointInstanceType = value
    }

    /**
     * @param value The ip of source endpoint.
     */
    @JvmName("bhdamafpwuwjoydh")
    public suspend fun sourceEndpointIp(`value`: Output<String>) {
        this.sourceEndpointIp = value
    }

    /**
     * @param value The SID of Oracle database.
     */
    @JvmName("yoklavtvhedxauvp")
    public suspend fun sourceEndpointOracleSid(`value`: Output<String>) {
        this.sourceEndpointOracleSid = value
    }

    /**
     * @param value The Alibaba Cloud account ID to which the source instance belongs.
     */
    @JvmName("kutkjisqvsuokpxy")
    public suspend fun sourceEndpointOwnerId(`value`: Output<String>) {
        this.sourceEndpointOwnerId = value
    }

    /**
     * @param value The password of database account.
     */
    @JvmName("kdkuwrtqiadmggtc")
    public suspend fun sourceEndpointPassword(`value`: Output<String>) {
        this.sourceEndpointPassword = value
    }

    /**
     * @param value The port of source endpoint.
     */
    @JvmName("vcpgtgifvycwibnk")
    public suspend fun sourceEndpointPort(`value`: Output<String>) {
        this.sourceEndpointPort = value
    }

    /**
     * @param value The region of source instance.
     */
    @JvmName("xceckouifhrouimr")
    public suspend fun sourceEndpointRegion(`value`: Output<String>) {
        this.sourceEndpointRegion = value
    }

    /**
     * @param value The name of the role configured for the cloud account to which the source instance belongs.
     */
    @JvmName("genvevnphalxyhih")
    public suspend fun sourceEndpointRole(`value`: Output<String>) {
        this.sourceEndpointRole = value
    }

    /**
     * @param value The username of database account.
     */
    @JvmName("jscbbnltuehxapna")
    public suspend fun sourceEndpointUserName(`value`: Output<String>) {
        this.sourceEndpointUserName = value
    }

    /**
     * @param value The status of the resource. Valid values: `Migrating`, `Suspending`. You can suspend the task by specifying `Suspending` and start the task by specifying `Migrating`.
     */
    @JvmName("lxbomploawteclvq")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Whether to perform a database table structure to migrate.
     */
    @JvmName("vqtrfwjuouqqnicv")
    public suspend fun structureInitialization(`value`: Output<Boolean>) {
        this.structureInitialization = value
    }

    /**
     * @param value Start time in Unix timestamp format.
     */
    @JvmName("ruagrdpkmkhqwxxr")
    public suspend fun checkpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpoint = mapped
    }

    /**
     * @param value Whether to execute DTS supports schema migration.
     */
    @JvmName("ogmanmlljosnubvo")
    public suspend fun dataInitialization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataInitialization = mapped
    }

    /**
     * @param value Whether to perform incremental data migration.
     */
    @JvmName("xejhmgipywvcydup")
    public suspend fun dataSynchronization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSynchronization = mapped
    }

    /**
     * @param value Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, migration or subscription objects](https://help.aliyun.com/document_detail/209545.html).
     */
    @JvmName("vrclgbyrtqrypreo")
    public suspend fun dbList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbList = mapped
    }

    /**
     * @param value The name of migrate the database.
     */
    @JvmName("rgkflictfxorgbal")
    public suspend fun destinationEndpointDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointDatabaseName = mapped
    }

    /**
     * @param value The type of destination database. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
     */
    @JvmName("wvfwlaqnvjosnkpa")
    public suspend fun destinationEndpointEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointEngineName = mapped
    }

    /**
     * @param value The ID of destination instance.
     */
    @JvmName("nevjgdllfihyfunu")
    public suspend fun destinationEndpointInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointInstanceId = mapped
    }

    /**
     * @param value The type of destination instance. Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
     */
    @JvmName("iiubyddvonxqvhkm")
    public suspend fun destinationEndpointInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointInstanceType = mapped
    }

    /**
     * @param value The ip of source endpoint.
     */
    @JvmName("cmfhhcxdixprdxob")
    public suspend fun destinationEndpointIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointIp = mapped
    }

    /**
     * @param value The SID of Oracle database.
     */
    @JvmName("rhaddjofqmcrskid")
    public suspend fun destinationEndpointOracleSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointOracleSid = mapped
    }

    /**
     * @param value The password of database account.
     */
    @JvmName("brdlouvonveijvud")
    public suspend fun destinationEndpointPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointPassword = mapped
    }

    /**
     * @param value The port of source endpoint.
     */
    @JvmName("bfsotyqavgbiauku")
    public suspend fun destinationEndpointPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointPort = mapped
    }

    /**
     * @param value The region of destination instance.
     */
    @JvmName("shmttqtcrhngdcdc")
    public suspend fun destinationEndpointRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointRegion = mapped
    }

    /**
     * @param value The username of database account.
     */
    @JvmName("tforalgosiaupsmr")
    public suspend fun destinationEndpointUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointUserName = mapped
    }

    /**
     * @param value The Migration instance ID. The ID of `alicloud.dts.MigrationInstance`.
     */
    @JvmName("cbnpshvyqouvdwht")
    public suspend fun dtsInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dtsInstanceId = mapped
    }

    /**
     * @param value The name of migration job.
     */
    @JvmName("lhwjkdefcqbimsae")
    public suspend fun dtsJobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dtsJobName = mapped
    }

    /**
     * @param value The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
     */
    @JvmName("kkqxapjfxqkdwkhg")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceClass = mapped
    }

    /**
     * @param value The name of migrate the database.
     */
    @JvmName("yalisbmdsedykxlh")
    public suspend fun sourceEndpointDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointDatabaseName = mapped
    }

    /**
     * @param value The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
     */
    @JvmName("ofymebqqwpugsjhd")
    public suspend fun sourceEndpointEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointEngineName = mapped
    }

    /**
     * @param value The ID of source instance.
     */
    @JvmName("ogdqfickdlswstpm")
    public suspend fun sourceEndpointInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointInstanceId = mapped
    }

    /**
     * @param value The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
     */
    @JvmName("yoxhpxvjwwtlrhfw")
    public suspend fun sourceEndpointInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointInstanceType = mapped
    }

    /**
     * @param value The ip of source endpoint.
     */
    @JvmName("xshmehplffeuvgip")
    public suspend fun sourceEndpointIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointIp = mapped
    }

    /**
     * @param value The SID of Oracle database.
     */
    @JvmName("cqvciakndkiunwtv")
    public suspend fun sourceEndpointOracleSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointOracleSid = mapped
    }

    /**
     * @param value The Alibaba Cloud account ID to which the source instance belongs.
     */
    @JvmName("gwtdieaoplopfsfq")
    public suspend fun sourceEndpointOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointOwnerId = mapped
    }

    /**
     * @param value The password of database account.
     */
    @JvmName("nasqygajwoxdvcgr")
    public suspend fun sourceEndpointPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointPassword = mapped
    }

    /**
     * @param value The port of source endpoint.
     */
    @JvmName("ppnpldhatosnlkkx")
    public suspend fun sourceEndpointPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointPort = mapped
    }

    /**
     * @param value The region of source instance.
     */
    @JvmName("yaninljasqvbpkar")
    public suspend fun sourceEndpointRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointRegion = mapped
    }

    /**
     * @param value The name of the role configured for the cloud account to which the source instance belongs.
     */
    @JvmName("pwchrjgsqevaqept")
    public suspend fun sourceEndpointRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointRole = mapped
    }

    /**
     * @param value The username of database account.
     */
    @JvmName("pyxypmcdmidqtlgk")
    public suspend fun sourceEndpointUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointUserName = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Migrating`, `Suspending`. You can suspend the task by specifying `Suspending` and start the task by specifying `Migrating`.
     */
    @JvmName("jvhgtghsmuhwvryv")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Whether to perform a database table structure to migrate.
     */
    @JvmName("qefmenhqvfowaobc")
    public suspend fun structureInitialization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.structureInitialization = mapped
    }

    internal fun build(): MigrationJobArgs = MigrationJobArgs(
        checkpoint = checkpoint,
        dataInitialization = dataInitialization,
        dataSynchronization = dataSynchronization,
        dbList = dbList,
        destinationEndpointDatabaseName = destinationEndpointDatabaseName,
        destinationEndpointEngineName = destinationEndpointEngineName,
        destinationEndpointInstanceId = destinationEndpointInstanceId,
        destinationEndpointInstanceType = destinationEndpointInstanceType,
        destinationEndpointIp = destinationEndpointIp,
        destinationEndpointOracleSid = destinationEndpointOracleSid,
        destinationEndpointPassword = destinationEndpointPassword,
        destinationEndpointPort = destinationEndpointPort,
        destinationEndpointRegion = destinationEndpointRegion,
        destinationEndpointUserName = destinationEndpointUserName,
        dtsInstanceId = dtsInstanceId,
        dtsJobName = dtsJobName,
        instanceClass = instanceClass,
        sourceEndpointDatabaseName = sourceEndpointDatabaseName,
        sourceEndpointEngineName = sourceEndpointEngineName,
        sourceEndpointInstanceId = sourceEndpointInstanceId,
        sourceEndpointInstanceType = sourceEndpointInstanceType,
        sourceEndpointIp = sourceEndpointIp,
        sourceEndpointOracleSid = sourceEndpointOracleSid,
        sourceEndpointOwnerId = sourceEndpointOwnerId,
        sourceEndpointPassword = sourceEndpointPassword,
        sourceEndpointPort = sourceEndpointPort,
        sourceEndpointRegion = sourceEndpointRegion,
        sourceEndpointRole = sourceEndpointRole,
        sourceEndpointUserName = sourceEndpointUserName,
        status = status,
        structureInitialization = structureInitialization,
    )
}
