@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin

import com.pulumi.alicloud.dts.SubscriptionJobArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DTS Subscription Job resource.
 * For information about DTS Subscription Job and how to use it, see [What is Subscription Job](https://www.alibabacloud.com/help/en/data-transmission-service/latest/configuresubscription).
 * > **NOTE:** Available since v1.138.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const example = alicloud.getRegions({
 *     current: true,
 * });
 * const exampleGetZones = alicloud.rds.getZones({
 *     engine: "MySQL",
 *     engineVersion: "8.0",
 *     instanceChargeType: "PostPaid",
 *     category: "Basic",
 *     dbInstanceStorageType: "cloud_essd",
 * });
 * const exampleGetInstanceClasses = exampleGetZones.then(exampleGetZones => alicloud.rds.getInstanceClasses({
 *     zoneId: exampleGetZones.zones?.[0]?.id,
 *     engine: "MySQL",
 *     engineVersion: "8.0",
 *     instanceChargeType: "PostPaid",
 *     category: "Basic",
 *     dbInstanceStorageType: "cloud_essd",
 * }));
 * const exampleNetwork = new alicloud.vpc.Network("example", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vpcId: exampleNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: exampleGetZones.then(exampleGetZones => exampleGetZones.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const exampleSecurityGroup = new alicloud.ecs.SecurityGroup("example", {
 *     name: name,
 *     vpcId: exampleNetwork.id,
 * });
 * const exampleInstance = new alicloud.rds.Instance("example", {
 *     engine: "MySQL",
 *     engineVersion: "8.0",
 *     instanceType: exampleGetInstanceClasses.then(exampleGetInstanceClasses => exampleGetInstanceClasses.instanceClasses?.[0]?.instanceClass),
 *     instanceStorage: exampleGetInstanceClasses.then(exampleGetInstanceClasses => exampleGetInstanceClasses.instanceClasses?.[0]?.storageRange?.min),
 *     instanceChargeType: "Postpaid",
 *     instanceName: name,
 *     vswitchId: exampleSwitch.id,
 *     monitoringPeriod: 60,
 *     dbInstanceStorageType: "cloud_essd",
 *     securityGroupIds: [exampleSecurityGroup&#46;id],
 * });
 * const exampleRdsAccount = new alicloud.rds.RdsAccount("example", {
 *     dbInstanceId: exampleInstance.id,
 *     accountName: "test_mysql",
 *     accountPassword: "N1cetest",
 * });
 * const exampleDatabase = new alicloud.rds.Database("example", {
 *     instanceId: exampleInstance.id,
 *     name: name,
 * });
 * const exampleAccountPrivilege = new alicloud.rds.AccountPrivilege("example", {
 *     instanceId: exampleInstance.id,
 *     accountName: exampleRdsAccount.name,
 *     privilege: "ReadWrite",
 *     dbNames: [exampleDatabase&#46;name],
 * });
 * const exampleSubscriptionJob = new alicloud.dts.SubscriptionJob("example", {
 *     dtsJobName: name,
 *     paymentType: "PayAsYouGo",
 *     sourceEndpointEngineName: "MySQL",
 *     sourceEndpointRegion: example.then(example => example.regions?.[0]?.id),
 *     sourceEndpointInstanceType: "RDS",
 *     sourceEndpointInstanceId: exampleInstance.id,
 *     sourceEndpointDatabaseName: exampleDatabase.name,
 *     sourceEndpointUserName: exampleRdsAccount.accountName,
 *     sourceEndpointPassword: exampleRdsAccount.accountPassword,
 *     dbList: pulumi.jsonStringify(pulumi.all([exampleDatabase&#46;name, exampleDatabase&#46;name])&#46;apply(([exampleDatabaseName, exampleDatabaseName1]) => {
 *         [exampleDatabaseName]: {
 *             name: exampleDatabaseName1,
 *             all: true,
 *         },
 *     })),
 *     subscriptionInstanceNetworkType: "vpc",
 *     subscriptionInstanceVpcId: exampleNetwork.id,
 *     subscriptionInstanceVswitchId: exampleSwitch.id,
 *     status: "Normal",
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * example = alicloud.get_regions(current=True)
 * example_get_zones = alicloud.rds.get_zones(engine="MySQL",
 *     engine_version="8.0",
 *     instance_charge_type="PostPaid",
 *     category="Basic",
 *     db_instance_storage_type="cloud_essd")
 * example_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=example_get_zones.zones[0].id,
 *     engine="MySQL",
 *     engine_version="8.0",
 *     instance_charge_type="PostPaid",
 *     category="Basic",
 *     db_instance_storage_type="cloud_essd")
 * example_network = alicloud.vpc.Network("example",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * example_switch = alicloud.vpc.Switch("example",
 *     vpc_id=example_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=example_get_zones.zones[0].id,
 *     vswitch_name=name)
 * example_security_group = alicloud.ecs.SecurityGroup("example",
 *     name=name,
 *     vpc_id=example_network.id)
 * example_instance = alicloud.rds.Instance("example",
 *     engine="MySQL",
 *     engine_version="8.0",
 *     instance_type=example_get_instance_classes.instance_classes[0].instance_class,
 *     instance_storage=example_get_instance_classes.instance_classes[0].storage_range.min,
 *     instance_charge_type="Postpaid",
 *     instance_name=name,
 *     vswitch_id=example_switch.id,
 *     monitoring_period=60,
 *     db_instance_storage_type="cloud_essd",
 *     security_group_ids=[example_security_group&#46;id])
 * example_rds_account = alicloud.rds.RdsAccount("example",
 *     db_instance_id=example_instance.id,
 *     account_name="test_mysql",
 *     account_password="N1cetest")
 * example_database = alicloud.rds.Database("example",
 *     instance_id=example_instance.id,
 *     name=name)
 * example_account_privilege = alicloud.rds.AccountPrivilege("example",
 *     instance_id=example_instance.id,
 *     account_name=example_rds_account.name,
 *     privilege="ReadWrite",
 *     db_names=[example_database&#46;name])
 * example_subscription_job = alicloud.dts.SubscriptionJob("example",
 *     dts_job_name=name,
 *     payment_type="PayAsYouGo",
 *     source_endpoint_engine_name="MySQL",
 *     source_endpoint_region=example.regions[0].id,
 *     source_endpoint_instance_type="RDS",
 *     source_endpoint_instance_id=example_instance.id,
 *     source_endpoint_database_name=example_database.name,
 *     source_endpoint_user_name=example_rds_account.account_name,
 *     source_endpoint_password=example_rds_account.account_password,
 *     db_list=pulumi.Output.json_dumps(pulumi.Output.all(
 *         exampleDatabaseName=example_database.name,
 *         exampleDatabaseName1=example_database.name
 * ).apply(lambda resolved_outputs: {
 *         resolved_outputs['exampleDatabaseName']: {
 *             "name": resolved_outputs['exampleDatabaseName1'],
 *             "all": True,
 *         },
 *     })
 * ),
 *     subscription_instance_network_type="vpc",
 *     subscription_instance_vpc_id=example_network.id,
 *     subscription_instance_vswitch_id=example_switch.id,
 *     status="Normal")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var example = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var exampleGetZones = AliCloud.Rds.GetZones.Invoke(new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "8.0",
 *         InstanceChargeType = "PostPaid",
 *         Category = "Basic",
 *         DbInstanceStorageType = "cloud_essd",
 *     });
 *     var exampleGetInstanceClasses = AliCloud.Rds.GetInstanceClasses.Invoke(new()
 *     {
 *         ZoneId = exampleGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         Engine = "MySQL",
 *         EngineVersion = "8.0",
 *         InstanceChargeType = "PostPaid",
 *         Category = "Basic",
 *         DbInstanceStorageType = "cloud_essd",
 *     });
 *     var exampleNetwork = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VpcId = exampleNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = exampleGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         VswitchName = name,
 *     });
 *     var exampleSecurityGroup = new AliCloud.Ecs.SecurityGroup("example", new()
 *     {
 *         Name = name,
 *         VpcId = exampleNetwork.Id,
 *     });
 *     var exampleInstance = new AliCloud.Rds.Instance("example", new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "8.0",
 *         InstanceType = exampleGetInstanceClasses.Apply(getInstanceClassesResult => getInstanceClassesResult.InstanceClasses[0]?.InstanceClass),
 *         InstanceStorage = exampleGetInstanceClasses.Apply(getInstanceClassesResult => getInstanceClassesResult.InstanceClasses[0]?.StorageRange?.Min),
 *         InstanceChargeType = "Postpaid",
 *         InstanceName = name,
 *         VswitchId = exampleSwitch.Id,
 *         MonitoringPeriod = 60,
 *         DbInstanceStorageType = "cloud_essd",
 *         SecurityGroupIds = new[]
 *         {
 *             exampleSecurityGroup.Id,
 *         },
 *     });
 *     var exampleRdsAccount = new AliCloud.Rds.RdsAccount("example", new()
 *     {
 *         DbInstanceId = exampleInstance.Id,
 *         AccountName = "test_mysql",
 *         AccountPassword = "N1cetest",
 *     });
 *     var exampleDatabase = new AliCloud.Rds.Database("example", new()
 *     {
 *         InstanceId = exampleInstance.Id,
 *         Name = name,
 *     });
 *     var exampleAccountPrivilege = new AliCloud.Rds.AccountPrivilege("example", new()
 *     {
 *         InstanceId = exampleInstance.Id,
 *         AccountName = exampleRdsAccount.Name,
 *         Privilege = "ReadWrite",
 *         DbNames = new[]
 *         {
 *             exampleDatabase.Name,
 *         },
 *     });
 *     var exampleSubscriptionJob = new AliCloud.Dts.SubscriptionJob("example", new()
 *     {
 *         DtsJobName = name,
 *         PaymentType = "PayAsYouGo",
 *         SourceEndpointEngineName = "MySQL",
 *         SourceEndpointRegion = example.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id),
 *         SourceEndpointInstanceType = "RDS",
 *         SourceEndpointInstanceId = exampleInstance.Id,
 *         SourceEndpointDatabaseName = exampleDatabase.Name,
 *         SourceEndpointUserName = exampleRdsAccount.AccountName,
 *         SourceEndpointPassword = exampleRdsAccount.AccountPassword,
 *         DbList = Output.JsonSerialize(Output.Create(Output.Tuple(exampleDatabase.Name, exampleDatabase.Name).Apply(values =>
 *         {
 *             var exampleDatabaseName = values.Item1;
 *             var exampleDatabaseName1 = values.Item2;
 *             return
 *             {
 *                 { exampleDatabaseName,
 *                 {
 *                     { "name", exampleDatabaseName1 },
 *                     { "all", true },
 *                 } },
 *             };
 *         }))),
 *         SubscriptionInstanceNetworkType = "vpc",
 *         SubscriptionInstanceVpcId = exampleNetwork.Id,
 *         SubscriptionInstanceVswitchId = exampleSwitch.Id,
 *         Status = "Normal",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dts"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetZones, err := rds.GetZones(ctx, &rds.GetZonesArgs{
 * 			Engine:                pulumi.StringRef("MySQL"),
 * 			EngineVersion:         pulumi.StringRef("8.0"),
 * 			InstanceChargeType:    pulumi.StringRef("PostPaid"),
 * 			Category:              pulumi.StringRef("Basic"),
 * 			DbInstanceStorageType: pulumi.StringRef("cloud_essd"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetInstanceClasses, err := rds.GetInstanceClasses(ctx, &rds.GetInstanceClassesArgs{
 * 			ZoneId:                pulumi.StringRef(exampleGetZones.Zones[0].Id),
 * 			Engine:                pulumi.StringRef("MySQL"),
 * 			EngineVersion:         pulumi.StringRef("8.0"),
 * 			InstanceChargeType:    pulumi.StringRef("PostPaid"),
 * 			Category:              pulumi.StringRef("Basic"),
 * 			DbInstanceStorageType: pulumi.StringRef("cloud_essd"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleNetwork, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VpcId:       exampleNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(exampleGetZones.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSecurityGroup, err := ecs.NewSecurityGroup(ctx, "example", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: exampleNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstance, err := rds.NewInstance(ctx, "example", &rds.InstanceArgs{
 * 			Engine:                pulumi.String("MySQL"),
 * 			EngineVersion:         pulumi.String("8.0"),
 * 			InstanceType:          pulumi.String(exampleGetInstanceClasses.InstanceClasses[0].InstanceClass),
 * 			InstanceStorage:       pulumi.String(exampleGetInstanceClasses.InstanceClasses[0].StorageRange.Min),
 * 			InstanceChargeType:    pulumi.String("Postpaid"),
 * 			InstanceName:          pulumi.String(name),
 * 			VswitchId:             exampleSwitch.ID(),
 * 			MonitoringPeriod:      pulumi.Int(60),
 * 			DbInstanceStorageType: pulumi.String("cloud_essd"),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				exampleSecurityGroup.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRdsAccount, err := rds.NewRdsAccount(ctx, "example", &rds.RdsAccountArgs{
 * 			DbInstanceId:    exampleInstance.ID(),
 * 			AccountName:     pulumi.String("test_mysql"),
 * 			AccountPassword: pulumi.String("N1cetest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleDatabase, err := rds.NewDatabase(ctx, "example", &rds.DatabaseArgs{
 * 			InstanceId: exampleInstance.ID(),
 * 			Name:       pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewAccountPrivilege(ctx, "example", &rds.AccountPrivilegeArgs{
 * 			InstanceId:  exampleInstance.ID(),
 * 			AccountName: exampleRdsAccount.Name,
 * 			Privilege:   pulumi.String("ReadWrite"),
 * 			DbNames: pulumi.StringArray{
 * 				exampleDatabase.Name,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dts.NewSubscriptionJob(ctx, "example", &dts.SubscriptionJobArgs{
 * 			DtsJobName:                 pulumi.String(name),
 * 			PaymentType:                pulumi.String("PayAsYouGo"),
 * 			SourceEndpointEngineName:   pulumi.String("MySQL"),
 * 			SourceEndpointRegion:       pulumi.String(example.Regions[0].Id),
 * 			SourceEndpointInstanceType: pulumi.String("RDS"),
 * 			SourceEndpointInstanceId:   exampleInstance.ID(),
 * 			SourceEndpointDatabaseName: exampleDatabase.Name,
 * 			SourceEndpointUserName:     exampleRdsAccount.AccountName,
 * 			SourceEndpointPassword:     exampleRdsAccount.AccountPassword,
 * 			DbList: pulumi.All(exampleDatabase.Name, exampleDatabase.Name).ApplyT(func(_args []interface{}) (string, error) {
 * 				exampleDatabaseName := _args[0].(string)
 * 				exampleDatabaseName1 := _args[1].(string)
 * 				var _zero string
 * 				tmpJSON0, err := json.Marshal(map[string]map[string]interface{}{
 * 					exampleDatabaseName: map[string]interface{}{
 * 						"name": exampleDatabaseName1,
 * 						"all":  true,
 * 					},
 * 				})
 * 				if err != nil {
 * 					return _zero, err
 * 				}
 * 				json0 := string(tmpJSON0)
 * 				return json0, nil
 * 			}).(pulumi.StringOutput),
 * 			SubscriptionInstanceNetworkType: pulumi.String("vpc"),
 * 			SubscriptionInstanceVpcId:       exampleNetwork.ID(),
 * 			SubscriptionInstanceVswitchId:   exampleSwitch.ID(),
 * 			Status:                          pulumi.String("Normal"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.rds.RdsFunctions;
 * import com.pulumi.alicloud.rds.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.rds.inputs.GetInstanceClassesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.rds.Instance;
 * import com.pulumi.alicloud.rds.InstanceArgs;
 * import com.pulumi.alicloud.rds.RdsAccount;
 * import com.pulumi.alicloud.rds.RdsAccountArgs;
 * import com.pulumi.alicloud.rds.Database;
 * import com.pulumi.alicloud.rds.DatabaseArgs;
 * import com.pulumi.alicloud.rds.AccountPrivilege;
 * import com.pulumi.alicloud.rds.AccountPrivilegeArgs;
 * import com.pulumi.alicloud.dts.SubscriptionJob;
 * import com.pulumi.alicloud.dts.SubscriptionJobArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var example = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         final var exampleGetZones = RdsFunctions.getZones(GetZonesArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("8.0")
 *             .instanceChargeType("PostPaid")
 *             .category("Basic")
 *             .dbInstanceStorageType("cloud_essd")
 *             .build());
 *         final var exampleGetInstanceClasses = RdsFunctions.getInstanceClasses(GetInstanceClassesArgs.builder()
 *             .zoneId(exampleGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .engine("MySQL")
 *             .engineVersion("8.0")
 *             .instanceChargeType("PostPaid")
 *             .category("Basic")
 *             .dbInstanceStorageType("cloud_essd")
 *             .build());
 *         var exampleNetwork = new Network("exampleNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vpcId(exampleNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(exampleGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .vswitchName(name)
 *             .build());
 *         var exampleSecurityGroup = new SecurityGroup("exampleSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(exampleNetwork.id())
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("8.0")
 *             .instanceType(exampleGetInstanceClasses.applyValue(getInstanceClassesResult -> getInstanceClassesResult.instanceClasses()[0].instanceClass()))
 *             .instanceStorage(exampleGetInstanceClasses.applyValue(getInstanceClassesResult -> getInstanceClassesResult.instanceClasses()[0].storageRange().min()))
 *             .instanceChargeType("Postpaid")
 *             .instanceName(name)
 *             .vswitchId(exampleSwitch.id())
 *             .monitoringPeriod("60")
 *             .dbInstanceStorageType("cloud_essd")
 *             .securityGroupIds(exampleSecurityGroup.id())
 *             .build());
 *         var exampleRdsAccount = new RdsAccount("exampleRdsAccount", RdsAccountArgs.builder()
 *             .dbInstanceId(exampleInstance.id())
 *             .accountName("test_mysql")
 *             .accountPassword("N1cetest")
 *             .build());
 *         var exampleDatabase = new Database("exampleDatabase", DatabaseArgs.builder()
 *             .instanceId(exampleInstance.id())
 *             .name(name)
 *             .build());
 *         var exampleAccountPrivilege = new AccountPrivilege("exampleAccountPrivilege", AccountPrivilegeArgs.builder()
 *             .instanceId(exampleInstance.id())
 *             .accountName(exampleRdsAccount.name())
 *             .privilege("ReadWrite")
 *             .dbNames(exampleDatabase.name())
 *             .build());
 *         var exampleSubscriptionJob = new SubscriptionJob("exampleSubscriptionJob", SubscriptionJobArgs.builder()
 *             .dtsJobName(name)
 *             .paymentType("PayAsYouGo")
 *             .sourceEndpointEngineName("MySQL")
 *             .sourceEndpointRegion(example.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()))
 *             .sourceEndpointInstanceType("RDS")
 *             .sourceEndpointInstanceId(exampleInstance.id())
 *             .sourceEndpointDatabaseName(exampleDatabase.name())
 *             .sourceEndpointUserName(exampleRdsAccount.accountName())
 *             .sourceEndpointPassword(exampleRdsAccount.accountPassword())
 *             .dbList(Output.tuple(exampleDatabase.name(), exampleDatabase.name()).applyValue(values -> {
 *                 var exampleDatabaseName = values.t1;
 *                 var exampleDatabaseName1 = values.t2;
 *                 return serializeJson(
 *                     jsonObject(
 *                         jsonProperty(exampleDatabaseName, jsonObject(
 *                             jsonProperty("name", exampleDatabaseName1),
 *                             jsonProperty("all", true)
 *                         ))
 *                     ));
 *             }))
 *             .subscriptionInstanceNetworkType("vpc")
 *             .subscriptionInstanceVpcId(exampleNetwork.id())
 *             .subscriptionInstanceVswitchId(exampleSwitch.id())
 *             .status("Normal")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   exampleNetwork:
 *     type: alicloud:vpc:Network
 *     name: example
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vpcId: ${exampleNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${exampleGetZones.zones[0].id}
 *       vswitchName: ${name}
 *   exampleSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: example
 *     properties:
 *       name: ${name}
 *       vpcId: ${exampleNetwork.id}
 *   exampleInstance:
 *     type: alicloud:rds:Instance
 *     name: example
 *     properties:
 *       engine: MySQL
 *       engineVersion: '8.0'
 *       instanceType: ${exampleGetInstanceClasses.instanceClasses[0].instanceClass}
 *       instanceStorage: ${exampleGetInstanceClasses.instanceClasses[0].storageRange.min}
 *       instanceChargeType: Postpaid
 *       instanceName: ${name}
 *       vswitchId: ${exampleSwitch.id}
 *       monitoringPeriod: '60'
 *       dbInstanceStorageType: cloud_essd
 *       securityGroupIds:
 *         - ${exampleSecurityGroup.id}
 *   exampleRdsAccount:
 *     type: alicloud:rds:RdsAccount
 *     name: example
 *     properties:
 *       dbInstanceId: ${exampleInstance.id}
 *       accountName: test_mysql
 *       accountPassword: N1cetest
 *   exampleDatabase:
 *     type: alicloud:rds:Database
 *     name: example
 *     properties:
 *       instanceId: ${exampleInstance.id}
 *       name: ${name}
 *   exampleAccountPrivilege:
 *     type: alicloud:rds:AccountPrivilege
 *     name: example
 *     properties:
 *       instanceId: ${exampleInstance.id}
 *       accountName: ${exampleRdsAccount.name}
 *       privilege: ReadWrite
 *       dbNames:
 *         - ${exampleDatabase.name}
 *   exampleSubscriptionJob:
 *     type: alicloud:dts:SubscriptionJob
 *     name: example
 *     properties:
 *       dtsJobName: ${name}
 *       paymentType: PayAsYouGo
 *       sourceEndpointEngineName: MySQL
 *       sourceEndpointRegion: ${example.regions[0].id}
 *       sourceEndpointInstanceType: RDS
 *       sourceEndpointInstanceId: ${exampleInstance.id}
 *       sourceEndpointDatabaseName: ${exampleDatabase.name}
 *       sourceEndpointUserName: ${exampleRdsAccount.accountName}
 *       sourceEndpointPassword: ${exampleRdsAccount.accountPassword}
 *       dbList:
 *         fn::toJSON:
 *           ${exampleDatabase.name}:
 *             name: ${exampleDatabase.name}
 *             all: true
 *       subscriptionInstanceNetworkType: vpc
 *       subscriptionInstanceVpcId: ${exampleNetwork.id}
 *       subscriptionInstanceVswitchId: ${exampleSwitch.id}
 *       status: Normal
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 *   exampleGetZones:
 *     fn::invoke:
 *       Function: alicloud:rds:getZones
 *       Arguments:
 *         engine: MySQL
 *         engineVersion: '8.0'
 *         instanceChargeType: PostPaid
 *         category: Basic
 *         dbInstanceStorageType: cloud_essd
 *   exampleGetInstanceClasses:
 *     fn::invoke:
 *       Function: alicloud:rds:getInstanceClasses
 *       Arguments:
 *         zoneId: ${exampleGetZones.zones[0].id}
 *         engine: MySQL
 *         engineVersion: '8.0'
 *         instanceChargeType: PostPaid
 *         category: Basic
 *         dbInstanceStorageType: cloud_essd
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DTS Subscription Job can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dts/subscriptionJob:SubscriptionJob example <id>
 * ```
 * @property checkpoint Subscription start time in Unix timestamp format.
 * @property computeUnit [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
 * @property databaseCount The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
 * @property dbList Subscription object, in the format of JSON strings. For detailed definitions, please refer to the description of migration, synchronization or subscription objects [document](https://help.aliyun.com/document_detail/209545.html).
 * @property delayNotice This parameter decides whether to monitor the delay status. Valid values: `true`, `false`.
 * @property delayPhone The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
 * @property delayRuleTime When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
 * @property destinationEndpointEngineName The destination endpoint engine name. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`.
 * @property destinationRegion The destination region. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
 * @property dtsInstanceId The ID of subscription instance.
 * @property dtsJobName The name of subscription task.
 * @property errorNotice This parameter decides whether to monitor abnormal status. Valid values: `true`, `false`.
 * @property errorPhone The mobile phone number of the contact for abnormal alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
 * @property instanceClass The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
 * @property paymentDuration The duration of prepaid instance purchase. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
 * @property paymentDurationUnit The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
 * @property paymentType The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
 * @property reserve DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter description of the [Reserve parameter](https://help.aliyun.com/document_detail/176470.html).
 * @property sourceEndpointDatabaseName To subscribe to the name of the database.
 * @property sourceEndpointEngineName The source database type value is MySQL or Oracle. Valid values: `MySQL`, `Oracle`.
 * @property sourceEndpointInstanceId The ID of source instance. Only when the type of source database instance was RDS MySQL, PolarDB-X 1.0, PolarDB MySQL, this parameter can be available and must be set.
 * @property sourceEndpointInstanceType The type of source instance. Valid values: `RDS`, `PolarDB`, `DRDS`, `LocalInstance`, `ECS`, `Express`, `CEN`, `dg`.
 * @property sourceEndpointIp The IP of source endpoint.
 * @property sourceEndpointOracleSid The SID of Oracle Database. When the source database is self-built Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
 * @property sourceEndpointOwnerId The Alibaba Cloud account ID to which the source instance belongs. This parameter is only available when configuring data subscriptions across Alibaba Cloud accounts and must be passed in.
 * @property sourceEndpointPassword The password of source database instance account.
 * @property sourceEndpointPort The port of source database.
 * @property sourceEndpointRegion The region of source database.
 * @property sourceEndpointRole Both the authorization roles. When the source instance and configure subscriptions task of the Alibaba Cloud account is not the same as the need to pass the parameter, to specify the source of the authorization roles, to allow configuration subscription task of the Alibaba Cloud account to access the source of the source instance information.
 * @property sourceEndpointUserName The username of source database instance account.
 * @property status The status of the task. Valid values: `Normal`, `Abnormal`. When a task created, it is in this state of `NotStarted`. You can specify this state to `Normal` to start the job, and specify this state of `Abnormal` to stop the job. **Note: We treat the state `Starting` as the state of `Normal`, and consider the two states to be consistent on the user side.**
 * @property subscriptionDataTypeDdl Whether to subscribe the DDL type of data. Valid values: `true`, `false`.
 * @property subscriptionDataTypeDml Whether to subscribe the DML type of data. Valid values: `true`, `false`.
 * @property subscriptionInstanceNetworkType Subscription task type of network value: classic: classic Network. Virtual Private Cloud (vpc): a vpc. Valid values: `classic`, `vpc`.
 * @property subscriptionInstanceVpcId The ID of subscription vpc instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
 * @property subscriptionInstanceVswitchId The ID of subscription VSwitch instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
 * @property syncArchitecture The sync architecture. Valid values: `bidirectional`, `oneway`.
 * @property synchronizationDirection The synchronization direction. Valid values: `Forward`, `Reverse`. When the topology type of the data synchronization instance is bidirectional, it can be passed in to reverse to start the reverse synchronization link.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class SubscriptionJobArgs(
    public val checkpoint: Output<String>? = null,
    public val computeUnit: Output<Int>? = null,
    public val databaseCount: Output<Int>? = null,
    public val dbList: Output<String>? = null,
    public val delayNotice: Output<Boolean>? = null,
    public val delayPhone: Output<String>? = null,
    public val delayRuleTime: Output<String>? = null,
    public val destinationEndpointEngineName: Output<String>? = null,
    public val destinationRegion: Output<String>? = null,
    public val dtsInstanceId: Output<String>? = null,
    public val dtsJobName: Output<String>? = null,
    public val errorNotice: Output<Boolean>? = null,
    public val errorPhone: Output<String>? = null,
    public val instanceClass: Output<String>? = null,
    public val paymentDuration: Output<Int>? = null,
    public val paymentDurationUnit: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val reserve: Output<String>? = null,
    public val sourceEndpointDatabaseName: Output<String>? = null,
    public val sourceEndpointEngineName: Output<String>? = null,
    public val sourceEndpointInstanceId: Output<String>? = null,
    public val sourceEndpointInstanceType: Output<String>? = null,
    public val sourceEndpointIp: Output<String>? = null,
    public val sourceEndpointOracleSid: Output<String>? = null,
    public val sourceEndpointOwnerId: Output<String>? = null,
    public val sourceEndpointPassword: Output<String>? = null,
    public val sourceEndpointPort: Output<String>? = null,
    public val sourceEndpointRegion: Output<String>? = null,
    public val sourceEndpointRole: Output<String>? = null,
    public val sourceEndpointUserName: Output<String>? = null,
    public val status: Output<String>? = null,
    public val subscriptionDataTypeDdl: Output<Boolean>? = null,
    public val subscriptionDataTypeDml: Output<Boolean>? = null,
    public val subscriptionInstanceNetworkType: Output<String>? = null,
    public val subscriptionInstanceVpcId: Output<String>? = null,
    public val subscriptionInstanceVswitchId: Output<String>? = null,
    public val syncArchitecture: Output<String>? = null,
    public val synchronizationDirection: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dts.SubscriptionJobArgs> {
    override fun toJava(): com.pulumi.alicloud.dts.SubscriptionJobArgs =
        com.pulumi.alicloud.dts.SubscriptionJobArgs.builder()
            .checkpoint(checkpoint?.applyValue({ args0 -> args0 }))
            .computeUnit(computeUnit?.applyValue({ args0 -> args0 }))
            .databaseCount(databaseCount?.applyValue({ args0 -> args0 }))
            .dbList(dbList?.applyValue({ args0 -> args0 }))
            .delayNotice(delayNotice?.applyValue({ args0 -> args0 }))
            .delayPhone(delayPhone?.applyValue({ args0 -> args0 }))
            .delayRuleTime(delayRuleTime?.applyValue({ args0 -> args0 }))
            .destinationEndpointEngineName(destinationEndpointEngineName?.applyValue({ args0 -> args0 }))
            .destinationRegion(destinationRegion?.applyValue({ args0 -> args0 }))
            .dtsInstanceId(dtsInstanceId?.applyValue({ args0 -> args0 }))
            .dtsJobName(dtsJobName?.applyValue({ args0 -> args0 }))
            .errorNotice(errorNotice?.applyValue({ args0 -> args0 }))
            .errorPhone(errorPhone?.applyValue({ args0 -> args0 }))
            .instanceClass(instanceClass?.applyValue({ args0 -> args0 }))
            .paymentDuration(paymentDuration?.applyValue({ args0 -> args0 }))
            .paymentDurationUnit(paymentDurationUnit?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .reserve(reserve?.applyValue({ args0 -> args0 }))
            .sourceEndpointDatabaseName(sourceEndpointDatabaseName?.applyValue({ args0 -> args0 }))
            .sourceEndpointEngineName(sourceEndpointEngineName?.applyValue({ args0 -> args0 }))
            .sourceEndpointInstanceId(sourceEndpointInstanceId?.applyValue({ args0 -> args0 }))
            .sourceEndpointInstanceType(sourceEndpointInstanceType?.applyValue({ args0 -> args0 }))
            .sourceEndpointIp(sourceEndpointIp?.applyValue({ args0 -> args0 }))
            .sourceEndpointOracleSid(sourceEndpointOracleSid?.applyValue({ args0 -> args0 }))
            .sourceEndpointOwnerId(sourceEndpointOwnerId?.applyValue({ args0 -> args0 }))
            .sourceEndpointPassword(sourceEndpointPassword?.applyValue({ args0 -> args0 }))
            .sourceEndpointPort(sourceEndpointPort?.applyValue({ args0 -> args0 }))
            .sourceEndpointRegion(sourceEndpointRegion?.applyValue({ args0 -> args0 }))
            .sourceEndpointRole(sourceEndpointRole?.applyValue({ args0 -> args0 }))
            .sourceEndpointUserName(sourceEndpointUserName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .subscriptionDataTypeDdl(subscriptionDataTypeDdl?.applyValue({ args0 -> args0 }))
            .subscriptionDataTypeDml(subscriptionDataTypeDml?.applyValue({ args0 -> args0 }))
            .subscriptionInstanceNetworkType(subscriptionInstanceNetworkType?.applyValue({ args0 -> args0 }))
            .subscriptionInstanceVpcId(subscriptionInstanceVpcId?.applyValue({ args0 -> args0 }))
            .subscriptionInstanceVswitchId(subscriptionInstanceVswitchId?.applyValue({ args0 -> args0 }))
            .syncArchitecture(syncArchitecture?.applyValue({ args0 -> args0 }))
            .synchronizationDirection(synchronizationDirection?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SubscriptionJobArgs].
 */
@PulumiTagMarker
public class SubscriptionJobArgsBuilder internal constructor() {
    private var checkpoint: Output<String>? = null

    private var computeUnit: Output<Int>? = null

    private var databaseCount: Output<Int>? = null

    private var dbList: Output<String>? = null

    private var delayNotice: Output<Boolean>? = null

    private var delayPhone: Output<String>? = null

    private var delayRuleTime: Output<String>? = null

    private var destinationEndpointEngineName: Output<String>? = null

    private var destinationRegion: Output<String>? = null

    private var dtsInstanceId: Output<String>? = null

    private var dtsJobName: Output<String>? = null

    private var errorNotice: Output<Boolean>? = null

    private var errorPhone: Output<String>? = null

    private var instanceClass: Output<String>? = null

    private var paymentDuration: Output<Int>? = null

    private var paymentDurationUnit: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var reserve: Output<String>? = null

    private var sourceEndpointDatabaseName: Output<String>? = null

    private var sourceEndpointEngineName: Output<String>? = null

    private var sourceEndpointInstanceId: Output<String>? = null

    private var sourceEndpointInstanceType: Output<String>? = null

    private var sourceEndpointIp: Output<String>? = null

    private var sourceEndpointOracleSid: Output<String>? = null

    private var sourceEndpointOwnerId: Output<String>? = null

    private var sourceEndpointPassword: Output<String>? = null

    private var sourceEndpointPort: Output<String>? = null

    private var sourceEndpointRegion: Output<String>? = null

    private var sourceEndpointRole: Output<String>? = null

    private var sourceEndpointUserName: Output<String>? = null

    private var status: Output<String>? = null

    private var subscriptionDataTypeDdl: Output<Boolean>? = null

    private var subscriptionDataTypeDml: Output<Boolean>? = null

    private var subscriptionInstanceNetworkType: Output<String>? = null

    private var subscriptionInstanceVpcId: Output<String>? = null

    private var subscriptionInstanceVswitchId: Output<String>? = null

    private var syncArchitecture: Output<String>? = null

    private var synchronizationDirection: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Subscription start time in Unix timestamp format.
     */
    @JvmName("bxticqwemslwwisn")
    public suspend fun checkpoint(`value`: Output<String>) {
        this.checkpoint = value
    }

    /**
     * @param value [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
     */
    @JvmName("jtdefjmnpvchuwpa")
    public suspend fun computeUnit(`value`: Output<Int>) {
        this.computeUnit = value
    }

    /**
     * @param value The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
     */
    @JvmName("iajvybdbhsakvasw")
    public suspend fun databaseCount(`value`: Output<Int>) {
        this.databaseCount = value
    }

    /**
     * @param value Subscription object, in the format of JSON strings. For detailed definitions, please refer to the description of migration, synchronization or subscription objects [document](https://help.aliyun.com/document_detail/209545.html).
     */
    @JvmName("qlrpbqxrxsltjaqu")
    public suspend fun dbList(`value`: Output<String>) {
        this.dbList = value
    }

    /**
     * @param value This parameter decides whether to monitor the delay status. Valid values: `true`, `false`.
     */
    @JvmName("xbjrgkyxdcxbqubu")
    public suspend fun delayNotice(`value`: Output<Boolean>) {
        this.delayNotice = value
    }

    /**
     * @param value The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
     */
    @JvmName("cbovrjmdhqvshjra")
    public suspend fun delayPhone(`value`: Output<String>) {
        this.delayPhone = value
    }

    /**
     * @param value When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
     */
    @JvmName("uodcygjngcxewwtr")
    public suspend fun delayRuleTime(`value`: Output<String>) {
        this.delayRuleTime = value
    }

    /**
     * @param value The destination endpoint engine name. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`.
     */
    @JvmName("elnhcilbytcakgyv")
    public suspend fun destinationEndpointEngineName(`value`: Output<String>) {
        this.destinationEndpointEngineName = value
    }

    /**
     * @param value The destination region. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
     */
    @JvmName("blubxlutdferikqu")
    public suspend fun destinationRegion(`value`: Output<String>) {
        this.destinationRegion = value
    }

    /**
     * @param value The ID of subscription instance.
     */
    @JvmName("uyurwocsajhevlkk")
    public suspend fun dtsInstanceId(`value`: Output<String>) {
        this.dtsInstanceId = value
    }

    /**
     * @param value The name of subscription task.
     */
    @JvmName("aenoigaijthwnjxm")
    public suspend fun dtsJobName(`value`: Output<String>) {
        this.dtsJobName = value
    }

    /**
     * @param value This parameter decides whether to monitor abnormal status. Valid values: `true`, `false`.
     */
    @JvmName("bypqexfmealofrig")
    public suspend fun errorNotice(`value`: Output<Boolean>) {
        this.errorNotice = value
    }

    /**
     * @param value The mobile phone number of the contact for abnormal alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
     */
    @JvmName("iajicjmkjcmvschq")
    public suspend fun errorPhone(`value`: Output<String>) {
        this.errorPhone = value
    }

    /**
     * @param value The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
     */
    @JvmName("dfctrgvtdwdvpsds")
    public suspend fun instanceClass(`value`: Output<String>) {
        this.instanceClass = value
    }

    /**
     * @param value The duration of prepaid instance purchase. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
     */
    @JvmName("pholrxcghfmxdkoa")
    public suspend fun paymentDuration(`value`: Output<Int>) {
        this.paymentDuration = value
    }

    /**
     * @param value The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
     */
    @JvmName("oswkpmfspjpwwbgg")
    public suspend fun paymentDurationUnit(`value`: Output<String>) {
        this.paymentDurationUnit = value
    }

    /**
     * @param value The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
     */
    @JvmName("fliwvxtmbudywynq")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter description of the [Reserve parameter](https://help.aliyun.com/document_detail/176470.html).
     */
    @JvmName("wmlbrmoaeeonocwa")
    public suspend fun reserve(`value`: Output<String>) {
        this.reserve = value
    }

    /**
     * @param value To subscribe to the name of the database.
     */
    @JvmName("movhhitkqeqfixxq")
    public suspend fun sourceEndpointDatabaseName(`value`: Output<String>) {
        this.sourceEndpointDatabaseName = value
    }

    /**
     * @param value The source database type value is MySQL or Oracle. Valid values: `MySQL`, `Oracle`.
     */
    @JvmName("jphkbmlkcohnmbbi")
    public suspend fun sourceEndpointEngineName(`value`: Output<String>) {
        this.sourceEndpointEngineName = value
    }

    /**
     * @param value The ID of source instance. Only when the type of source database instance was RDS MySQL, PolarDB-X 1.0, PolarDB MySQL, this parameter can be available and must be set.
     */
    @JvmName("dvqrxsjifrsvywwc")
    public suspend fun sourceEndpointInstanceId(`value`: Output<String>) {
        this.sourceEndpointInstanceId = value
    }

    /**
     * @param value The type of source instance. Valid values: `RDS`, `PolarDB`, `DRDS`, `LocalInstance`, `ECS`, `Express`, `CEN`, `dg`.
     */
    @JvmName("cdyquhhmpbskaoyk")
    public suspend fun sourceEndpointInstanceType(`value`: Output<String>) {
        this.sourceEndpointInstanceType = value
    }

    /**
     * @param value The IP of source endpoint.
     */
    @JvmName("eyvpaqqwuwagnimh")
    public suspend fun sourceEndpointIp(`value`: Output<String>) {
        this.sourceEndpointIp = value
    }

    /**
     * @param value The SID of Oracle Database. When the source database is self-built Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
     */
    @JvmName("ebxaxtnmrhfkldju")
    public suspend fun sourceEndpointOracleSid(`value`: Output<String>) {
        this.sourceEndpointOracleSid = value
    }

    /**
     * @param value The Alibaba Cloud account ID to which the source instance belongs. This parameter is only available when configuring data subscriptions across Alibaba Cloud accounts and must be passed in.
     */
    @JvmName("mkastxjhmbsjpjrh")
    public suspend fun sourceEndpointOwnerId(`value`: Output<String>) {
        this.sourceEndpointOwnerId = value
    }

    /**
     * @param value The password of source database instance account.
     */
    @JvmName("mputssscewmpuwvp")
    public suspend fun sourceEndpointPassword(`value`: Output<String>) {
        this.sourceEndpointPassword = value
    }

    /**
     * @param value The port of source database.
     */
    @JvmName("aijvufpwkxceeyti")
    public suspend fun sourceEndpointPort(`value`: Output<String>) {
        this.sourceEndpointPort = value
    }

    /**
     * @param value The region of source database.
     */
    @JvmName("ekxuvhcnicyegiaj")
    public suspend fun sourceEndpointRegion(`value`: Output<String>) {
        this.sourceEndpointRegion = value
    }

    /**
     * @param value Both the authorization roles. When the source instance and configure subscriptions task of the Alibaba Cloud account is not the same as the need to pass the parameter, to specify the source of the authorization roles, to allow configuration subscription task of the Alibaba Cloud account to access the source of the source instance information.
     */
    @JvmName("ufgctsofnkaecrde")
    public suspend fun sourceEndpointRole(`value`: Output<String>) {
        this.sourceEndpointRole = value
    }

    /**
     * @param value The username of source database instance account.
     */
    @JvmName("mgampiswtmhixury")
    public suspend fun sourceEndpointUserName(`value`: Output<String>) {
        this.sourceEndpointUserName = value
    }

    /**
     * @param value The status of the task. Valid values: `Normal`, `Abnormal`. When a task created, it is in this state of `NotStarted`. You can specify this state to `Normal` to start the job, and specify this state of `Abnormal` to stop the job. **Note: We treat the state `Starting` as the state of `Normal`, and consider the two states to be consistent on the user side.**
     */
    @JvmName("yfpolehojkvaxibj")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Whether to subscribe the DDL type of data. Valid values: `true`, `false`.
     */
    @JvmName("nabfybokudkbwbcj")
    public suspend fun subscriptionDataTypeDdl(`value`: Output<Boolean>) {
        this.subscriptionDataTypeDdl = value
    }

    /**
     * @param value Whether to subscribe the DML type of data. Valid values: `true`, `false`.
     */
    @JvmName("eaklhohdlgylxiax")
    public suspend fun subscriptionDataTypeDml(`value`: Output<Boolean>) {
        this.subscriptionDataTypeDml = value
    }

    /**
     * @param value Subscription task type of network value: classic: classic Network. Virtual Private Cloud (vpc): a vpc. Valid values: `classic`, `vpc`.
     */
    @JvmName("awovjimebwaujpqr")
    public suspend fun subscriptionInstanceNetworkType(`value`: Output<String>) {
        this.subscriptionInstanceNetworkType = value
    }

    /**
     * @param value The ID of subscription vpc instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
     */
    @JvmName("olyhottnxdwggxkv")
    public suspend fun subscriptionInstanceVpcId(`value`: Output<String>) {
        this.subscriptionInstanceVpcId = value
    }

    /**
     * @param value The ID of subscription VSwitch instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
     */
    @JvmName("dxljaxtjtxglroph")
    public suspend fun subscriptionInstanceVswitchId(`value`: Output<String>) {
        this.subscriptionInstanceVswitchId = value
    }

    /**
     * @param value The sync architecture. Valid values: `bidirectional`, `oneway`.
     */
    @JvmName("prcmbfnsjpkgrrvj")
    public suspend fun syncArchitecture(`value`: Output<String>) {
        this.syncArchitecture = value
    }

    /**
     * @param value The synchronization direction. Valid values: `Forward`, `Reverse`. When the topology type of the data synchronization instance is bidirectional, it can be passed in to reverse to start the reverse synchronization link.
     */
    @JvmName("ntjwcpbrdckvvyhs")
    public suspend fun synchronizationDirection(`value`: Output<String>) {
        this.synchronizationDirection = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("hvmrkmmaoybguipg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Subscription start time in Unix timestamp format.
     */
    @JvmName("oklxukpcojgxnefu")
    public suspend fun checkpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpoint = mapped
    }

    /**
     * @param value [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
     */
    @JvmName("ghrpqgagxvmdfcgx")
    public suspend fun computeUnit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeUnit = mapped
    }

    /**
     * @param value The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
     */
    @JvmName("imklixuokiperysk")
    public suspend fun databaseCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseCount = mapped
    }

    /**
     * @param value Subscription object, in the format of JSON strings. For detailed definitions, please refer to the description of migration, synchronization or subscription objects [document](https://help.aliyun.com/document_detail/209545.html).
     */
    @JvmName("dpvnukgoheciumdp")
    public suspend fun dbList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbList = mapped
    }

    /**
     * @param value This parameter decides whether to monitor the delay status. Valid values: `true`, `false`.
     */
    @JvmName("whjkxyttdvchgcub")
    public suspend fun delayNotice(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delayNotice = mapped
    }

    /**
     * @param value The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
     */
    @JvmName("hxkruittbloceovu")
    public suspend fun delayPhone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delayPhone = mapped
    }

    /**
     * @param value When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
     */
    @JvmName("fsjalaplcjnptgua")
    public suspend fun delayRuleTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delayRuleTime = mapped
    }

    /**
     * @param value The destination endpoint engine name. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`.
     */
    @JvmName("ujmvkxirhxpogfhs")
    public suspend fun destinationEndpointEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointEngineName = mapped
    }

    /**
     * @param value The destination region. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
     */
    @JvmName("gxnlstsrxsjrgegm")
    public suspend fun destinationRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationRegion = mapped
    }

    /**
     * @param value The ID of subscription instance.
     */
    @JvmName("wdqffaohivwhtkjc")
    public suspend fun dtsInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dtsInstanceId = mapped
    }

    /**
     * @param value The name of subscription task.
     */
    @JvmName("jnptwtuhxilcfnck")
    public suspend fun dtsJobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dtsJobName = mapped
    }

    /**
     * @param value This parameter decides whether to monitor abnormal status. Valid values: `true`, `false`.
     */
    @JvmName("mymopqhqdabcdpex")
    public suspend fun errorNotice(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorNotice = mapped
    }

    /**
     * @param value The mobile phone number of the contact for abnormal alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
     */
    @JvmName("ooxwwmqsetobqwhl")
    public suspend fun errorPhone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorPhone = mapped
    }

    /**
     * @param value The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
     */
    @JvmName("rdmsrlcbjseijbbu")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceClass = mapped
    }

    /**
     * @param value The duration of prepaid instance purchase. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
     */
    @JvmName("jbyechrgjfjiunip")
    public suspend fun paymentDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentDuration = mapped
    }

    /**
     * @param value The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
     */
    @JvmName("kbiujghtcbxvvhng")
    public suspend fun paymentDurationUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentDurationUnit = mapped
    }

    /**
     * @param value The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
     */
    @JvmName("hbrfvfwjeabfmmhk")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter description of the [Reserve parameter](https://help.aliyun.com/document_detail/176470.html).
     */
    @JvmName("axfejouqssmadpfk")
    public suspend fun reserve(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reserve = mapped
    }

    /**
     * @param value To subscribe to the name of the database.
     */
    @JvmName("jkusrcdvfwlvsuux")
    public suspend fun sourceEndpointDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointDatabaseName = mapped
    }

    /**
     * @param value The source database type value is MySQL or Oracle. Valid values: `MySQL`, `Oracle`.
     */
    @JvmName("aqxkacnmlbefifit")
    public suspend fun sourceEndpointEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointEngineName = mapped
    }

    /**
     * @param value The ID of source instance. Only when the type of source database instance was RDS MySQL, PolarDB-X 1.0, PolarDB MySQL, this parameter can be available and must be set.
     */
    @JvmName("ylhbghiyjbpjpkic")
    public suspend fun sourceEndpointInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointInstanceId = mapped
    }

    /**
     * @param value The type of source instance. Valid values: `RDS`, `PolarDB`, `DRDS`, `LocalInstance`, `ECS`, `Express`, `CEN`, `dg`.
     */
    @JvmName("mtbmkadcqtfrelkl")
    public suspend fun sourceEndpointInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointInstanceType = mapped
    }

    /**
     * @param value The IP of source endpoint.
     */
    @JvmName("yedbncsgwsupjdwk")
    public suspend fun sourceEndpointIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointIp = mapped
    }

    /**
     * @param value The SID of Oracle Database. When the source database is self-built Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
     */
    @JvmName("vkndfsakgmidjjxd")
    public suspend fun sourceEndpointOracleSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointOracleSid = mapped
    }

    /**
     * @param value The Alibaba Cloud account ID to which the source instance belongs. This parameter is only available when configuring data subscriptions across Alibaba Cloud accounts and must be passed in.
     */
    @JvmName("avqhdubqgbwkbflf")
    public suspend fun sourceEndpointOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointOwnerId = mapped
    }

    /**
     * @param value The password of source database instance account.
     */
    @JvmName("nluthklfpknnoeym")
    public suspend fun sourceEndpointPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointPassword = mapped
    }

    /**
     * @param value The port of source database.
     */
    @JvmName("kojiivevpfaeclda")
    public suspend fun sourceEndpointPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointPort = mapped
    }

    /**
     * @param value The region of source database.
     */
    @JvmName("merjdgfcywetydex")
    public suspend fun sourceEndpointRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointRegion = mapped
    }

    /**
     * @param value Both the authorization roles. When the source instance and configure subscriptions task of the Alibaba Cloud account is not the same as the need to pass the parameter, to specify the source of the authorization roles, to allow configuration subscription task of the Alibaba Cloud account to access the source of the source instance information.
     */
    @JvmName("disuqvxxtnhjpwul")
    public suspend fun sourceEndpointRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointRole = mapped
    }

    /**
     * @param value The username of source database instance account.
     */
    @JvmName("svfxkbgbupmoqrrh")
    public suspend fun sourceEndpointUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointUserName = mapped
    }

    /**
     * @param value The status of the task. Valid values: `Normal`, `Abnormal`. When a task created, it is in this state of `NotStarted`. You can specify this state to `Normal` to start the job, and specify this state of `Abnormal` to stop the job. **Note: We treat the state `Starting` as the state of `Normal`, and consider the two states to be consistent on the user side.**
     */
    @JvmName("setdljoutfxtxhkx")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Whether to subscribe the DDL type of data. Valid values: `true`, `false`.
     */
    @JvmName("nexwsfvtxyvrhrdp")
    public suspend fun subscriptionDataTypeDdl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionDataTypeDdl = mapped
    }

    /**
     * @param value Whether to subscribe the DML type of data. Valid values: `true`, `false`.
     */
    @JvmName("nhmbrhtwahsgvawb")
    public suspend fun subscriptionDataTypeDml(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionDataTypeDml = mapped
    }

    /**
     * @param value Subscription task type of network value: classic: classic Network. Virtual Private Cloud (vpc): a vpc. Valid values: `classic`, `vpc`.
     */
    @JvmName("mqktsgvtlqdebldj")
    public suspend fun subscriptionInstanceNetworkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionInstanceNetworkType = mapped
    }

    /**
     * @param value The ID of subscription vpc instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
     */
    @JvmName("dnpikxqkxjikhnat")
    public suspend fun subscriptionInstanceVpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionInstanceVpcId = mapped
    }

    /**
     * @param value The ID of subscription VSwitch instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
     */
    @JvmName("kfuocsckwvysnauh")
    public suspend fun subscriptionInstanceVswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionInstanceVswitchId = mapped
    }

    /**
     * @param value The sync architecture. Valid values: `bidirectional`, `oneway`.
     */
    @JvmName("abdjfrfuqeifrifu")
    public suspend fun syncArchitecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncArchitecture = mapped
    }

    /**
     * @param value The synchronization direction. Valid values: `Forward`, `Reverse`. When the topology type of the data synchronization instance is bidirectional, it can be passed in to reverse to start the reverse synchronization link.
     */
    @JvmName("gpeheuakcemrddbx")
    public suspend fun synchronizationDirection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synchronizationDirection = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("rfjestjebumvisvm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("rrwasalvngirqqju")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SubscriptionJobArgs = SubscriptionJobArgs(
        checkpoint = checkpoint,
        computeUnit = computeUnit,
        databaseCount = databaseCount,
        dbList = dbList,
        delayNotice = delayNotice,
        delayPhone = delayPhone,
        delayRuleTime = delayRuleTime,
        destinationEndpointEngineName = destinationEndpointEngineName,
        destinationRegion = destinationRegion,
        dtsInstanceId = dtsInstanceId,
        dtsJobName = dtsJobName,
        errorNotice = errorNotice,
        errorPhone = errorPhone,
        instanceClass = instanceClass,
        paymentDuration = paymentDuration,
        paymentDurationUnit = paymentDurationUnit,
        paymentType = paymentType,
        reserve = reserve,
        sourceEndpointDatabaseName = sourceEndpointDatabaseName,
        sourceEndpointEngineName = sourceEndpointEngineName,
        sourceEndpointInstanceId = sourceEndpointInstanceId,
        sourceEndpointInstanceType = sourceEndpointInstanceType,
        sourceEndpointIp = sourceEndpointIp,
        sourceEndpointOracleSid = sourceEndpointOracleSid,
        sourceEndpointOwnerId = sourceEndpointOwnerId,
        sourceEndpointPassword = sourceEndpointPassword,
        sourceEndpointPort = sourceEndpointPort,
        sourceEndpointRegion = sourceEndpointRegion,
        sourceEndpointRole = sourceEndpointRole,
        sourceEndpointUserName = sourceEndpointUserName,
        status = status,
        subscriptionDataTypeDdl = subscriptionDataTypeDdl,
        subscriptionDataTypeDml = subscriptionDataTypeDml,
        subscriptionInstanceNetworkType = subscriptionInstanceNetworkType,
        subscriptionInstanceVpcId = subscriptionInstanceVpcId,
        subscriptionInstanceVswitchId = subscriptionInstanceVswitchId,
        syncArchitecture = syncArchitecture,
        synchronizationDirection = synchronizationDirection,
        tags = tags,
    )
}
