@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin

import com.pulumi.alicloud.dts.SynchronizationInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DTS Synchronization Instance resource.
 * For information about DTS Synchronization Instance and how to use it, see [What is Synchronization Instance](https://www.alibabacloud.com/help/en/doc-detail/130744.html).
 * > **NOTE:** Available since v1.138.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultSynchronizationInstance = new alicloud.dts.SynchronizationInstance("default", {
 *     paymentType: "PayAsYouGo",
 *     sourceEndpointEngineName: "MySQL",
 *     sourceEndpointRegion: _default.then(_default => _default.regions?.[0]?.id),
 *     destinationEndpointEngineName: "MySQL",
 *     destinationEndpointRegion: _default.then(_default => _default.regions?.[0]?.id),
 *     instanceClass: "small",
 *     syncArchitecture: "oneway",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_regions(current=True)
 * default_synchronization_instance = alicloud.dts.SynchronizationInstance("default",
 *     payment_type="PayAsYouGo",
 *     source_endpoint_engine_name="MySQL",
 *     source_endpoint_region=default.regions[0].id,
 *     destination_endpoint_engine_name="MySQL",
 *     destination_endpoint_region=default.regions[0].id,
 *     instance_class="small",
 *     sync_architecture="oneway")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultSynchronizationInstance = new AliCloud.Dts.SynchronizationInstance("default", new()
 *     {
 *         PaymentType = "PayAsYouGo",
 *         SourceEndpointEngineName = "MySQL",
 *         SourceEndpointRegion = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         DestinationEndpointEngineName = "MySQL",
 *         DestinationEndpointRegion = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         InstanceClass = "small",
 *         SyncArchitecture = "oneway",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dts"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dts.NewSynchronizationInstance(ctx, "default", &dts.SynchronizationInstanceArgs{
 * 			PaymentType:                   pulumi.String("PayAsYouGo"),
 * 			SourceEndpointEngineName:      pulumi.String("MySQL"),
 * 			SourceEndpointRegion:          pulumi.String(_default.Regions[0].Id),
 * 			DestinationEndpointEngineName: pulumi.String("MySQL"),
 * 			DestinationEndpointRegion:     pulumi.String(_default.Regions[0].Id),
 * 			InstanceClass:                 pulumi.String("small"),
 * 			SyncArchitecture:              pulumi.String("oneway"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.dts.SynchronizationInstance;
 * import com.pulumi.alicloud.dts.SynchronizationInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultSynchronizationInstance = new SynchronizationInstance("defaultSynchronizationInstance", SynchronizationInstanceArgs.builder()
 *             .paymentType("PayAsYouGo")
 *             .sourceEndpointEngineName("MySQL")
 *             .sourceEndpointRegion(default_.regions()[0].id())
 *             .destinationEndpointEngineName("MySQL")
 *             .destinationEndpointRegion(default_.regions()[0].id())
 *             .instanceClass("small")
 *             .syncArchitecture("oneway")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultSynchronizationInstance:
 *     type: alicloud:dts:SynchronizationInstance
 *     name: default
 *     properties:
 *       paymentType: PayAsYouGo
 *       sourceEndpointEngineName: MySQL
 *       sourceEndpointRegion: ${default.regions[0].id}
 *       destinationEndpointEngineName: MySQL
 *       destinationEndpointRegion: ${default.regions[0].id}
 *       instanceClass: small
 *       syncArchitecture: oneway
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DTS Synchronization Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dts/synchronizationInstance:SynchronizationInstance example <id>
 * ```
 * @property autoPay Whether to automatically renew when it expires. Valid values: `true`, `false`.
 * @property autoStart Whether to automatically start the task after the purchase completed. Valid values: `true`, `false`.
 * @property computeUnit [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
 * @property databaseCount The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
 * @property destinationEndpointEngineName The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
 * @property destinationEndpointRegion The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
 * @property instanceClass The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
 * @property paymentDuration The duration of prepaid instance purchase. this parameter is required When `payment_type` equals `Subscription`.
 * @property paymentDurationUnit The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
 * @property paymentType The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
 * @property quantity The number of instances purchased.
 * @property sourceEndpointEngineName The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
 * @property sourceEndpointRegion The region of source instance.
 * @property syncArchitecture The sync architecture. Valid values: `oneway`, `bidirectional`.
 */
public data class SynchronizationInstanceArgs(
    public val autoPay: Output<String>? = null,
    public val autoStart: Output<String>? = null,
    public val computeUnit: Output<Int>? = null,
    public val databaseCount: Output<Int>? = null,
    public val destinationEndpointEngineName: Output<String>? = null,
    public val destinationEndpointRegion: Output<String>? = null,
    public val instanceClass: Output<String>? = null,
    public val paymentDuration: Output<Int>? = null,
    public val paymentDurationUnit: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val quantity: Output<Int>? = null,
    public val sourceEndpointEngineName: Output<String>? = null,
    public val sourceEndpointRegion: Output<String>? = null,
    public val syncArchitecture: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dts.SynchronizationInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.dts.SynchronizationInstanceArgs =
        com.pulumi.alicloud.dts.SynchronizationInstanceArgs.builder()
            .autoPay(autoPay?.applyValue({ args0 -> args0 }))
            .autoStart(autoStart?.applyValue({ args0 -> args0 }))
            .computeUnit(computeUnit?.applyValue({ args0 -> args0 }))
            .databaseCount(databaseCount?.applyValue({ args0 -> args0 }))
            .destinationEndpointEngineName(destinationEndpointEngineName?.applyValue({ args0 -> args0 }))
            .destinationEndpointRegion(destinationEndpointRegion?.applyValue({ args0 -> args0 }))
            .instanceClass(instanceClass?.applyValue({ args0 -> args0 }))
            .paymentDuration(paymentDuration?.applyValue({ args0 -> args0 }))
            .paymentDurationUnit(paymentDurationUnit?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .quantity(quantity?.applyValue({ args0 -> args0 }))
            .sourceEndpointEngineName(sourceEndpointEngineName?.applyValue({ args0 -> args0 }))
            .sourceEndpointRegion(sourceEndpointRegion?.applyValue({ args0 -> args0 }))
            .syncArchitecture(syncArchitecture?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SynchronizationInstanceArgs].
 */
@PulumiTagMarker
public class SynchronizationInstanceArgsBuilder internal constructor() {
    private var autoPay: Output<String>? = null

    private var autoStart: Output<String>? = null

    private var computeUnit: Output<Int>? = null

    private var databaseCount: Output<Int>? = null

    private var destinationEndpointEngineName: Output<String>? = null

    private var destinationEndpointRegion: Output<String>? = null

    private var instanceClass: Output<String>? = null

    private var paymentDuration: Output<Int>? = null

    private var paymentDurationUnit: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var quantity: Output<Int>? = null

    private var sourceEndpointEngineName: Output<String>? = null

    private var sourceEndpointRegion: Output<String>? = null

    private var syncArchitecture: Output<String>? = null

    /**
     * @param value Whether to automatically renew when it expires. Valid values: `true`, `false`.
     */
    @JvmName("nvjwkpobomwdieye")
    public suspend fun autoPay(`value`: Output<String>) {
        this.autoPay = value
    }

    /**
     * @param value Whether to automatically start the task after the purchase completed. Valid values: `true`, `false`.
     */
    @JvmName("vddawvefndpwuvag")
    public suspend fun autoStart(`value`: Output<String>) {
        this.autoStart = value
    }

    /**
     * @param value [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
     */
    @JvmName("roaeitftgcklifvx")
    public suspend fun computeUnit(`value`: Output<Int>) {
        this.computeUnit = value
    }

    /**
     * @param value The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
     */
    @JvmName("qjabdcbkwwdwuouk")
    public suspend fun databaseCount(`value`: Output<Int>) {
        this.databaseCount = value
    }

    /**
     * @param value The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
     */
    @JvmName("wnoctqqjyfsnifqd")
    public suspend fun destinationEndpointEngineName(`value`: Output<String>) {
        this.destinationEndpointEngineName = value
    }

    /**
     * @param value The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
     */
    @JvmName("bbiytkopjlqxjmmj")
    public suspend fun destinationEndpointRegion(`value`: Output<String>) {
        this.destinationEndpointRegion = value
    }

    /**
     * @param value The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
     */
    @JvmName("cceevuserkdcnxhq")
    public suspend fun instanceClass(`value`: Output<String>) {
        this.instanceClass = value
    }

    /**
     * @param value The duration of prepaid instance purchase. this parameter is required When `payment_type` equals `Subscription`.
     */
    @JvmName("fpfimaohqjbuflhr")
    public suspend fun paymentDuration(`value`: Output<Int>) {
        this.paymentDuration = value
    }

    /**
     * @param value The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
     */
    @JvmName("lpftlnyiwhqaptkr")
    public suspend fun paymentDurationUnit(`value`: Output<String>) {
        this.paymentDurationUnit = value
    }

    /**
     * @param value The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
     */
    @JvmName("ihnkfyeybmvfwtpy")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The number of instances purchased.
     */
    @JvmName("krvjimddtdqoykmf")
    public suspend fun quantity(`value`: Output<Int>) {
        this.quantity = value
    }

    /**
     * @param value The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
     */
    @JvmName("giipcqsrrpigpwxm")
    public suspend fun sourceEndpointEngineName(`value`: Output<String>) {
        this.sourceEndpointEngineName = value
    }

    /**
     * @param value The region of source instance.
     */
    @JvmName("fmikgstcfgwgrebn")
    public suspend fun sourceEndpointRegion(`value`: Output<String>) {
        this.sourceEndpointRegion = value
    }

    /**
     * @param value The sync architecture. Valid values: `oneway`, `bidirectional`.
     */
    @JvmName("uvruvbguehardaij")
    public suspend fun syncArchitecture(`value`: Output<String>) {
        this.syncArchitecture = value
    }

    /**
     * @param value Whether to automatically renew when it expires. Valid values: `true`, `false`.
     */
    @JvmName("kqcwdbpsqkuwfqgv")
    public suspend fun autoPay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPay = mapped
    }

    /**
     * @param value Whether to automatically start the task after the purchase completed. Valid values: `true`, `false`.
     */
    @JvmName("rwhclmfuhabxutox")
    public suspend fun autoStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoStart = mapped
    }

    /**
     * @param value [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
     */
    @JvmName("kistivaedwrovikw")
    public suspend fun computeUnit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeUnit = mapped
    }

    /**
     * @param value The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
     */
    @JvmName("aewnbsyefeikilbu")
    public suspend fun databaseCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseCount = mapped
    }

    /**
     * @param value The type of destination engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
     */
    @JvmName("coyccaabmsshfygf")
    public suspend fun destinationEndpointEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointEngineName = mapped
    }

    /**
     * @param value The region of destination instance. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
     */
    @JvmName("aowhkyogkdmqfwuj")
    public suspend fun destinationEndpointRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointRegion = mapped
    }

    /**
     * @param value The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
     */
    @JvmName("herfugxjofampmsp")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceClass = mapped
    }

    /**
     * @param value The duration of prepaid instance purchase. this parameter is required When `payment_type` equals `Subscription`.
     */
    @JvmName("ewwcdyglhnwpgwkb")
    public suspend fun paymentDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentDuration = mapped
    }

    /**
     * @param value The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
     */
    @JvmName("orvnceellahxvawb")
    public suspend fun paymentDurationUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentDurationUnit = mapped
    }

    /**
     * @param value The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
     */
    @JvmName("cuxrqeahlcxifuwb")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The number of instances purchased.
     */
    @JvmName("ibyjhbpgxnyfayge")
    public suspend fun quantity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quantity = mapped
    }

    /**
     * @param value The type of source endpoint engine. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`. For the correspondence between the supported source and target libraries, see [Supported Databases, Synchronization Initialization Types and Synchronization Topologies](https://help&#46;aliyun&#46;com/document_detail/130744&#46;html), [Supported Databases and Migration Types](https://help.aliyun.com/document_detail/26618.html).
     */
    @JvmName("dymmakympnauhycj")
    public suspend fun sourceEndpointEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointEngineName = mapped
    }

    /**
     * @param value The region of source instance.
     */
    @JvmName("vaklmioynkfpelkp")
    public suspend fun sourceEndpointRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointRegion = mapped
    }

    /**
     * @param value The sync architecture. Valid values: `oneway`, `bidirectional`.
     */
    @JvmName("ajiqiajqmtqrjfmy")
    public suspend fun syncArchitecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncArchitecture = mapped
    }

    internal fun build(): SynchronizationInstanceArgs = SynchronizationInstanceArgs(
        autoPay = autoPay,
        autoStart = autoStart,
        computeUnit = computeUnit,
        databaseCount = databaseCount,
        destinationEndpointEngineName = destinationEndpointEngineName,
        destinationEndpointRegion = destinationEndpointRegion,
        instanceClass = instanceClass,
        paymentDuration = paymentDuration,
        paymentDurationUnit = paymentDurationUnit,
        paymentType = paymentType,
        quantity = quantity,
        sourceEndpointEngineName = sourceEndpointEngineName,
        sourceEndpointRegion = sourceEndpointRegion,
        syncArchitecture = syncArchitecture,
    )
}
