@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SynchronizationJob].
 */
@PulumiTagMarker
public class SynchronizationJobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SynchronizationJobArgs = SynchronizationJobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SynchronizationJobArgsBuilder.() -> Unit) {
        val builder = SynchronizationJobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SynchronizationJob {
        val builtJavaResource = com.pulumi.alicloud.dts.SynchronizationJob(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SynchronizationJob(builtJavaResource)
    }
}

/**
 * Provides a DTS Synchronization Job resource.
 * For information about DTS Synchronization Job and how to use it, see [What is Synchronization Job](https://www.alibabacloud.com/product/data-transmission-service).
 * > **NOTE:** Available since v1.138.0.
 * ## Import
 * DTS Synchronization Job can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dts/synchronizationJob:SynchronizationJob example <id>
 * ```
 */
public class SynchronizationJob internal constructor(
    override val javaResource: com.pulumi.alicloud.dts.SynchronizationJob,
) : KotlinCustomResource(javaResource, SynchronizationJobMapper) {
    /**
     * The start point or synchronization point of incremental data migration, the format is Unix timestamp, and the unit is seconds.
     */
    public val checkpoint: Output<String>
        get() = javaResource.checkpoint().applyValue({ args0 -> args0 })

    /**
     * The data verification task of the migration or synchronization instance, in the format of a JSON string, such as parameter limits or alarm configurations. For more information, see the DataCheckConfigure parameter description [datacheckconfigure-parameter](https://help.aliyun.com/zh/dts/developer-reference/datacheckconfigure-parameter).
     */
    public val dataCheckConfigure: Output<String>?
        get() = javaResource.dataCheckConfigure().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to perform full data migration or full data initialization. Valid values: `true`, `false`.
     */
    public val dataInitialization: Output<Boolean>
        get() = javaResource.dataInitialization().applyValue({ args0 -> args0 })

    /**
     * Whether to perform incremental data migration or synchronization. Valid values: `true`, `false`.
     */
    public val dataSynchronization: Output<Boolean>
        get() = javaResource.dataSynchronization().applyValue({ args0 -> args0 })

    /**
     * Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html). **NOTE:** From version 1.173.0, `db_list` can be modified.
     */
    public val dbList: Output<String>
        get() = javaResource.dbList().applyValue({ args0 -> args0 })

    /**
     * When the ID of the dedicated cluster is input, the task is scheduled to the corresponding cluster.
     */
    public val dedicatedClusterId: Output<String>?
        get() = javaResource.dedicatedClusterId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The delay notice. Valid values: `true`, `false`.
     */
    public val delayNotice: Output<Boolean>?
        get() = javaResource.delayNotice().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The delay phone. The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
     */
    public val delayPhone: Output<String>?
        get() = javaResource.delayPhone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The delay rule time. When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
     */
    public val delayRuleTime: Output<String>?
        get() = javaResource.delayRuleTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the database to which the migration object belongs in the target instance. Note: when the target instance or target database type is PolarDB O engine, AnalyticDB PostgreSQL, PostgreSQL, MongoDB database, this parameter is available and must be passed in.
     */
    public val destinationEndpointDatabaseName: Output<String>?
        get() = javaResource.destinationEndpointDatabaseName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of destination database. The default value is MYSQL. For the correspondence between supported target libraries and source libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the target instance is KAFKA or MONGODB, you also need to pass in some information in the reserved parameter `reserve`. For the configuration method, see the description of `reserve` parameters. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
     */
    public val destinationEndpointEngineName: Output<String>
        get() = javaResource.destinationEndpointEngineName().applyValue({ args0 -> args0 })

    /**
     * The ID of destination instance. If the target instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the target instance is a self-built database, the value of this parameter changes according to the value of `destination_endpoint_instance_type`. For example, the value of `destination_endpoint_instance_type` is:
     * ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
     * ** `DG`, then this parameter needs to be passed into the ID of database gateway.
     * ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
     */
    public val destinationEndpointInstanceId: Output<String>?
        get() = javaResource.destinationEndpointInstanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of destination instance. If the target instance is a PolarDB O engine cluster, the target instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. If the target instance is the Kafka version of Message Queuing, the target instance type needs to be `ECS` or `EXPRESS` as a self-built database, and access via ECS or dedicated line. For the correspondence between supported targets and source instances, see [Supported Databases](https://help&#46;aliyun&#46;com/document_detail/131497&#46;htm)&#46; When the target instance is a self-built database, you also need to perform corresponding preparations, please refer to the [overview of preparations](https://help.aliyun.com/document_detail/146958.htm). Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
     */
    public val destinationEndpointInstanceType: Output<String>
        get() = javaResource.destinationEndpointInstanceType().applyValue({ args0 -> args0 })

    /**
     * The IP of source endpoint. When `destination_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
     */
    public val destinationEndpointIp: Output<String>?
        get() = javaResource.destinationEndpointIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SID of Oracle database. Note: when the value of DestinationEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
     */
    public val destinationEndpointOracleSid: Output<String>?
        get() = javaResource.destinationEndpointOracleSid().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Alibaba Cloud account to which the target RDS MySQL instance belongs. can be configured only when the target instance is RDS MySQL. This parameter is used to migrate or synchronize data across Alibaba Cloud accounts. You also need to enter the **destinationendpointrle** parameter.
     */
    public val destinationEndpointOwnerId: Output<String>?
        get() = javaResource.destinationEndpointOwnerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The password of database account.
     */
    public val destinationEndpointPassword: Output<String>?
        get() = javaResource.destinationEndpointPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port of source endpoint. When the target instance is a self-built database, this parameter is available and must be passed in.
     */
    public val destinationEndpointPort: Output<String>?
        get() = javaResource.destinationEndpointPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The region of destination instance. For the target instance region, please refer to the [list of supported regions](https://help.aliyun.com/document_detail/141033.htm). Note: if the target is an Alibaba Cloud database, this parameter must be passed in.
     */
    public val destinationEndpointRegion: Output<String>?
        get() = javaResource.destinationEndpointRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The role name of the Alibaba Cloud account to which the target instance belongs. This parameter must be entered when data migration or synchronization across Alibaba Cloud accounts is performed. For the permissions and authorization methods required by this role.
     */
    public val destinationEndpointRole: Output<String>?
        get() = javaResource.destinationEndpointRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help&#46;aliyun&#46;com/document_detail/175878&#46;htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
     */
    public val destinationEndpointUserName: Output<String>?
        get() = javaResource.destinationEndpointUserName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The environment label of the DTS instance. The value is: **normal**, **online**.
     * > **NOTE:** From the status of `NotStarted` to `Synchronizing`, the resource goes through the `Prechecking` and `Initializing` phases. Because of the `Initializing` phase takes too long, and once the resource passes to the status of `Prechecking`, it can be considered that the task can be executed normally. Therefore, we treat the status of `Initializing` as an equivalent to `Synchronizing`.
     * > **NOTE:** If you want to upgrade the synchronization job specifications by the property `instance_class`, you must also modify the property `instance_class` of it's instance to keep them consistent.
     */
    public val dtsBisLabel: Output<String>?
        get() = javaResource.dtsBisLabel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of synchronization instance, it must be an ID of `alicloud.dts.SynchronizationInstance`.
     */
    public val dtsInstanceId: Output<String>
        get() = javaResource.dtsInstanceId().applyValue({ args0 -> args0 })

    /**
     * The name of synchronization job.
     */
    public val dtsJobName: Output<String>
        get() = javaResource.dtsJobName().applyValue({ args0 -> args0 })

    /**
     * The error notice. Valid values: `true`, `false`.
     */
    public val errorNotice: Output<Boolean>?
        get() = javaResource.errorNotice().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The error phone. The mobile phone number of the contact who error the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
     */
    public val errorPhone: Output<String>?
        get() = javaResource.errorPhone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
     */
    public val instanceClass: Output<String>
        get() = javaResource.instanceClass().applyValue({ args0 -> args0 })

    /**
     * DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter [description of the Reserve parameter](https://help.aliyun.com/document_detail/273111.html).
     */
    public val reserve: Output<String>
        get() = javaResource.reserve().applyValue({ args0 -> args0 })

    /**
     * The name of the database to which the migration object belongs in the source instance. Note: this parameter is only available and must be passed in when the source instance, or the database type of the source instance is PolarDB O engine, PostgreSQL, or MongoDB database.
     */
    public val sourceEndpointDatabaseName: Output<String>?
        get() = javaResource.sourceEndpointDatabaseName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of source database. The default value is `MySQL`. For the correspondence between supported source libraries and target libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the source instance is `MONGODB`, you also need to pass in some information in the reserved parameter `Reserve`, for the configuration method, see the description of Reserve parameters. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
     */
    public val sourceEndpointEngineName: Output<String>
        get() = javaResource.sourceEndpointEngineName().applyValue({ args0 -> args0 })

    /**
     * The ID of source instance. If the source instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the source instance is a self-built database, the value of this parameter changes according to the value of `source_endpoint_instance_type`. For example, the value of `source_endpoint_instance_type` is:
     * ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
     * ** `DG`, then this parameter needs to be passed into the ID of database gateway.
     * ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
     */
    public val sourceEndpointInstanceId: Output<String>?
        get() = javaResource.sourceEndpointInstanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of source instance. If the source instance is a `PolarDB O` engine cluster, the source instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. For the correspondence between supported source and target instances, see [Supported Databases](https://help&#46;aliyun&#46;com/document_detail/131497&#46;htm)&#46; When the source instance is a self-built database, you also need to perform corresponding preparations, for details, see [Preparations Overview](https://help.aliyun.com/document_detail/146958.htm). Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
     */
    public val sourceEndpointInstanceType: Output<String>
        get() = javaResource.sourceEndpointInstanceType().applyValue({ args0 -> args0 })

    /**
     * The IP of source endpoint. When `source_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
     */
    public val sourceEndpointIp: Output<String>?
        get() = javaResource.sourceEndpointIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SID of Oracle database. When the value of SourceEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
     */
    public val sourceEndpointOracleSid: Output<String>?
        get() = javaResource.sourceEndpointOracleSid().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of Alibaba Cloud account to which the source instance belongs. Note: passing in this parameter means performing data migration or synchronization across Alibaba Cloud accounts, and you also need to pass in the `source_endpoint_role` parameter.
     */
    public val sourceEndpointOwnerId: Output<String>?
        get() = javaResource.sourceEndpointOwnerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The password of database account.
     */
    public val sourceEndpointPassword: Output<String>?
        get() = javaResource.sourceEndpointPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port of source endpoint. When the source instance is a self-built database, this parameter is available and must be passed in.
     */
    public val sourceEndpointPort: Output<String>?
        get() = javaResource.sourceEndpointPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Source instance area, please refer to the [list of supported areas](https://help.aliyun.com/document_detail/141033.htm) for details. Note if the source is an Alibaba Cloud database, this parameter must be passed in.
     */
    public val sourceEndpointRegion: Output<String>?
        get() = javaResource.sourceEndpointRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the role configured for the cloud account to which the source instance belongs. Note: this parameter must be passed in when performing cross Alibaba Cloud account data migration or synchronization. For the permissions and authorization methods required by this role, please refer to [How to configure RAM authorization when cross-Alibaba Cloud account data migration or synchronization](https://help.aliyun.com/document_detail/48468.htm).
     */
    public val sourceEndpointRole: Output<String>?
        get() = javaResource.sourceEndpointRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help&#46;aliyun&#46;com/document_detail/175878&#46;htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
     */
    public val sourceEndpointUserName: Output<String>?
        get() = javaResource.sourceEndpointUserName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Data Delivery link switch instance id
     */
    public val sourceEndpointVswitchId: Output<String>?
        get() = javaResource.sourceEndpointVswitchId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Whether to perform library table structure migration or initialization. Valid values: `true`, `false`.
     */
    public val structureInitialization: Output<Boolean>
        get() = javaResource.structureInitialization().applyValue({ args0 -> args0 })

    /**
     * Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `alicloud.dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
     */
    public val synchronizationDirection: Output<String>
        get() = javaResource.synchronizationDirection().applyValue({ args0 -> args0 })
}

public object SynchronizationJobMapper : ResourceMapper<SynchronizationJob> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dts.SynchronizationJob::class == javaResource::class

    override fun map(javaResource: Resource): SynchronizationJob = SynchronizationJob(
        javaResource as
            com.pulumi.alicloud.dts.SynchronizationJob,
    )
}

/**
 * @see [SynchronizationJob].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SynchronizationJob].
 */
public suspend fun synchronizationJob(
    name: String,
    block: suspend SynchronizationJobResourceBuilder.() -> Unit,
): SynchronizationJob {
    val builder = SynchronizationJobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SynchronizationJob].
 * @param name The _unique_ name of the resulting resource.
 */
public fun synchronizationJob(name: String): SynchronizationJob {
    val builder = SynchronizationJobResourceBuilder()
    builder.name(name)
    return builder.build()
}
