@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin

import com.pulumi.alicloud.dts.SynchronizationJobArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DTS Synchronization Job resource.
 * For information about DTS Synchronization Job and how to use it, see [What is Synchronization Job](https://www.alibabacloud.com/product/data-transmission-service).
 * > **NOTE:** Available since v1.138.0.
 * ## Import
 * DTS Synchronization Job can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dts/synchronizationJob:SynchronizationJob example <id>
 * ```
 * @property checkpoint The start point or synchronization point of incremental data migration, the format is Unix timestamp, and the unit is seconds.
 * @property dataCheckConfigure The data verification task of the migration or synchronization instance, in the format of a JSON string, such as parameter limits or alarm configurations. For more information, see the DataCheckConfigure parameter description [datacheckconfigure-parameter](https://help.aliyun.com/zh/dts/developer-reference/datacheckconfigure-parameter).
 * @property dataInitialization Whether to perform full data migration or full data initialization. Valid values: `true`, `false`.
 * @property dataSynchronization Whether to perform incremental data migration or synchronization. Valid values: `true`, `false`.
 * @property dbList Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html). **NOTE:** From version 1.173.0, `db_list` can be modified.
 * @property dedicatedClusterId When the ID of the dedicated cluster is input, the task is scheduled to the corresponding cluster.
 * @property delayNotice The delay notice. Valid values: `true`, `false`.
 * @property delayPhone The delay phone. The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
 * @property delayRuleTime The delay rule time. When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
 * @property destinationEndpointDatabaseName The name of the database to which the migration object belongs in the target instance. Note: when the target instance or target database type is PolarDB O engine, AnalyticDB PostgreSQL, PostgreSQL, MongoDB database, this parameter is available and must be passed in.
 * @property destinationEndpointEngineName The type of destination database. The default value is MYSQL. For the correspondence between supported target libraries and source libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the target instance is KAFKA or MONGODB, you also need to pass in some information in the reserved parameter `reserve`. For the configuration method, see the description of `reserve` parameters. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
 * @property destinationEndpointInstanceId The ID of destination instance. If the target instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the target instance is a self-built database, the value of this parameter changes according to the value of `destination_endpoint_instance_type`. For example, the value of `destination_endpoint_instance_type` is:
 * ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
 * ** `DG`, then this parameter needs to be passed into the ID of database gateway.
 * ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
 * @property destinationEndpointInstanceType The type of destination instance. If the target instance is a PolarDB O engine cluster, the target instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. If the target instance is the Kafka version of Message Queuing, the target instance type needs to be `ECS` or `EXPRESS` as a self-built database, and access via ECS or dedicated line. For the correspondence between supported targets and source instances, see [Supported Databases](https://help&#46;aliyun&#46;com/document_detail/131497&#46;htm)&#46; When the target instance is a self-built database, you also need to perform corresponding preparations, please refer to the [overview of preparations](https://help.aliyun.com/document_detail/146958.htm). Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
 * @property destinationEndpointIp The IP of source endpoint. When `destination_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
 * @property destinationEndpointOracleSid The SID of Oracle database. Note: when the value of DestinationEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
 * @property destinationEndpointOwnerId The ID of the Alibaba Cloud account to which the target RDS MySQL instance belongs. can be configured only when the target instance is RDS MySQL. This parameter is used to migrate or synchronize data across Alibaba Cloud accounts. You also need to enter the **destinationendpointrle** parameter.
 * @property destinationEndpointPassword The password of database account.
 * @property destinationEndpointPort The port of source endpoint. When the target instance is a self-built database, this parameter is available and must be passed in.
 * @property destinationEndpointRegion The region of destination instance. For the target instance region, please refer to the [list of supported regions](https://help.aliyun.com/document_detail/141033.htm). Note: if the target is an Alibaba Cloud database, this parameter must be passed in.
 * @property destinationEndpointRole The role name of the Alibaba Cloud account to which the target instance belongs. This parameter must be entered when data migration or synchronization across Alibaba Cloud accounts is performed. For the permissions and authorization methods required by this role.
 * @property destinationEndpointUserName The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help&#46;aliyun&#46;com/document_detail/175878&#46;htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
 * @property dtsBisLabel The environment label of the DTS instance. The value is: **normal**, **online**.
 * > **NOTE:** From the status of `NotStarted` to `Synchronizing`, the resource goes through the `Prechecking` and `Initializing` phases. Because of the `Initializing` phase takes too long, and once the resource passes to the status of `Prechecking`, it can be considered that the task can be executed normally. Therefore, we treat the status of `Initializing` as an equivalent to `Synchronizing`.
 * > **NOTE:** If you want to upgrade the synchronization job specifications by the property `instance_class`, you must also modify the property `instance_class` of it's instance to keep them consistent.
 * @property dtsInstanceId The ID of synchronization instance, it must be an ID of `alicloud.dts.SynchronizationInstance`.
 * @property dtsJobName The name of synchronization job.
 * @property errorNotice The error notice. Valid values: `true`, `false`.
 * @property errorPhone The error phone. The mobile phone number of the contact who error the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
 * @property instanceClass The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
 * @property reserve DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter [description of the Reserve parameter](https://help.aliyun.com/document_detail/273111.html).
 * @property sourceEndpointDatabaseName The name of the database to which the migration object belongs in the source instance. Note: this parameter is only available and must be passed in when the source instance, or the database type of the source instance is PolarDB O engine, PostgreSQL, or MongoDB database.
 * @property sourceEndpointEngineName The type of source database. The default value is `MySQL`. For the correspondence between supported source libraries and target libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the source instance is `MONGODB`, you also need to pass in some information in the reserved parameter `Reserve`, for the configuration method, see the description of Reserve parameters. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
 * @property sourceEndpointInstanceId The ID of source instance. If the source instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the source instance is a self-built database, the value of this parameter changes according to the value of `source_endpoint_instance_type`. For example, the value of `source_endpoint_instance_type` is:
 * ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
 * ** `DG`, then this parameter needs to be passed into the ID of database gateway.
 * ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
 * @property sourceEndpointInstanceType The type of source instance. If the source instance is a `PolarDB O` engine cluster, the source instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. For the correspondence between supported source and target instances, see [Supported Databases](https://help&#46;aliyun&#46;com/document_detail/131497&#46;htm)&#46; When the source instance is a self-built database, you also need to perform corresponding preparations, for details, see [Preparations Overview](https://help.aliyun.com/document_detail/146958.htm). Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
 * @property sourceEndpointIp The IP of source endpoint. When `source_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
 * @property sourceEndpointOracleSid The SID of Oracle database. When the value of SourceEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
 * @property sourceEndpointOwnerId The ID of Alibaba Cloud account to which the source instance belongs. Note: passing in this parameter means performing data migration or synchronization across Alibaba Cloud accounts, and you also need to pass in the `source_endpoint_role` parameter.
 * @property sourceEndpointPassword The password of database account.
 * @property sourceEndpointPort The port of source endpoint. When the source instance is a self-built database, this parameter is available and must be passed in.
 * @property sourceEndpointRegion Source instance area, please refer to the [list of supported areas](https://help.aliyun.com/document_detail/141033.htm) for details. Note if the source is an Alibaba Cloud database, this parameter must be passed in.
 * @property sourceEndpointRole The name of the role configured for the cloud account to which the source instance belongs. Note: this parameter must be passed in when performing cross Alibaba Cloud account data migration or synchronization. For the permissions and authorization methods required by this role, please refer to [How to configure RAM authorization when cross-Alibaba Cloud account data migration or synchronization](https://help.aliyun.com/document_detail/48468.htm).
 * @property sourceEndpointUserName The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help&#46;aliyun&#46;com/document_detail/175878&#46;htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
 * @property sourceEndpointVswitchId Data Delivery link switch instance id
 * @property status The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
 * @property structureInitialization Whether to perform library table structure migration or initialization. Valid values: `true`, `false`.
 * @property synchronizationDirection Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `alicloud.dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
 */
public data class SynchronizationJobArgs(
    public val checkpoint: Output<String>? = null,
    public val dataCheckConfigure: Output<String>? = null,
    public val dataInitialization: Output<Boolean>? = null,
    public val dataSynchronization: Output<Boolean>? = null,
    public val dbList: Output<String>? = null,
    public val dedicatedClusterId: Output<String>? = null,
    public val delayNotice: Output<Boolean>? = null,
    public val delayPhone: Output<String>? = null,
    public val delayRuleTime: Output<String>? = null,
    public val destinationEndpointDatabaseName: Output<String>? = null,
    public val destinationEndpointEngineName: Output<String>? = null,
    public val destinationEndpointInstanceId: Output<String>? = null,
    public val destinationEndpointInstanceType: Output<String>? = null,
    public val destinationEndpointIp: Output<String>? = null,
    public val destinationEndpointOracleSid: Output<String>? = null,
    public val destinationEndpointOwnerId: Output<String>? = null,
    public val destinationEndpointPassword: Output<String>? = null,
    public val destinationEndpointPort: Output<String>? = null,
    public val destinationEndpointRegion: Output<String>? = null,
    public val destinationEndpointRole: Output<String>? = null,
    public val destinationEndpointUserName: Output<String>? = null,
    public val dtsBisLabel: Output<String>? = null,
    public val dtsInstanceId: Output<String>? = null,
    public val dtsJobName: Output<String>? = null,
    public val errorNotice: Output<Boolean>? = null,
    public val errorPhone: Output<String>? = null,
    public val instanceClass: Output<String>? = null,
    public val reserve: Output<String>? = null,
    public val sourceEndpointDatabaseName: Output<String>? = null,
    public val sourceEndpointEngineName: Output<String>? = null,
    public val sourceEndpointInstanceId: Output<String>? = null,
    public val sourceEndpointInstanceType: Output<String>? = null,
    public val sourceEndpointIp: Output<String>? = null,
    public val sourceEndpointOracleSid: Output<String>? = null,
    public val sourceEndpointOwnerId: Output<String>? = null,
    public val sourceEndpointPassword: Output<String>? = null,
    public val sourceEndpointPort: Output<String>? = null,
    public val sourceEndpointRegion: Output<String>? = null,
    public val sourceEndpointRole: Output<String>? = null,
    public val sourceEndpointUserName: Output<String>? = null,
    public val sourceEndpointVswitchId: Output<String>? = null,
    public val status: Output<String>? = null,
    public val structureInitialization: Output<Boolean>? = null,
    public val synchronizationDirection: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dts.SynchronizationJobArgs> {
    override fun toJava(): com.pulumi.alicloud.dts.SynchronizationJobArgs =
        com.pulumi.alicloud.dts.SynchronizationJobArgs.builder()
            .checkpoint(checkpoint?.applyValue({ args0 -> args0 }))
            .dataCheckConfigure(dataCheckConfigure?.applyValue({ args0 -> args0 }))
            .dataInitialization(dataInitialization?.applyValue({ args0 -> args0 }))
            .dataSynchronization(dataSynchronization?.applyValue({ args0 -> args0 }))
            .dbList(dbList?.applyValue({ args0 -> args0 }))
            .dedicatedClusterId(dedicatedClusterId?.applyValue({ args0 -> args0 }))
            .delayNotice(delayNotice?.applyValue({ args0 -> args0 }))
            .delayPhone(delayPhone?.applyValue({ args0 -> args0 }))
            .delayRuleTime(delayRuleTime?.applyValue({ args0 -> args0 }))
            .destinationEndpointDatabaseName(destinationEndpointDatabaseName?.applyValue({ args0 -> args0 }))
            .destinationEndpointEngineName(destinationEndpointEngineName?.applyValue({ args0 -> args0 }))
            .destinationEndpointInstanceId(destinationEndpointInstanceId?.applyValue({ args0 -> args0 }))
            .destinationEndpointInstanceType(destinationEndpointInstanceType?.applyValue({ args0 -> args0 }))
            .destinationEndpointIp(destinationEndpointIp?.applyValue({ args0 -> args0 }))
            .destinationEndpointOracleSid(destinationEndpointOracleSid?.applyValue({ args0 -> args0 }))
            .destinationEndpointOwnerId(destinationEndpointOwnerId?.applyValue({ args0 -> args0 }))
            .destinationEndpointPassword(destinationEndpointPassword?.applyValue({ args0 -> args0 }))
            .destinationEndpointPort(destinationEndpointPort?.applyValue({ args0 -> args0 }))
            .destinationEndpointRegion(destinationEndpointRegion?.applyValue({ args0 -> args0 }))
            .destinationEndpointRole(destinationEndpointRole?.applyValue({ args0 -> args0 }))
            .destinationEndpointUserName(destinationEndpointUserName?.applyValue({ args0 -> args0 }))
            .dtsBisLabel(dtsBisLabel?.applyValue({ args0 -> args0 }))
            .dtsInstanceId(dtsInstanceId?.applyValue({ args0 -> args0 }))
            .dtsJobName(dtsJobName?.applyValue({ args0 -> args0 }))
            .errorNotice(errorNotice?.applyValue({ args0 -> args0 }))
            .errorPhone(errorPhone?.applyValue({ args0 -> args0 }))
            .instanceClass(instanceClass?.applyValue({ args0 -> args0 }))
            .reserve(reserve?.applyValue({ args0 -> args0 }))
            .sourceEndpointDatabaseName(sourceEndpointDatabaseName?.applyValue({ args0 -> args0 }))
            .sourceEndpointEngineName(sourceEndpointEngineName?.applyValue({ args0 -> args0 }))
            .sourceEndpointInstanceId(sourceEndpointInstanceId?.applyValue({ args0 -> args0 }))
            .sourceEndpointInstanceType(sourceEndpointInstanceType?.applyValue({ args0 -> args0 }))
            .sourceEndpointIp(sourceEndpointIp?.applyValue({ args0 -> args0 }))
            .sourceEndpointOracleSid(sourceEndpointOracleSid?.applyValue({ args0 -> args0 }))
            .sourceEndpointOwnerId(sourceEndpointOwnerId?.applyValue({ args0 -> args0 }))
            .sourceEndpointPassword(sourceEndpointPassword?.applyValue({ args0 -> args0 }))
            .sourceEndpointPort(sourceEndpointPort?.applyValue({ args0 -> args0 }))
            .sourceEndpointRegion(sourceEndpointRegion?.applyValue({ args0 -> args0 }))
            .sourceEndpointRole(sourceEndpointRole?.applyValue({ args0 -> args0 }))
            .sourceEndpointUserName(sourceEndpointUserName?.applyValue({ args0 -> args0 }))
            .sourceEndpointVswitchId(sourceEndpointVswitchId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .structureInitialization(structureInitialization?.applyValue({ args0 -> args0 }))
            .synchronizationDirection(synchronizationDirection?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SynchronizationJobArgs].
 */
@PulumiTagMarker
public class SynchronizationJobArgsBuilder internal constructor() {
    private var checkpoint: Output<String>? = null

    private var dataCheckConfigure: Output<String>? = null

    private var dataInitialization: Output<Boolean>? = null

    private var dataSynchronization: Output<Boolean>? = null

    private var dbList: Output<String>? = null

    private var dedicatedClusterId: Output<String>? = null

    private var delayNotice: Output<Boolean>? = null

    private var delayPhone: Output<String>? = null

    private var delayRuleTime: Output<String>? = null

    private var destinationEndpointDatabaseName: Output<String>? = null

    private var destinationEndpointEngineName: Output<String>? = null

    private var destinationEndpointInstanceId: Output<String>? = null

    private var destinationEndpointInstanceType: Output<String>? = null

    private var destinationEndpointIp: Output<String>? = null

    private var destinationEndpointOracleSid: Output<String>? = null

    private var destinationEndpointOwnerId: Output<String>? = null

    private var destinationEndpointPassword: Output<String>? = null

    private var destinationEndpointPort: Output<String>? = null

    private var destinationEndpointRegion: Output<String>? = null

    private var destinationEndpointRole: Output<String>? = null

    private var destinationEndpointUserName: Output<String>? = null

    private var dtsBisLabel: Output<String>? = null

    private var dtsInstanceId: Output<String>? = null

    private var dtsJobName: Output<String>? = null

    private var errorNotice: Output<Boolean>? = null

    private var errorPhone: Output<String>? = null

    private var instanceClass: Output<String>? = null

    private var reserve: Output<String>? = null

    private var sourceEndpointDatabaseName: Output<String>? = null

    private var sourceEndpointEngineName: Output<String>? = null

    private var sourceEndpointInstanceId: Output<String>? = null

    private var sourceEndpointInstanceType: Output<String>? = null

    private var sourceEndpointIp: Output<String>? = null

    private var sourceEndpointOracleSid: Output<String>? = null

    private var sourceEndpointOwnerId: Output<String>? = null

    private var sourceEndpointPassword: Output<String>? = null

    private var sourceEndpointPort: Output<String>? = null

    private var sourceEndpointRegion: Output<String>? = null

    private var sourceEndpointRole: Output<String>? = null

    private var sourceEndpointUserName: Output<String>? = null

    private var sourceEndpointVswitchId: Output<String>? = null

    private var status: Output<String>? = null

    private var structureInitialization: Output<Boolean>? = null

    private var synchronizationDirection: Output<String>? = null

    /**
     * @param value The start point or synchronization point of incremental data migration, the format is Unix timestamp, and the unit is seconds.
     */
    @JvmName("ajgcxiiphnirjuqr")
    public suspend fun checkpoint(`value`: Output<String>) {
        this.checkpoint = value
    }

    /**
     * @param value The data verification task of the migration or synchronization instance, in the format of a JSON string, such as parameter limits or alarm configurations. For more information, see the DataCheckConfigure parameter description [datacheckconfigure-parameter](https://help.aliyun.com/zh/dts/developer-reference/datacheckconfigure-parameter).
     */
    @JvmName("eeuxvlahnnpuohdy")
    public suspend fun dataCheckConfigure(`value`: Output<String>) {
        this.dataCheckConfigure = value
    }

    /**
     * @param value Whether to perform full data migration or full data initialization. Valid values: `true`, `false`.
     */
    @JvmName("xbfqvwpsqwxxwfvx")
    public suspend fun dataInitialization(`value`: Output<Boolean>) {
        this.dataInitialization = value
    }

    /**
     * @param value Whether to perform incremental data migration or synchronization. Valid values: `true`, `false`.
     */
    @JvmName("stdoydnwjknwxiwf")
    public suspend fun dataSynchronization(`value`: Output<Boolean>) {
        this.dataSynchronization = value
    }

    /**
     * @param value Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html). **NOTE:** From version 1.173.0, `db_list` can be modified.
     */
    @JvmName("tlrkdsqcauvxlwqo")
    public suspend fun dbList(`value`: Output<String>) {
        this.dbList = value
    }

    /**
     * @param value When the ID of the dedicated cluster is input, the task is scheduled to the corresponding cluster.
     */
    @JvmName("apjqagrtkmgjqmca")
    public suspend fun dedicatedClusterId(`value`: Output<String>) {
        this.dedicatedClusterId = value
    }

    /**
     * @param value The delay notice. Valid values: `true`, `false`.
     */
    @JvmName("unlnxbkcxmtqfvhu")
    public suspend fun delayNotice(`value`: Output<Boolean>) {
        this.delayNotice = value
    }

    /**
     * @param value The delay phone. The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
     */
    @JvmName("yuuukgfpgapfkgev")
    public suspend fun delayPhone(`value`: Output<String>) {
        this.delayPhone = value
    }

    /**
     * @param value The delay rule time. When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
     */
    @JvmName("ssyojjrwyvyguaqg")
    public suspend fun delayRuleTime(`value`: Output<String>) {
        this.delayRuleTime = value
    }

    /**
     * @param value The name of the database to which the migration object belongs in the target instance. Note: when the target instance or target database type is PolarDB O engine, AnalyticDB PostgreSQL, PostgreSQL, MongoDB database, this parameter is available and must be passed in.
     */
    @JvmName("pipijhfwbaejhxvo")
    public suspend fun destinationEndpointDatabaseName(`value`: Output<String>) {
        this.destinationEndpointDatabaseName = value
    }

    /**
     * @param value The type of destination database. The default value is MYSQL. For the correspondence between supported target libraries and source libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the target instance is KAFKA or MONGODB, you also need to pass in some information in the reserved parameter `reserve`. For the configuration method, see the description of `reserve` parameters. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
     */
    @JvmName("uxiqlrmfphbqtnel")
    public suspend fun destinationEndpointEngineName(`value`: Output<String>) {
        this.destinationEndpointEngineName = value
    }

    /**
     * @param value The ID of destination instance. If the target instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the target instance is a self-built database, the value of this parameter changes according to the value of `destination_endpoint_instance_type`. For example, the value of `destination_endpoint_instance_type` is:
     * ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
     * ** `DG`, then this parameter needs to be passed into the ID of database gateway.
     * ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
     */
    @JvmName("evhocabtislbncbc")
    public suspend fun destinationEndpointInstanceId(`value`: Output<String>) {
        this.destinationEndpointInstanceId = value
    }

    /**
     * @param value The type of destination instance. If the target instance is a PolarDB O engine cluster, the target instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. If the target instance is the Kafka version of Message Queuing, the target instance type needs to be `ECS` or `EXPRESS` as a self-built database, and access via ECS or dedicated line. For the correspondence between supported targets and source instances, see [Supported Databases](https://help&#46;aliyun&#46;com/document_detail/131497&#46;htm)&#46; When the target instance is a self-built database, you also need to perform corresponding preparations, please refer to the [overview of preparations](https://help.aliyun.com/document_detail/146958.htm). Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
     */
    @JvmName("fbnywmjjirmgjkni")
    public suspend fun destinationEndpointInstanceType(`value`: Output<String>) {
        this.destinationEndpointInstanceType = value
    }

    /**
     * @param value The IP of source endpoint. When `destination_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
     */
    @JvmName("mhpaulhkgsmoltxf")
    public suspend fun destinationEndpointIp(`value`: Output<String>) {
        this.destinationEndpointIp = value
    }

    /**
     * @param value The SID of Oracle database. Note: when the value of DestinationEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
     */
    @JvmName("adaigusmofaayqom")
    public suspend fun destinationEndpointOracleSid(`value`: Output<String>) {
        this.destinationEndpointOracleSid = value
    }

    /**
     * @param value The ID of the Alibaba Cloud account to which the target RDS MySQL instance belongs. can be configured only when the target instance is RDS MySQL. This parameter is used to migrate or synchronize data across Alibaba Cloud accounts. You also need to enter the **destinationendpointrle** parameter.
     */
    @JvmName("hpjseadaoqwjluyp")
    public suspend fun destinationEndpointOwnerId(`value`: Output<String>) {
        this.destinationEndpointOwnerId = value
    }

    /**
     * @param value The password of database account.
     */
    @JvmName("iyrctytdcyfjemtx")
    public suspend fun destinationEndpointPassword(`value`: Output<String>) {
        this.destinationEndpointPassword = value
    }

    /**
     * @param value The port of source endpoint. When the target instance is a self-built database, this parameter is available and must be passed in.
     */
    @JvmName("ujeeeqgncugitmid")
    public suspend fun destinationEndpointPort(`value`: Output<String>) {
        this.destinationEndpointPort = value
    }

    /**
     * @param value The region of destination instance. For the target instance region, please refer to the [list of supported regions](https://help.aliyun.com/document_detail/141033.htm). Note: if the target is an Alibaba Cloud database, this parameter must be passed in.
     */
    @JvmName("xmvkiecxqhbgifiq")
    public suspend fun destinationEndpointRegion(`value`: Output<String>) {
        this.destinationEndpointRegion = value
    }

    /**
     * @param value The role name of the Alibaba Cloud account to which the target instance belongs. This parameter must be entered when data migration or synchronization across Alibaba Cloud accounts is performed. For the permissions and authorization methods required by this role.
     */
    @JvmName("dskkqgypkuskdoaj")
    public suspend fun destinationEndpointRole(`value`: Output<String>) {
        this.destinationEndpointRole = value
    }

    /**
     * @param value The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help&#46;aliyun&#46;com/document_detail/175878&#46;htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
     */
    @JvmName("syydaegdaeocsqps")
    public suspend fun destinationEndpointUserName(`value`: Output<String>) {
        this.destinationEndpointUserName = value
    }

    /**
     * @param value The environment label of the DTS instance. The value is: **normal**, **online**.
     * > **NOTE:** From the status of `NotStarted` to `Synchronizing`, the resource goes through the `Prechecking` and `Initializing` phases. Because of the `Initializing` phase takes too long, and once the resource passes to the status of `Prechecking`, it can be considered that the task can be executed normally. Therefore, we treat the status of `Initializing` as an equivalent to `Synchronizing`.
     * > **NOTE:** If you want to upgrade the synchronization job specifications by the property `instance_class`, you must also modify the property `instance_class` of it's instance to keep them consistent.
     */
    @JvmName("qsmdvwclchnntwag")
    public suspend fun dtsBisLabel(`value`: Output<String>) {
        this.dtsBisLabel = value
    }

    /**
     * @param value The ID of synchronization instance, it must be an ID of `alicloud.dts.SynchronizationInstance`.
     */
    @JvmName("ebijptitbivrellu")
    public suspend fun dtsInstanceId(`value`: Output<String>) {
        this.dtsInstanceId = value
    }

    /**
     * @param value The name of synchronization job.
     */
    @JvmName("awmpcswmqljhbhjy")
    public suspend fun dtsJobName(`value`: Output<String>) {
        this.dtsJobName = value
    }

    /**
     * @param value The error notice. Valid values: `true`, `false`.
     */
    @JvmName("uxqhjgjrgktlnuxb")
    public suspend fun errorNotice(`value`: Output<Boolean>) {
        this.errorNotice = value
    }

    /**
     * @param value The error phone. The mobile phone number of the contact who error the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
     */
    @JvmName("jiiqwpkmxiiguapi")
    public suspend fun errorPhone(`value`: Output<String>) {
        this.errorPhone = value
    }

    /**
     * @param value The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
     */
    @JvmName("kivmwlyjhcdwbxla")
    public suspend fun instanceClass(`value`: Output<String>) {
        this.instanceClass = value
    }

    /**
     * @param value DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter [description of the Reserve parameter](https://help.aliyun.com/document_detail/273111.html).
     */
    @JvmName("hdqkbwavulsirrmm")
    public suspend fun reserve(`value`: Output<String>) {
        this.reserve = value
    }

    /**
     * @param value The name of the database to which the migration object belongs in the source instance. Note: this parameter is only available and must be passed in when the source instance, or the database type of the source instance is PolarDB O engine, PostgreSQL, or MongoDB database.
     */
    @JvmName("hutmaokxshpegsei")
    public suspend fun sourceEndpointDatabaseName(`value`: Output<String>) {
        this.sourceEndpointDatabaseName = value
    }

    /**
     * @param value The type of source database. The default value is `MySQL`. For the correspondence between supported source libraries and target libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the source instance is `MONGODB`, you also need to pass in some information in the reserved parameter `Reserve`, for the configuration method, see the description of Reserve parameters. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
     */
    @JvmName("ycluiurfbxfusuqu")
    public suspend fun sourceEndpointEngineName(`value`: Output<String>) {
        this.sourceEndpointEngineName = value
    }

    /**
     * @param value The ID of source instance. If the source instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the source instance is a self-built database, the value of this parameter changes according to the value of `source_endpoint_instance_type`. For example, the value of `source_endpoint_instance_type` is:
     * ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
     * ** `DG`, then this parameter needs to be passed into the ID of database gateway.
     * ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
     */
    @JvmName("ebiorttoivclbnbu")
    public suspend fun sourceEndpointInstanceId(`value`: Output<String>) {
        this.sourceEndpointInstanceId = value
    }

    /**
     * @param value The type of source instance. If the source instance is a `PolarDB O` engine cluster, the source instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. For the correspondence between supported source and target instances, see [Supported Databases](https://help&#46;aliyun&#46;com/document_detail/131497&#46;htm)&#46; When the source instance is a self-built database, you also need to perform corresponding preparations, for details, see [Preparations Overview](https://help.aliyun.com/document_detail/146958.htm). Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
     */
    @JvmName("ejncuqppyfgjbuhr")
    public suspend fun sourceEndpointInstanceType(`value`: Output<String>) {
        this.sourceEndpointInstanceType = value
    }

    /**
     * @param value The IP of source endpoint. When `source_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
     */
    @JvmName("dgiunxsohobaohfc")
    public suspend fun sourceEndpointIp(`value`: Output<String>) {
        this.sourceEndpointIp = value
    }

    /**
     * @param value The SID of Oracle database. When the value of SourceEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
     */
    @JvmName("yexuracrllvbqheq")
    public suspend fun sourceEndpointOracleSid(`value`: Output<String>) {
        this.sourceEndpointOracleSid = value
    }

    /**
     * @param value The ID of Alibaba Cloud account to which the source instance belongs. Note: passing in this parameter means performing data migration or synchronization across Alibaba Cloud accounts, and you also need to pass in the `source_endpoint_role` parameter.
     */
    @JvmName("kxxhrjdmyrkkxtov")
    public suspend fun sourceEndpointOwnerId(`value`: Output<String>) {
        this.sourceEndpointOwnerId = value
    }

    /**
     * @param value The password of database account.
     */
    @JvmName("nqfuxecpkscmjcxk")
    public suspend fun sourceEndpointPassword(`value`: Output<String>) {
        this.sourceEndpointPassword = value
    }

    /**
     * @param value The port of source endpoint. When the source instance is a self-built database, this parameter is available and must be passed in.
     */
    @JvmName("tkcfekmrvkanewup")
    public suspend fun sourceEndpointPort(`value`: Output<String>) {
        this.sourceEndpointPort = value
    }

    /**
     * @param value Source instance area, please refer to the [list of supported areas](https://help.aliyun.com/document_detail/141033.htm) for details. Note if the source is an Alibaba Cloud database, this parameter must be passed in.
     */
    @JvmName("qhvtepwnsfjydwpd")
    public suspend fun sourceEndpointRegion(`value`: Output<String>) {
        this.sourceEndpointRegion = value
    }

    /**
     * @param value The name of the role configured for the cloud account to which the source instance belongs. Note: this parameter must be passed in when performing cross Alibaba Cloud account data migration or synchronization. For the permissions and authorization methods required by this role, please refer to [How to configure RAM authorization when cross-Alibaba Cloud account data migration or synchronization](https://help.aliyun.com/document_detail/48468.htm).
     */
    @JvmName("cwjaqekjkerhkauw")
    public suspend fun sourceEndpointRole(`value`: Output<String>) {
        this.sourceEndpointRole = value
    }

    /**
     * @param value The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help&#46;aliyun&#46;com/document_detail/175878&#46;htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
     */
    @JvmName("jlkujovsdsrqhknu")
    public suspend fun sourceEndpointUserName(`value`: Output<String>) {
        this.sourceEndpointUserName = value
    }

    /**
     * @param value Data Delivery link switch instance id
     */
    @JvmName("rhgttpyjdpdvrkeg")
    public suspend fun sourceEndpointVswitchId(`value`: Output<String>) {
        this.sourceEndpointVswitchId = value
    }

    /**
     * @param value The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
     */
    @JvmName("xnlullhfsxckpgos")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Whether to perform library table structure migration or initialization. Valid values: `true`, `false`.
     */
    @JvmName("skgruyxnadpxrlav")
    public suspend fun structureInitialization(`value`: Output<Boolean>) {
        this.structureInitialization = value
    }

    /**
     * @param value Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `alicloud.dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
     */
    @JvmName("qqumicwvmxnjuqej")
    public suspend fun synchronizationDirection(`value`: Output<String>) {
        this.synchronizationDirection = value
    }

    /**
     * @param value The start point or synchronization point of incremental data migration, the format is Unix timestamp, and the unit is seconds.
     */
    @JvmName("ijlummigmsmjvpxu")
    public suspend fun checkpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpoint = mapped
    }

    /**
     * @param value The data verification task of the migration or synchronization instance, in the format of a JSON string, such as parameter limits or alarm configurations. For more information, see the DataCheckConfigure parameter description [datacheckconfigure-parameter](https://help.aliyun.com/zh/dts/developer-reference/datacheckconfigure-parameter).
     */
    @JvmName("slixvwmnhvjpvmtn")
    public suspend fun dataCheckConfigure(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCheckConfigure = mapped
    }

    /**
     * @param value Whether to perform full data migration or full data initialization. Valid values: `true`, `false`.
     */
    @JvmName("medpmowqstxmsliw")
    public suspend fun dataInitialization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataInitialization = mapped
    }

    /**
     * @param value Whether to perform incremental data migration or synchronization. Valid values: `true`, `false`.
     */
    @JvmName("fjbbjxebdgpjaryo")
    public suspend fun dataSynchronization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSynchronization = mapped
    }

    /**
     * @param value Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html). **NOTE:** From version 1.173.0, `db_list` can be modified.
     */
    @JvmName("ilqqreaidsmrgbnp")
    public suspend fun dbList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbList = mapped
    }

    /**
     * @param value When the ID of the dedicated cluster is input, the task is scheduled to the corresponding cluster.
     */
    @JvmName("hwnliuohdcasnids")
    public suspend fun dedicatedClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedClusterId = mapped
    }

    /**
     * @param value The delay notice. Valid values: `true`, `false`.
     */
    @JvmName("qcompdmfmftuxeec")
    public suspend fun delayNotice(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delayNotice = mapped
    }

    /**
     * @param value The delay phone. The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
     */
    @JvmName("wsyemhevrosqsjle")
    public suspend fun delayPhone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delayPhone = mapped
    }

    /**
     * @param value The delay rule time. When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
     */
    @JvmName("jthagdmbbbsrkgoo")
    public suspend fun delayRuleTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delayRuleTime = mapped
    }

    /**
     * @param value The name of the database to which the migration object belongs in the target instance. Note: when the target instance or target database type is PolarDB O engine, AnalyticDB PostgreSQL, PostgreSQL, MongoDB database, this parameter is available and must be passed in.
     */
    @JvmName("hutkibkgfwftipob")
    public suspend fun destinationEndpointDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointDatabaseName = mapped
    }

    /**
     * @param value The type of destination database. The default value is MYSQL. For the correspondence between supported target libraries and source libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the target instance is KAFKA or MONGODB, you also need to pass in some information in the reserved parameter `reserve`. For the configuration method, see the description of `reserve` parameters. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
     */
    @JvmName("peqophwadhthsyoi")
    public suspend fun destinationEndpointEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointEngineName = mapped
    }

    /**
     * @param value The ID of destination instance. If the target instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the target instance is a self-built database, the value of this parameter changes according to the value of `destination_endpoint_instance_type`. For example, the value of `destination_endpoint_instance_type` is:
     * ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
     * ** `DG`, then this parameter needs to be passed into the ID of database gateway.
     * ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
     */
    @JvmName("rgscabhgivskfohq")
    public suspend fun destinationEndpointInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointInstanceId = mapped
    }

    /**
     * @param value The type of destination instance. If the target instance is a PolarDB O engine cluster, the target instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. If the target instance is the Kafka version of Message Queuing, the target instance type needs to be `ECS` or `EXPRESS` as a self-built database, and access via ECS or dedicated line. For the correspondence between supported targets and source instances, see [Supported Databases](https://help&#46;aliyun&#46;com/document_detail/131497&#46;htm)&#46; When the target instance is a self-built database, you also need to perform corresponding preparations, please refer to the [overview of preparations](https://help.aliyun.com/document_detail/146958.htm). Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
     */
    @JvmName("kwjfbpxlxlupgksv")
    public suspend fun destinationEndpointInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointInstanceType = mapped
    }

    /**
     * @param value The IP of source endpoint. When `destination_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
     */
    @JvmName("yemorqxpwffaepli")
    public suspend fun destinationEndpointIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointIp = mapped
    }

    /**
     * @param value The SID of Oracle database. Note: when the value of DestinationEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
     */
    @JvmName("wgdnrhmvttrgxofd")
    public suspend fun destinationEndpointOracleSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointOracleSid = mapped
    }

    /**
     * @param value The ID of the Alibaba Cloud account to which the target RDS MySQL instance belongs. can be configured only when the target instance is RDS MySQL. This parameter is used to migrate or synchronize data across Alibaba Cloud accounts. You also need to enter the **destinationendpointrle** parameter.
     */
    @JvmName("kruvxhuorliyosfd")
    public suspend fun destinationEndpointOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointOwnerId = mapped
    }

    /**
     * @param value The password of database account.
     */
    @JvmName("owopcwuwaampughp")
    public suspend fun destinationEndpointPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointPassword = mapped
    }

    /**
     * @param value The port of source endpoint. When the target instance is a self-built database, this parameter is available and must be passed in.
     */
    @JvmName("ldtpolnvgscpcvtw")
    public suspend fun destinationEndpointPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointPort = mapped
    }

    /**
     * @param value The region of destination instance. For the target instance region, please refer to the [list of supported regions](https://help.aliyun.com/document_detail/141033.htm). Note: if the target is an Alibaba Cloud database, this parameter must be passed in.
     */
    @JvmName("bhghjyielmmqmmip")
    public suspend fun destinationEndpointRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointRegion = mapped
    }

    /**
     * @param value The role name of the Alibaba Cloud account to which the target instance belongs. This parameter must be entered when data migration or synchronization across Alibaba Cloud accounts is performed. For the permissions and authorization methods required by this role.
     */
    @JvmName("ydrmoqmrsdepqfjv")
    public suspend fun destinationEndpointRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointRole = mapped
    }

    /**
     * @param value The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help&#46;aliyun&#46;com/document_detail/175878&#46;htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
     */
    @JvmName("oafyaretklfyqyvg")
    public suspend fun destinationEndpointUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationEndpointUserName = mapped
    }

    /**
     * @param value The environment label of the DTS instance. The value is: **normal**, **online**.
     * > **NOTE:** From the status of `NotStarted` to `Synchronizing`, the resource goes through the `Prechecking` and `Initializing` phases. Because of the `Initializing` phase takes too long, and once the resource passes to the status of `Prechecking`, it can be considered that the task can be executed normally. Therefore, we treat the status of `Initializing` as an equivalent to `Synchronizing`.
     * > **NOTE:** If you want to upgrade the synchronization job specifications by the property `instance_class`, you must also modify the property `instance_class` of it's instance to keep them consistent.
     */
    @JvmName("tsxxippevpoqdtcx")
    public suspend fun dtsBisLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dtsBisLabel = mapped
    }

    /**
     * @param value The ID of synchronization instance, it must be an ID of `alicloud.dts.SynchronizationInstance`.
     */
    @JvmName("ugsxqpnawevscxrd")
    public suspend fun dtsInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dtsInstanceId = mapped
    }

    /**
     * @param value The name of synchronization job.
     */
    @JvmName("tjjadqlvtorhgjxu")
    public suspend fun dtsJobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dtsJobName = mapped
    }

    /**
     * @param value The error notice. Valid values: `true`, `false`.
     */
    @JvmName("fxtyxuifmqfivbnn")
    public suspend fun errorNotice(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorNotice = mapped
    }

    /**
     * @param value The error phone. The mobile phone number of the contact who error the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
     */
    @JvmName("nxjnjvoriclplhst")
    public suspend fun errorPhone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorPhone = mapped
    }

    /**
     * @param value The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`. You can only upgrade the configuration, not downgrade the configuration. If you downgrade the instance, you need to [submit a ticket](https://selfservice.console.aliyun.com/ticket/category/dts/today).
     */
    @JvmName("ohtsdksdfqkomqtv")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceClass = mapped
    }

    /**
     * @param value DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter [description of the Reserve parameter](https://help.aliyun.com/document_detail/273111.html).
     */
    @JvmName("upignrcfnakcmhtp")
    public suspend fun reserve(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reserve = mapped
    }

    /**
     * @param value The name of the database to which the migration object belongs in the source instance. Note: this parameter is only available and must be passed in when the source instance, or the database type of the source instance is PolarDB O engine, PostgreSQL, or MongoDB database.
     */
    @JvmName("iqukxguewmhbtxum")
    public suspend fun sourceEndpointDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointDatabaseName = mapped
    }

    /**
     * @param value The type of source database. The default value is `MySQL`. For the correspondence between supported source libraries and target libraries, see [Supported Databases](https://help.aliyun.com/document_detail/131497.htm). When the database type of the source instance is `MONGODB`, you also need to pass in some information in the reserved parameter `Reserve`, for the configuration method, see the description of Reserve parameters. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
     */
    @JvmName("rgkcpjuolangvbxp")
    public suspend fun sourceEndpointEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointEngineName = mapped
    }

    /**
     * @param value The ID of source instance. If the source instance is a cloud database (such as RDS MySQL), you need to pass in the instance ID of the cloud database (such as the instance ID of RDS MySQL). If the source instance is a self-built database, the value of this parameter changes according to the value of `source_endpoint_instance_type`. For example, the value of `source_endpoint_instance_type` is:
     * ** `ECS`, then this parameter needs to be passed into the instance ID of ECS.
     * ** `DG`, then this parameter needs to be passed into the ID of database gateway.
     * ** `EXPRESS`, `CEN`, then this parameter needs to be passed in the ID of VPC that has been interconnected with the source database. **Note**: when the value is `CEN`, you also need to pass in the ID of CEN instance in the cloud enterprise network with the reserved parameter `reserve`.
     */
    @JvmName("hyxwrfllpeldbqpg")
    public suspend fun sourceEndpointInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointInstanceId = mapped
    }

    /**
     * @param value The type of source instance. If the source instance is a `PolarDB O` engine cluster, the source instance type needs to be `OTHER` or `EXPRESS` as a self-built database, and access via public IP or dedicated line. For the correspondence between supported source and target instances, see [Supported Databases](https://help&#46;aliyun&#46;com/document_detail/131497&#46;htm)&#46; When the source instance is a self-built database, you also need to perform corresponding preparations, for details, see [Preparations Overview](https://help.aliyun.com/document_detail/146958.htm). Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
     */
    @JvmName("lgnniulxffkdsvua")
    public suspend fun sourceEndpointInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointInstanceType = mapped
    }

    /**
     * @param value The IP of source endpoint. When `source_endpoint_instance_type` is `OTHER`, `EXPRESS`, `DG`, `CEN`, this parameter is available and must be passed in.
     */
    @JvmName("iahhpnqlqnlgnlwm")
    public suspend fun sourceEndpointIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointIp = mapped
    }

    /**
     * @param value The SID of Oracle database. When the value of SourceEndpointEngineName is Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
     */
    @JvmName("xqhegymfjhgglkgs")
    public suspend fun sourceEndpointOracleSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointOracleSid = mapped
    }

    /**
     * @param value The ID of Alibaba Cloud account to which the source instance belongs. Note: passing in this parameter means performing data migration or synchronization across Alibaba Cloud accounts, and you also need to pass in the `source_endpoint_role` parameter.
     */
    @JvmName("lbwmmpexfvfrnjjm")
    public suspend fun sourceEndpointOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointOwnerId = mapped
    }

    /**
     * @param value The password of database account.
     */
    @JvmName("omcnhtbymgdtslld")
    public suspend fun sourceEndpointPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointPassword = mapped
    }

    /**
     * @param value The port of source endpoint. When the source instance is a self-built database, this parameter is available and must be passed in.
     */
    @JvmName("cucolafepqayjuqo")
    public suspend fun sourceEndpointPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointPort = mapped
    }

    /**
     * @param value Source instance area, please refer to the [list of supported areas](https://help.aliyun.com/document_detail/141033.htm) for details. Note if the source is an Alibaba Cloud database, this parameter must be passed in.
     */
    @JvmName("bgfgbpbccrpwdpho")
    public suspend fun sourceEndpointRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointRegion = mapped
    }

    /**
     * @param value The name of the role configured for the cloud account to which the source instance belongs. Note: this parameter must be passed in when performing cross Alibaba Cloud account data migration or synchronization. For the permissions and authorization methods required by this role, please refer to [How to configure RAM authorization when cross-Alibaba Cloud account data migration or synchronization](https://help.aliyun.com/document_detail/48468.htm).
     */
    @JvmName("doiqjnuffurvopwu")
    public suspend fun sourceEndpointRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointRole = mapped
    }

    /**
     * @param value The username of database account. Note: in most cases, you need to pass in the database account of the source library. The permissions required for migrating or synchronizing different databases are different. For specific permission requirements, see [Preparing database accounts for data migration](https://help&#46;aliyun&#46;com/document_detail/175878&#46;htm) and [Preparing database accounts for data synchronization](https://help.aliyun.com/document_detail/213152.htm).
     */
    @JvmName("hhaetyfowsehtgxv")
    public suspend fun sourceEndpointUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointUserName = mapped
    }

    /**
     * @param value Data Delivery link switch instance id
     */
    @JvmName("rhastsgtdmbvyibm")
    public suspend fun sourceEndpointVswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointVswitchId = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
     */
    @JvmName("ipnotrfqxrtnrbdr")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Whether to perform library table structure migration or initialization. Valid values: `true`, `false`.
     */
    @JvmName("kaeenuomwuwhkewb")
    public suspend fun structureInitialization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.structureInitialization = mapped
    }

    /**
     * @param value Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `alicloud.dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
     */
    @JvmName("ayylkexkfkunhhai")
    public suspend fun synchronizationDirection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synchronizationDirection = mapped
    }

    internal fun build(): SynchronizationJobArgs = SynchronizationJobArgs(
        checkpoint = checkpoint,
        dataCheckConfigure = dataCheckConfigure,
        dataInitialization = dataInitialization,
        dataSynchronization = dataSynchronization,
        dbList = dbList,
        dedicatedClusterId = dedicatedClusterId,
        delayNotice = delayNotice,
        delayPhone = delayPhone,
        delayRuleTime = delayRuleTime,
        destinationEndpointDatabaseName = destinationEndpointDatabaseName,
        destinationEndpointEngineName = destinationEndpointEngineName,
        destinationEndpointInstanceId = destinationEndpointInstanceId,
        destinationEndpointInstanceType = destinationEndpointInstanceType,
        destinationEndpointIp = destinationEndpointIp,
        destinationEndpointOracleSid = destinationEndpointOracleSid,
        destinationEndpointOwnerId = destinationEndpointOwnerId,
        destinationEndpointPassword = destinationEndpointPassword,
        destinationEndpointPort = destinationEndpointPort,
        destinationEndpointRegion = destinationEndpointRegion,
        destinationEndpointRole = destinationEndpointRole,
        destinationEndpointUserName = destinationEndpointUserName,
        dtsBisLabel = dtsBisLabel,
        dtsInstanceId = dtsInstanceId,
        dtsJobName = dtsJobName,
        errorNotice = errorNotice,
        errorPhone = errorPhone,
        instanceClass = instanceClass,
        reserve = reserve,
        sourceEndpointDatabaseName = sourceEndpointDatabaseName,
        sourceEndpointEngineName = sourceEndpointEngineName,
        sourceEndpointInstanceId = sourceEndpointInstanceId,
        sourceEndpointInstanceType = sourceEndpointInstanceType,
        sourceEndpointIp = sourceEndpointIp,
        sourceEndpointOracleSid = sourceEndpointOracleSid,
        sourceEndpointOwnerId = sourceEndpointOwnerId,
        sourceEndpointPassword = sourceEndpointPassword,
        sourceEndpointPort = sourceEndpointPort,
        sourceEndpointRegion = sourceEndpointRegion,
        sourceEndpointRole = sourceEndpointRole,
        sourceEndpointUserName = sourceEndpointUserName,
        sourceEndpointVswitchId = sourceEndpointVswitchId,
        status = status,
        structureInitialization = structureInitialization,
        synchronizationDirection = synchronizationDirection,
    )
}
