@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin.inputs

import com.pulumi.alicloud.dts.inputs.GetConsumerChannelsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConsumerChannels.
 * @property dtsInstanceId Subscription instance ID.
 * @property ids A list of Consumer Channel IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetConsumerChannelsPlainArgs(
    public val dtsInstanceId: String,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dts.inputs.GetConsumerChannelsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dts.inputs.GetConsumerChannelsPlainArgs =
        com.pulumi.alicloud.dts.inputs.GetConsumerChannelsPlainArgs.builder()
            .dtsInstanceId(dtsInstanceId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConsumerChannelsPlainArgs].
 */
@PulumiTagMarker
public class GetConsumerChannelsPlainArgsBuilder internal constructor() {
    private var dtsInstanceId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value Subscription instance ID.
     */
    @JvmName("qvxoewnlgbgjoxhs")
    public suspend fun dtsInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dtsInstanceId = mapped
    }

    /**
     * @param value A list of Consumer Channel IDs.
     */
    @JvmName("afwtwheqbqlwdvyr")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Consumer Channel IDs.
     */
    @JvmName("joqdsnyhaimaofyd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xlookfiapngspojn")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetConsumerChannelsPlainArgs = GetConsumerChannelsPlainArgs(
        dtsInstanceId = dtsInstanceId ?: throw PulumiNullFieldException("dtsInstanceId"),
        ids = ids,
        outputFile = outputFile,
    )
}
