@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin.inputs

import com.pulumi.alicloud.dts.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property ids A list of Instance IDs.
 * @property nameRegex A regex string to filter results by trail name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId Resource Group ID
 */
public data class GetInstancesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dts.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dts.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.dts.inputs.GetInstancesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var resourceGroupId: String? = null

    /**
     * @param value A list of Instance IDs.
     */
    @JvmName("qeykjltughdvqxsy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Instance IDs.
     */
    @JvmName("cxguyairksjixntn")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by trail name.
     */
    @JvmName("brucxdotxuepmndc")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("chkuckioeiyjtjkx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("pprwxotsudcimuqs")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("jxyjxgqrawyjbheo")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value Resource Group ID
     */
    @JvmName("vmyqmkbktwcseixk")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        resourceGroupId = resourceGroupId,
    )
}
