@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property consumerGroupId The ID of the consumer group.
 * @property consumerGroupName The name of the consumer group.
 * @property consumerGroupUserName The username of the consumer group.
 * @property consumptionCheckpoint The time point when the client consumed the last message in the subscription channel.
 * @property id The ID of the Consumer Channel.
 * @property messageDelay The message delay time, for the current time data subscription channel in the earliest time of unconsumed messages of the difference, in Unix timestamp format, which is measured in seconds.
 * @property unconsumedData The total number of unconsumed messages.
 */
public data class GetConsumerChannelsChannel(
    public val consumerGroupId: String,
    public val consumerGroupName: String,
    public val consumerGroupUserName: String,
    public val consumptionCheckpoint: String,
    public val id: String,
    public val messageDelay: Int,
    public val unconsumedData: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dts.outputs.GetConsumerChannelsChannel): GetConsumerChannelsChannel = GetConsumerChannelsChannel(
            consumerGroupId = javaType.consumerGroupId(),
            consumerGroupName = javaType.consumerGroupName(),
            consumerGroupUserName = javaType.consumerGroupUserName(),
            consumptionCheckpoint = javaType.consumptionCheckpoint(),
            id = javaType.id(),
            messageDelay = javaType.messageDelay(),
            unconsumedData = javaType.unconsumedData(),
        )
    }
}
