@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getConsumerChannels.
 * @property channels
 * @property dtsInstanceId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 */
public data class GetConsumerChannelsResult(
    public val channels: List<GetConsumerChannelsChannel>,
    public val dtsInstanceId: String,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dts.outputs.GetConsumerChannelsResult): GetConsumerChannelsResult = GetConsumerChannelsResult(
            channels = javaType.channels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dts.kotlin.outputs.GetConsumerChannelsChannel.Companion.toKotlin(args0)
                })
            }),
            dtsInstanceId = javaType.dtsInstanceId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
