@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property createTime Instance creation time
 * @property destinationEndpointEngineName The target database engine type.
 * @property destinationRegion The destination instance region.
 * @property dtsInstanceId The ID of the subscription instance.
 * @property id The ID of the instance.
 * @property instanceClass The type of the migration or synchronization instance.- The specifications of the migration instance: **xxlarge**, **xlarge**, **large**, **medium**, **small**.- The types of synchronization instances: **large**, **medium**, **small**, **micro**.
 * @property instanceName
 * @property paymentType The payment type of the resource.
 * @property resourceGroupId Resource Group ID
 * @property sourceEndpointEngineName Source instance database engine type.
 * @property sourceRegion The source instance region.
 * @property status Instance status.
 * @property tags The tag value corresponding to the tag key.
 * @property type The instance type. Valid values: -**MIGRATION**: MIGRATION.-**SYNC**: synchronization.-**SUBSCRIBE**: SUBSCRIBE.
 */
public data class GetInstancesInstance(
    public val createTime: String,
    public val destinationEndpointEngineName: String,
    public val destinationRegion: String,
    public val dtsInstanceId: String,
    public val id: String,
    public val instanceClass: String,
    public val instanceName: String,
    public val paymentType: String,
    public val resourceGroupId: String,
    public val sourceEndpointEngineName: String,
    public val sourceRegion: String,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dts.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            createTime = javaType.createTime(),
            destinationEndpointEngineName = javaType.destinationEndpointEngineName(),
            destinationRegion = javaType.destinationRegion(),
            dtsInstanceId = javaType.dtsInstanceId(),
            id = javaType.id(),
            instanceClass = javaType.instanceClass(),
            instanceName = javaType.instanceName(),
            paymentType = javaType.paymentType(),
            resourceGroupId = javaType.resourceGroupId(),
            sourceEndpointEngineName = javaType.sourceEndpointEngineName(),
            sourceRegion = javaType.sourceRegion(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
