@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstances.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Instance IDs.
 * @property instances A list of Instance Entries. Each element contains the following attributes:
 * @property nameRegex
 * @property names A list of Instance names.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId Resource Group ID.
 */
public data class GetInstancesResult(
    public val id: String,
    public val ids: List<String>,
    public val instances: List<GetInstancesInstance>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dts.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dts.kotlin.outputs.GetInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
