@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataInitialization Whether or not to execute DTS supports schema migration, full data migration, or full-data initialization.
 * @property dataSynchronization Whether to perform incremental data migration for migration types or synchronization values include:
 * @property dbList The Migration object, in the format of JSON strings.
 * @property destinationEndpointDataBaseName The name of migrate the database.
 * @property destinationEndpointEngineName The type of destination database.
 * @property destinationEndpointInstanceId The ID of destination instance.
 * @property destinationEndpointInstanceType The type of destination instance.
 * @property destinationEndpointIp The ip of source endpoint.
 * @property destinationEndpointOracleSid The SID of Oracle database.
 * @property destinationEndpointPort The port of source endpoint.
 * @property destinationEndpointRegion The region of destination instance.
 * @property destinationEndpointUserName The username of database account.
 * @property dtsInstanceId The Migration instance ID. The ID of `alicloud.dts.MigrationInstance`.
 * @property dtsJobId The ID of the Migration Job.
 * @property dtsJobName The name of synchronization job.
 * @property id The ID of the Migration Job. Its value is same as `dts_job_id`.
 * @property paymentType The payment type of the Migration Instance.
 * @property sourceEndpointDatabaseName The name of migrate the database.
 * @property sourceEndpointEngineName The type of source database.
 * @property sourceEndpointInstanceId The ID of source instance.
 * @property sourceEndpointInstanceType The type of source instance.
 * @property sourceEndpointIp The ip of source endpoint.
 * @property sourceEndpointOracleSid The SID of Oracle database.
 * @property sourceEndpointOwnerId The Alibaba Cloud account ID to which the source instance belongs.
 * @property sourceEndpointPort The port of source endpoint.
 * @property sourceEndpointRegion The region of source instance.
 * @property sourceEndpointRole The name of the role configured for the cloud account to which the source instance belongs.
 * @property sourceEndpointUserName The username of database account.
 * @property status The status of the resource.
 * @property structureInitialization Whether to perform a database table structure to migrate or initialization.
 */
public data class GetMigrationJobsJob(
    public val dataInitialization: Boolean,
    public val dataSynchronization: Boolean,
    public val dbList: String,
    public val destinationEndpointDataBaseName: String,
    public val destinationEndpointEngineName: String,
    public val destinationEndpointInstanceId: String,
    public val destinationEndpointInstanceType: String,
    public val destinationEndpointIp: String,
    public val destinationEndpointOracleSid: String,
    public val destinationEndpointPort: String,
    public val destinationEndpointRegion: String,
    public val destinationEndpointUserName: String,
    public val dtsInstanceId: String,
    public val dtsJobId: String,
    public val dtsJobName: String,
    public val id: String,
    public val paymentType: String,
    public val sourceEndpointDatabaseName: String,
    public val sourceEndpointEngineName: String,
    public val sourceEndpointInstanceId: String,
    public val sourceEndpointInstanceType: String,
    public val sourceEndpointIp: String,
    public val sourceEndpointOracleSid: String,
    public val sourceEndpointOwnerId: String,
    public val sourceEndpointPort: String,
    public val sourceEndpointRegion: String,
    public val sourceEndpointRole: String,
    public val sourceEndpointUserName: String,
    public val status: String,
    public val structureInitialization: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dts.outputs.GetMigrationJobsJob): GetMigrationJobsJob = GetMigrationJobsJob(
            dataInitialization = javaType.dataInitialization(),
            dataSynchronization = javaType.dataSynchronization(),
            dbList = javaType.dbList(),
            destinationEndpointDataBaseName = javaType.destinationEndpointDataBaseName(),
            destinationEndpointEngineName = javaType.destinationEndpointEngineName(),
            destinationEndpointInstanceId = javaType.destinationEndpointInstanceId(),
            destinationEndpointInstanceType = javaType.destinationEndpointInstanceType(),
            destinationEndpointIp = javaType.destinationEndpointIp(),
            destinationEndpointOracleSid = javaType.destinationEndpointOracleSid(),
            destinationEndpointPort = javaType.destinationEndpointPort(),
            destinationEndpointRegion = javaType.destinationEndpointRegion(),
            destinationEndpointUserName = javaType.destinationEndpointUserName(),
            dtsInstanceId = javaType.dtsInstanceId(),
            dtsJobId = javaType.dtsJobId(),
            dtsJobName = javaType.dtsJobName(),
            id = javaType.id(),
            paymentType = javaType.paymentType(),
            sourceEndpointDatabaseName = javaType.sourceEndpointDatabaseName(),
            sourceEndpointEngineName = javaType.sourceEndpointEngineName(),
            sourceEndpointInstanceId = javaType.sourceEndpointInstanceId(),
            sourceEndpointInstanceType = javaType.sourceEndpointInstanceType(),
            sourceEndpointIp = javaType.sourceEndpointIp(),
            sourceEndpointOracleSid = javaType.sourceEndpointOracleSid(),
            sourceEndpointOwnerId = javaType.sourceEndpointOwnerId(),
            sourceEndpointPort = javaType.sourceEndpointPort(),
            sourceEndpointRegion = javaType.sourceEndpointRegion(),
            sourceEndpointRole = javaType.sourceEndpointRole(),
            sourceEndpointUserName = javaType.sourceEndpointUserName(),
            status = javaType.status(),
            structureInitialization = javaType.structureInitialization(),
        )
    }
}
