@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property checkpoint Subscription start time in Unix timestamp format.
 * @property createTime The creation time of subscription job instance.
 * @property dbList Subscription object, in the format of JSON strings.
 * @property dtsInstanceId The ID of subscription job instance.
 * @property dtsJobId The ID of subscription job instance.
 * @property dtsJobName The name of subscription job instance.
 * @property expireTime The Expiration Time. Formatting with yyyy-MM-ddTHH:mm:ssZ(UTC time).
 * @property id The ID of the Subscription Job.
 * @property paymentType The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
 * @property sourceEndpointDatabaseName To subscribe to the name of the database.
 * @property sourceEndpointEngineName The source database type value is MySQL or Oracle.
 * @property sourceEndpointInstanceId The ID of source instance. Only when the type of source database instance was RDS MySQL, PolarDB-X 1.0, PolarDB MySQL, this parameter can be available and must be set.
 * @property sourceEndpointInstanceType The type of source instance. Valid values: `RDS`, `PolarDB`, `DRDS`, `LocalInstance`, `ECS`, `Express`, `CEN`, `dg`.
 * @property sourceEndpointIp The IP of source endpoint.
 * @property sourceEndpointOracleSid The SID of Oracle Database. When the source database is self-built Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
 * @property sourceEndpointOwnerId The Alibaba Cloud account ID to which the source instance belongs. This parameter is only available when configuring data subscriptions across Alibaba Cloud accounts and must be passed in.
 * @property sourceEndpointPort The  port of source database.
 * @property sourceEndpointRegion The region of source database.
 * @property sourceEndpointRole Both the authorization roles. When the source instance and configure subscriptions task of the Alibaba Cloud account is not the same as the need to pass the parameter, to specify the source of the authorization roles, to allow configuration subscription task of the Alibaba Cloud account to access the source of the source instance information.
 * @property sourceEndpointUserName The username of source database instance account.
 * @property status The status of the task. Valid values: `NotStarted`, `Normal`, `Abnormal`. When a task created, it is in this state of `NotStarted`. You can specify this state of `Normal` to start the job, and specify this state of `Abnormal` to stop the job.
 * @property subscriptionDataTypeDdl Whether to subscribe the DDL type of data. Valid values: `true`, `false`.
 * @property subscriptionDataTypeDml Whether to subscribe the DML type of data. Valid values: `true`, `false`.
 * @property subscriptionHosts Network information.
 * @property subscriptionInstanceNetworkType The type of subscription instance network. Valid value: `classic`, `vpc`.
 * @property subscriptionInstanceVpcId The ID of subscription instance vpc.
 * @property subscriptionInstanceVswitchId The ID of subscription instance vswitch.
 * @property tags The tag of the resource.
 */
public data class GetSubscriptionJobsJob(
    public val checkpoint: String,
    public val createTime: String,
    public val dbList: String,
    public val dtsInstanceId: String,
    public val dtsJobId: String,
    public val dtsJobName: String,
    public val expireTime: String,
    public val id: String,
    public val paymentType: String,
    public val sourceEndpointDatabaseName: String,
    public val sourceEndpointEngineName: String,
    public val sourceEndpointInstanceId: String,
    public val sourceEndpointInstanceType: String,
    public val sourceEndpointIp: String,
    public val sourceEndpointOracleSid: String,
    public val sourceEndpointOwnerId: String,
    public val sourceEndpointPort: String,
    public val sourceEndpointRegion: String,
    public val sourceEndpointRole: String,
    public val sourceEndpointUserName: String,
    public val status: String,
    public val subscriptionDataTypeDdl: Boolean,
    public val subscriptionDataTypeDml: Boolean,
    public val subscriptionHosts: List<GetSubscriptionJobsJobSubscriptionHost>,
    public val subscriptionInstanceNetworkType: String,
    public val subscriptionInstanceVpcId: String,
    public val subscriptionInstanceVswitchId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dts.outputs.GetSubscriptionJobsJob): GetSubscriptionJobsJob = GetSubscriptionJobsJob(
            checkpoint = javaType.checkpoint(),
            createTime = javaType.createTime(),
            dbList = javaType.dbList(),
            dtsInstanceId = javaType.dtsInstanceId(),
            dtsJobId = javaType.dtsJobId(),
            dtsJobName = javaType.dtsJobName(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            paymentType = javaType.paymentType(),
            sourceEndpointDatabaseName = javaType.sourceEndpointDatabaseName(),
            sourceEndpointEngineName = javaType.sourceEndpointEngineName(),
            sourceEndpointInstanceId = javaType.sourceEndpointInstanceId(),
            sourceEndpointInstanceType = javaType.sourceEndpointInstanceType(),
            sourceEndpointIp = javaType.sourceEndpointIp(),
            sourceEndpointOracleSid = javaType.sourceEndpointOracleSid(),
            sourceEndpointOwnerId = javaType.sourceEndpointOwnerId(),
            sourceEndpointPort = javaType.sourceEndpointPort(),
            sourceEndpointRegion = javaType.sourceEndpointRegion(),
            sourceEndpointRole = javaType.sourceEndpointRole(),
            sourceEndpointUserName = javaType.sourceEndpointUserName(),
            status = javaType.status(),
            subscriptionDataTypeDdl = javaType.subscriptionDataTypeDdl(),
            subscriptionDataTypeDml = javaType.subscriptionDataTypeDml(),
            subscriptionHosts = javaType.subscriptionHosts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dts.kotlin.outputs.GetSubscriptionJobsJobSubscriptionHost.Companion.toKotlin(args0)
                })
            }),
            subscriptionInstanceNetworkType = javaType.subscriptionInstanceNetworkType(),
            subscriptionInstanceVpcId = javaType.subscriptionInstanceVpcId(),
            subscriptionInstanceVswitchId = javaType.subscriptionInstanceVswitchId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
