@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property checkpoint Start time in Unix timestamp format.
 * @property createTime
 * @property dataInitialization Whether to execute DTS supports schema migration, full data migration, or full-data initialization.
 * @property dataSynchronization Whether to perform incremental data migration for migration types or synchronization.
 * @property dbList Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, synchronization or subscription objects](https://help.aliyun.com/document_detail/209545.html).
 * @property destinationEndpointDataBaseName The name of migrate the database.
 * @property destinationEndpointEngineName The type of destination database. Valid values: `ADB20`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
 * @property destinationEndpointInstanceId The ID of destination instance.
 * @property destinationEndpointInstanceType The type of destination instance. Valid values: `ads`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
 * @property destinationEndpointIp The ip of source endpoint.
 * @property destinationEndpointOracleSid The SID of Oracle database.
 * @property destinationEndpointPort The port of source endpoint.
 * @property destinationEndpointRegion The region of destination instance.
 * @property destinationEndpointUserName The username of database account.
 * @property dtsInstanceId
 * @property dtsJobId
 * @property dtsJobName The name of synchronization job.
 * @property expireTime
 * @property id The ID of synchronizing instance. It's the ID of resource `alicloud.dts.SynchronizationInstance`.
 * @property sourceEndpointDatabaseName The name of migrate the database.
 * @property sourceEndpointEngineName The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
 * @property sourceEndpointInstanceId The ID of source instance.
 * @property sourceEndpointInstanceType The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
 * @property sourceEndpointIp The ip of source endpoint.
 * @property sourceEndpointOracleSid The SID of Oracle database.
 * @property sourceEndpointOwnerId The Alibaba Cloud account ID to which the source instance belongs.
 * @property sourceEndpointPort The port of source endpoint.
 * @property sourceEndpointRegion The region of source instance.
 * @property sourceEndpointRole The name of the role configured for the cloud account to which the source instance belongs.
 * @property sourceEndpointUserName The username of database account.
 * @property status The status of the resource. Valid values: `Synchronizing`, `Suspending`. You can stop the task by specifying `Suspending` and start the task by specifying `Synchronizing`.
 * @property structureInitialization Whether to perform a database table structure to migrate or initialization values include:
 * @property synchronizationDirection Synchronization direction. Valid values: `Forward`, `Reverse`. Only when the property `sync_architecture` of the `alicloud.dts.SynchronizationInstance` was `bidirectional` this parameter should be passed, otherwise this parameter should not be specified.
 */
public data class GetSynchronizationJobsJob(
    public val checkpoint: String,
    public val createTime: String,
    public val dataInitialization: Boolean,
    public val dataSynchronization: Boolean,
    public val dbList: String,
    public val destinationEndpointDataBaseName: String,
    public val destinationEndpointEngineName: String,
    public val destinationEndpointInstanceId: String,
    public val destinationEndpointInstanceType: String,
    public val destinationEndpointIp: String,
    public val destinationEndpointOracleSid: String,
    public val destinationEndpointPort: String,
    public val destinationEndpointRegion: String,
    public val destinationEndpointUserName: String,
    public val dtsInstanceId: String,
    public val dtsJobId: String,
    public val dtsJobName: String,
    public val expireTime: String,
    public val id: String,
    public val sourceEndpointDatabaseName: String,
    public val sourceEndpointEngineName: String,
    public val sourceEndpointInstanceId: String,
    public val sourceEndpointInstanceType: String,
    public val sourceEndpointIp: String,
    public val sourceEndpointOracleSid: String,
    public val sourceEndpointOwnerId: String,
    public val sourceEndpointPort: String,
    public val sourceEndpointRegion: String,
    public val sourceEndpointRole: String,
    public val sourceEndpointUserName: String,
    public val status: String,
    public val structureInitialization: Boolean,
    public val synchronizationDirection: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dts.outputs.GetSynchronizationJobsJob): GetSynchronizationJobsJob = GetSynchronizationJobsJob(
            checkpoint = javaType.checkpoint(),
            createTime = javaType.createTime(),
            dataInitialization = javaType.dataInitialization(),
            dataSynchronization = javaType.dataSynchronization(),
            dbList = javaType.dbList(),
            destinationEndpointDataBaseName = javaType.destinationEndpointDataBaseName(),
            destinationEndpointEngineName = javaType.destinationEndpointEngineName(),
            destinationEndpointInstanceId = javaType.destinationEndpointInstanceId(),
            destinationEndpointInstanceType = javaType.destinationEndpointInstanceType(),
            destinationEndpointIp = javaType.destinationEndpointIp(),
            destinationEndpointOracleSid = javaType.destinationEndpointOracleSid(),
            destinationEndpointPort = javaType.destinationEndpointPort(),
            destinationEndpointRegion = javaType.destinationEndpointRegion(),
            destinationEndpointUserName = javaType.destinationEndpointUserName(),
            dtsInstanceId = javaType.dtsInstanceId(),
            dtsJobId = javaType.dtsJobId(),
            dtsJobName = javaType.dtsJobName(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            sourceEndpointDatabaseName = javaType.sourceEndpointDatabaseName(),
            sourceEndpointEngineName = javaType.sourceEndpointEngineName(),
            sourceEndpointInstanceId = javaType.sourceEndpointInstanceId(),
            sourceEndpointInstanceType = javaType.sourceEndpointInstanceType(),
            sourceEndpointIp = javaType.sourceEndpointIp(),
            sourceEndpointOracleSid = javaType.sourceEndpointOracleSid(),
            sourceEndpointOwnerId = javaType.sourceEndpointOwnerId(),
            sourceEndpointPort = javaType.sourceEndpointPort(),
            sourceEndpointRegion = javaType.sourceEndpointRegion(),
            sourceEndpointRole = javaType.sourceEndpointRole(),
            sourceEndpointUserName = javaType.sourceEndpointUserName(),
            status = javaType.status(),
            structureInitialization = javaType.structureInitialization(),
            synchronizationDirection = javaType.synchronizationDirection(),
        )
    }
}
