@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dts.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSynchronizationJobs.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property jobs
 * @property nameRegex
 * @property outputFile
 * @property status
 */
public data class GetSynchronizationJobsResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val jobs: List<GetSynchronizationJobsJob>,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dts.outputs.GetSynchronizationJobsResult): GetSynchronizationJobsResult = GetSynchronizationJobsResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            jobs = javaType.jobs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dts.kotlin.outputs.GetSynchronizationJobsJob.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
