@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eais.kotlin

import com.pulumi.alicloud.eais.EaisFunctions.getInstancesPlain
import com.pulumi.alicloud.eais.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.eais.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.eais.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.eais.kotlin.outputs.GetInstancesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object EaisFunctions {
    /**
     * This data source provides the Eais Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.137.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eais.EaisFunctions;
     * import com.pulumi.alicloud.eais.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EaisFunctions.getInstances(GetInstancesArgs.builder()
     *             .id("example_id")
     *             .build());
     *         ctx.export("eaisInstanceId1", ids.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *         final var nameRegex = EaisFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("^my-Instance")
     *             .build());
     *         ctx.export("eaisInstanceId2", nameRegex.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eais:getInstances
     *       Arguments:
     *         id:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:eais:getInstances
     *       Arguments:
     *         nameRegex: ^my-Instance
     * outputs:
     *   eaisInstanceId1: ${ids.instances[0].id}
     *   eaisInstanceId2: ${nameRegex.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        toKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param ids A list of Instance IDs.
     * @param instanceType EAIS instance type. Valid values: `eais.ei-a6.4xlarge`, `eais.ei-a6.2xlarge`, `eais.ei-a6.xlarge`, `eais.ei-a6.large`, `eais.ei-a6.medium`.
     * @param nameRegex A regex string to filter results by Instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `Attaching`, `Available`, `Detaching`, `InUse`, `Starting`, `Unavailable`.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        ids: List<String>? = null,
        instanceType: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            ids = ids,
            instanceType = instanceType,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return toKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eais&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }
}
