@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eais.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clientInstanceId The ID of the ECS instance to be bound.
 * @property clientInstanceName The name of the ECS instance bound to the EAIS instance.
 * @property clientInstanceType The type of the ECS instance bound to the EAIS instance.
 * @property id The ID of the Instance.
 * @property instanceId The ID of the resource.
 * @property instanceName The name of the resource.
 * @property instanceType The type of the resource. Valid values: `eais.ei-a6.4xlarge`, `eais.ei-a6.2xlarge`, `eais.ei-a6.xlarge`, `eais.ei-a6.large`, `eais.ei-a6.medium`.
 * @property status The status of the resource. Valid values: `Attaching`, `Available`, `Detaching`, `InUse`, `Starting`, `Unavailable`.
 * @property zoneId The ID of the region to which the EAIS instance belongs.
 */
public data class GetInstancesInstance(
    public val clientInstanceId: String,
    public val clientInstanceName: String,
    public val clientInstanceType: String,
    public val id: String,
    public val instanceId: String,
    public val instanceName: String,
    public val instanceType: String,
    public val status: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eais.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            clientInstanceId = javaType.clientInstanceId(),
            clientInstanceName = javaType.clientInstanceName(),
            clientInstanceType = javaType.clientInstanceType(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            instanceType = javaType.instanceType(),
            status = javaType.status(),
            zoneId = javaType.zoneId(),
        )
    }
}
