@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DedicatedBlockStorageCluster].
 */
@PulumiTagMarker
public class DedicatedBlockStorageClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DedicatedBlockStorageClusterArgs = DedicatedBlockStorageClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DedicatedBlockStorageClusterArgsBuilder.() -> Unit) {
        val builder = DedicatedBlockStorageClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DedicatedBlockStorageCluster {
        val builtJavaResource =
            com.pulumi.alicloud.ebs.DedicatedBlockStorageCluster(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DedicatedBlockStorageCluster(builtJavaResource)
    }
}

/**
 * Provides a Ebs Dedicated Block Storage Cluster resource.
 * For information about Ebs Dedicated Block Storage Cluster and how to use it, see [What is Dedicated Block Storage Cluster](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-ebs-2021-07-30-creatededicatedblockstoragecluster).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ebs:DedicatedBlockStorageCluster
 *     properties:
 *       type: Premium
 *       zoneId: cn-heyuan-b
 *       dedicatedBlockStorageClusterName: dedicated_block_storage_cluster_name
 *       totalCapacity: 61440
 *       regionId: cn-heyuan
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ebs Dedicated Block Storage Cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ebs/dedicatedBlockStorageCluster:DedicatedBlockStorageCluster example <id>
 * ```
 */
public class DedicatedBlockStorageCluster internal constructor(
    override val javaResource: com.pulumi.alicloud.ebs.DedicatedBlockStorageCluster,
) : KotlinCustomResource(javaResource, DedicatedBlockStorageClusterMapper) {
    /**
     * The available capacity of the dedicated block storage cluster. Unit: GiB.
     */
    public val availableCapacity: Output<String>
        get() = javaResource.availableCapacity().applyValue({ args0 -> args0 })

    /**
     * The type of cloud disk that can be created by a dedicated block storage cluster.
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The first ID of the resource
     */
    public val dedicatedBlockStorageClusterId: Output<String>
        get() = javaResource.dedicatedBlockStorageClusterId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val dedicatedBlockStorageClusterName: Output<String>
        get() = javaResource.dedicatedBlockStorageClusterName().applyValue({ args0 -> args0 })

    /**
     * Capacity to be delivered in GB.
     */
    public val deliveryCapacity: Output<String>
        get() = javaResource.deliveryCapacity().applyValue({ args0 -> args0 })

    /**
     * The description of the dedicated block storage cluster.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The expiration time of the dedicated block storage cluster, in the Unix timestamp format, in seconds.
     */
    public val expiredTime: Output<String>
        get() = javaResource.expiredTime().applyValue({ args0 -> args0 })

    /**
     * Cloud disk performance level, possible values:-PL0.-PL1.-PL2.-PL3.> Only valid in SupportedCategory = cloud_essd.
     */
    public val performanceLevel: Output<String>
        get() = javaResource.performanceLevel().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * This parameter is not supported.
     */
    public val supportedCategory: Output<String>
        get() = javaResource.supportedCategory().applyValue({ args0 -> args0 })

    /**
     * The total capacity of the dedicated block storage cluster. Unit: GiB.
     */
    public val totalCapacity: Output<String>
        get() = javaResource.totalCapacity().applyValue({ args0 -> args0 })

    /**
     * The dedicated block storage cluster performance type. Possible values:-Standard: Basic type. This type of dedicated block storage cluster can create an ESSD PL0 cloud disk.-Premium: performance type. This type of dedicated block storage cluster can create an ESSD PL1 cloud disk.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The used (created disk) capacity of the current cluster, in GB
     */
    public val usedCapacity: Output<String>
        get() = javaResource.usedCapacity().applyValue({ args0 -> args0 })

    /**
     * The zone ID  of the resource
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object DedicatedBlockStorageClusterMapper : ResourceMapper<DedicatedBlockStorageCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ebs.DedicatedBlockStorageCluster::class == javaResource::class

    override fun map(javaResource: Resource): DedicatedBlockStorageCluster =
        DedicatedBlockStorageCluster(
            javaResource as
                com.pulumi.alicloud.ebs.DedicatedBlockStorageCluster,
        )
}

/**
 * @see [DedicatedBlockStorageCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DedicatedBlockStorageCluster].
 */
public suspend fun dedicatedBlockStorageCluster(
    name: String,
    block: suspend DedicatedBlockStorageClusterResourceBuilder.() -> Unit,
): DedicatedBlockStorageCluster {
    val builder = DedicatedBlockStorageClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DedicatedBlockStorageCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dedicatedBlockStorageCluster(name: String): DedicatedBlockStorageCluster {
    val builder = DedicatedBlockStorageClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
