@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin

import com.pulumi.alicloud.ebs.DedicatedBlockStorageClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Ebs Dedicated Block Storage Cluster resource.
 * For information about Ebs Dedicated Block Storage Cluster and how to use it, see [What is Dedicated Block Storage Cluster](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-ebs-2021-07-30-creatededicatedblockstoragecluster).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ebs:DedicatedBlockStorageCluster
 *     properties:
 *       type: Premium
 *       zoneId: cn-heyuan-b
 *       dedicatedBlockStorageClusterName: dedicated_block_storage_cluster_name
 *       totalCapacity: 61440
 *       regionId: cn-heyuan
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ebs Dedicated Block Storage Cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ebs/dedicatedBlockStorageCluster:DedicatedBlockStorageCluster example <id>
 * ```
 * @property dedicatedBlockStorageClusterName The name of the resource
 * @property description The description of the dedicated block storage cluster.
 * @property totalCapacity The total capacity of the dedicated block storage cluster. Unit: GiB.
 * @property type The dedicated block storage cluster performance type. Possible values:-Standard: Basic type. This type of dedicated block storage cluster can create an ESSD PL0 cloud disk.-Premium: performance type. This type of dedicated block storage cluster can create an ESSD PL1 cloud disk.
 * @property zoneId The zone ID  of the resource
 */
public data class DedicatedBlockStorageClusterArgs(
    public val dedicatedBlockStorageClusterName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val totalCapacity: Output<String>? = null,
    public val type: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.DedicatedBlockStorageClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.DedicatedBlockStorageClusterArgs =
        com.pulumi.alicloud.ebs.DedicatedBlockStorageClusterArgs.builder()
            .dedicatedBlockStorageClusterName(dedicatedBlockStorageClusterName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .totalCapacity(totalCapacity?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DedicatedBlockStorageClusterArgs].
 */
@PulumiTagMarker
public class DedicatedBlockStorageClusterArgsBuilder internal constructor() {
    private var dedicatedBlockStorageClusterName: Output<String>? = null

    private var description: Output<String>? = null

    private var totalCapacity: Output<String>? = null

    private var type: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The name of the resource
     */
    @JvmName("igbjxkouveukcpet")
    public suspend fun dedicatedBlockStorageClusterName(`value`: Output<String>) {
        this.dedicatedBlockStorageClusterName = value
    }

    /**
     * @param value The description of the dedicated block storage cluster.
     */
    @JvmName("famgrdxdsmtedtbt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The total capacity of the dedicated block storage cluster. Unit: GiB.
     */
    @JvmName("qmebrfqekfdkcipl")
    public suspend fun totalCapacity(`value`: Output<String>) {
        this.totalCapacity = value
    }

    /**
     * @param value The dedicated block storage cluster performance type. Possible values:-Standard: Basic type. This type of dedicated block storage cluster can create an ESSD PL0 cloud disk.-Premium: performance type. This type of dedicated block storage cluster can create an ESSD PL1 cloud disk.
     */
    @JvmName("jdysbiercuqfqvcr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The zone ID  of the resource
     */
    @JvmName("sndxwplojvcrbfpu")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The name of the resource
     */
    @JvmName("nbhblyuyapwwgsgu")
    public suspend fun dedicatedBlockStorageClusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedBlockStorageClusterName = mapped
    }

    /**
     * @param value The description of the dedicated block storage cluster.
     */
    @JvmName("wppyaaswkvavqcam")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The total capacity of the dedicated block storage cluster. Unit: GiB.
     */
    @JvmName("mpmbmwunsvtbjmif")
    public suspend fun totalCapacity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.totalCapacity = mapped
    }

    /**
     * @param value The dedicated block storage cluster performance type. Possible values:-Standard: Basic type. This type of dedicated block storage cluster can create an ESSD PL0 cloud disk.-Premium: performance type. This type of dedicated block storage cluster can create an ESSD PL1 cloud disk.
     */
    @JvmName("odfrvlytrupgpvbs")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The zone ID  of the resource
     */
    @JvmName("ngvqwkhwcqdadoeo")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): DedicatedBlockStorageClusterArgs = DedicatedBlockStorageClusterArgs(
        dedicatedBlockStorageClusterName = dedicatedBlockStorageClusterName,
        description = description,
        totalCapacity = totalCapacity,
        type = type,
        zoneId = zoneId,
    )
}
