@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DiskReplicaGroup].
 */
@PulumiTagMarker
public class DiskReplicaGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiskReplicaGroupArgs = DiskReplicaGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiskReplicaGroupArgsBuilder.() -> Unit) {
        val builder = DiskReplicaGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DiskReplicaGroup {
        val builtJavaResource = com.pulumi.alicloud.ebs.DiskReplicaGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DiskReplicaGroup(builtJavaResource)
    }
}

/**
 * Provides a EBS Disk Replica Group resource.
 * For information about EBS Disk Replica Group and how to use it, see [What is Disk Replica Group](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/creatediskreplicagroup).
 * > **NOTE:** Available since v1.187.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultGetRegions = _default.then(_default => alicloud.ebs.getRegions({
 *     regionId: _default.regions?.[0]?.id,
 * }));
 * const defaultDiskReplicaGroup = new alicloud.ebs.DiskReplicaGroup("default", {
 *     sourceRegionId: _default.then(_default => _default.regions?.[0]?.id),
 *     sourceZoneId: defaultGetRegions.then(defaultGetRegions => defaultGetRegions.regions?.[0]?&#46;zones?&#46;[0]?.zoneId),
 *     destinationRegionId: _default.then(_default => _default.regions?.[0]?.id),
 *     destinationZoneId: defaultGetRegions.then(defaultGetRegions => defaultGetRegions.regions?.[0]?&#46;zones?&#46;[1]?.zoneId),
 *     groupName: name,
 *     description: name,
 *     rpo: 900,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_regions(current=True)
 * default_get_regions = alicloud.ebs.get_regions(region_id=default.regions[0].id)
 * default_disk_replica_group = alicloud.ebs.DiskReplicaGroup("default",
 *     source_region_id=default.regions[0].id,
 *     source_zone_id=default_get_regions.regions[0]&#46;zones[0].zone_id,
 *     destination_region_id=default.regions[0].id,
 *     destination_zone_id=default_get_regions.regions[0]&#46;zones[1].zone_id,
 *     group_name=name,
 *     description=name,
 *     rpo=900)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultGetRegions = AliCloud.Ebs.GetRegions.Invoke(new()
 *     {
 *         RegionId = @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id),
 *     });
 *     var defaultDiskReplicaGroup = new AliCloud.Ebs.DiskReplicaGroup("default", new()
 *     {
 *         SourceRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         SourceZoneId = defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?&#46;Zones[0]?.ZoneId),
 *         DestinationRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         DestinationZoneId = defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?&#46;Zones[1]?.ZoneId),
 *         GroupName = name,
 *         Description = name,
 *         Rpo = 900,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetRegions, err := ebs.GetRegions(ctx, &ebs.GetRegionsArgs{
 * 			RegionId: pulumi.StringRef(_default.Regions[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ebs.NewDiskReplicaGroup(ctx, "default", &ebs.DiskReplicaGroupArgs{
 * 			SourceRegionId:      pulumi.String(_default.Regions[0].Id),
 * 			SourceZoneId:        pulumi.String(defaultGetRegions.Regions[0]&#46;Zones[0].ZoneId),
 * 			DestinationRegionId: pulumi.String(_default.Regions[0].Id),
 * 			DestinationZoneId:   pulumi.String(defaultGetRegions.Regions[0]&#46;Zones[1].ZoneId),
 * 			GroupName:           pulumi.String(name),
 * 			Description:         pulumi.String(name),
 * 			Rpo:                 pulumi.Int(900),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.ebs.EbsFunctions;
 * import com.pulumi.alicloud.ebs.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.ebs.DiskReplicaGroup;
 * import com.pulumi.alicloud.ebs.DiskReplicaGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         final var defaultGetRegions = EbsFunctions.getRegions(GetRegionsArgs.builder()
 *             .regionId(default_.regions()[0].id())
 *             .build());
 *         var defaultDiskReplicaGroup = new DiskReplicaGroup("defaultDiskReplicaGroup", DiskReplicaGroupArgs.builder()
 *             .sourceRegionId(default_.regions()[0].id())
 *             .sourceZoneId(defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0]&#46;zones()[0].zoneId()))
 *             .destinationRegionId(default_.regions()[0].id())
 *             .destinationZoneId(defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0]&#46;zones()[1].zoneId()))
 *             .groupName(name)
 *             .description(name)
 *             .rpo(900)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultDiskReplicaGroup:
 *     type: alicloud:ebs:DiskReplicaGroup
 *     name: default
 *     properties:
 *       sourceRegionId: ${default.regions[0].id}
 *       sourceZoneId: ${defaultGetRegions.regions[0]&#46;zones[0].zoneId}
 *       destinationRegionId: ${default.regions[0].id}
 *       destinationZoneId: ${defaultGetRegions.regions[0]&#46;zones[1].zoneId}
 *       groupName: ${name}
 *       description: ${name}
 *       rpo: 900
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 *   defaultGetRegions:
 *     fn::invoke:
 *       Function: alicloud:ebs:getRegions
 *       Arguments:
 *         regionId: ${default.regions[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * EBS Disk Replica Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ebs/diskReplicaGroup:DiskReplicaGroup example <id>
 * ```
 */
public class DiskReplicaGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.ebs.DiskReplicaGroup,
) : KotlinCustomResource(javaResource, DiskReplicaGroupMapper) {
    /**
     * The description of the consistent replication group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the region to which the disaster recovery site belongs.
     */
    public val destinationRegionId: Output<String>
        get() = javaResource.destinationRegionId().applyValue({ args0 -> args0 })

    /**
     * The ID of the zone to which the disaster recovery site belongs.
     */
    public val destinationZoneId: Output<String>
        get() = javaResource.destinationZoneId().applyValue({ args0 -> args0 })

    /**
     * Consistent replication group name.
     */
    public val groupName: Output<String>?
        get() = javaResource.groupName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The recovery point objective (RPO) of the replication pair-consistent group. Unit: seconds.
     */
    public val rpo: Output<Int>
        get() = javaResource.rpo().applyValue({ args0 -> args0 })

    /**
     * The ID of the region to which the production site belongs.
     */
    public val sourceRegionId: Output<String>
        get() = javaResource.sourceRegionId().applyValue({ args0 -> args0 })

    /**
     * The ID of the zone to which the production site belongs.
     */
    public val sourceZoneId: Output<String>
        get() = javaResource.sourceZoneId().applyValue({ args0 -> args0 })

    /**
     * The status of the consistent replication group.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object DiskReplicaGroupMapper : ResourceMapper<DiskReplicaGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ebs.DiskReplicaGroup::class == javaResource::class

    override fun map(javaResource: Resource): DiskReplicaGroup = DiskReplicaGroup(
        javaResource as
            com.pulumi.alicloud.ebs.DiskReplicaGroup,
    )
}

/**
 * @see [DiskReplicaGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DiskReplicaGroup].
 */
public suspend fun diskReplicaGroup(
    name: String,
    block: suspend DiskReplicaGroupResourceBuilder.() -> Unit,
): DiskReplicaGroup {
    val builder = DiskReplicaGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DiskReplicaGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun diskReplicaGroup(name: String): DiskReplicaGroup {
    val builder = DiskReplicaGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
