@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin

import com.pulumi.alicloud.ebs.DiskReplicaGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a EBS Disk Replica Group resource.
 * For information about EBS Disk Replica Group and how to use it, see [What is Disk Replica Group](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/creatediskreplicagroup).
 * > **NOTE:** Available since v1.187.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultGetRegions = _default.then(_default => alicloud.ebs.getRegions({
 *     regionId: _default.regions?.[0]?.id,
 * }));
 * const defaultDiskReplicaGroup = new alicloud.ebs.DiskReplicaGroup("default", {
 *     sourceRegionId: _default.then(_default => _default.regions?.[0]?.id),
 *     sourceZoneId: defaultGetRegions.then(defaultGetRegions => defaultGetRegions.regions?.[0]?&#46;zones?&#46;[0]?.zoneId),
 *     destinationRegionId: _default.then(_default => _default.regions?.[0]?.id),
 *     destinationZoneId: defaultGetRegions.then(defaultGetRegions => defaultGetRegions.regions?.[0]?&#46;zones?&#46;[1]?.zoneId),
 *     groupName: name,
 *     description: name,
 *     rpo: 900,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_regions(current=True)
 * default_get_regions = alicloud.ebs.get_regions(region_id=default.regions[0].id)
 * default_disk_replica_group = alicloud.ebs.DiskReplicaGroup("default",
 *     source_region_id=default.regions[0].id,
 *     source_zone_id=default_get_regions.regions[0]&#46;zones[0].zone_id,
 *     destination_region_id=default.regions[0].id,
 *     destination_zone_id=default_get_regions.regions[0]&#46;zones[1].zone_id,
 *     group_name=name,
 *     description=name,
 *     rpo=900)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultGetRegions = AliCloud.Ebs.GetRegions.Invoke(new()
 *     {
 *         RegionId = @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id),
 *     });
 *     var defaultDiskReplicaGroup = new AliCloud.Ebs.DiskReplicaGroup("default", new()
 *     {
 *         SourceRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         SourceZoneId = defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?&#46;Zones[0]?.ZoneId),
 *         DestinationRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         DestinationZoneId = defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?&#46;Zones[1]?.ZoneId),
 *         GroupName = name,
 *         Description = name,
 *         Rpo = 900,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetRegions, err := ebs.GetRegions(ctx, &ebs.GetRegionsArgs{
 * 			RegionId: pulumi.StringRef(_default.Regions[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ebs.NewDiskReplicaGroup(ctx, "default", &ebs.DiskReplicaGroupArgs{
 * 			SourceRegionId:      pulumi.String(_default.Regions[0].Id),
 * 			SourceZoneId:        pulumi.String(defaultGetRegions.Regions[0]&#46;Zones[0].ZoneId),
 * 			DestinationRegionId: pulumi.String(_default.Regions[0].Id),
 * 			DestinationZoneId:   pulumi.String(defaultGetRegions.Regions[0]&#46;Zones[1].ZoneId),
 * 			GroupName:           pulumi.String(name),
 * 			Description:         pulumi.String(name),
 * 			Rpo:                 pulumi.Int(900),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.ebs.EbsFunctions;
 * import com.pulumi.alicloud.ebs.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.ebs.DiskReplicaGroup;
 * import com.pulumi.alicloud.ebs.DiskReplicaGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         final var defaultGetRegions = EbsFunctions.getRegions(GetRegionsArgs.builder()
 *             .regionId(default_.regions()[0].id())
 *             .build());
 *         var defaultDiskReplicaGroup = new DiskReplicaGroup("defaultDiskReplicaGroup", DiskReplicaGroupArgs.builder()
 *             .sourceRegionId(default_.regions()[0].id())
 *             .sourceZoneId(defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0]&#46;zones()[0].zoneId()))
 *             .destinationRegionId(default_.regions()[0].id())
 *             .destinationZoneId(defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0]&#46;zones()[1].zoneId()))
 *             .groupName(name)
 *             .description(name)
 *             .rpo(900)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultDiskReplicaGroup:
 *     type: alicloud:ebs:DiskReplicaGroup
 *     name: default
 *     properties:
 *       sourceRegionId: ${default.regions[0].id}
 *       sourceZoneId: ${defaultGetRegions.regions[0]&#46;zones[0].zoneId}
 *       destinationRegionId: ${default.regions[0].id}
 *       destinationZoneId: ${defaultGetRegions.regions[0]&#46;zones[1].zoneId}
 *       groupName: ${name}
 *       description: ${name}
 *       rpo: 900
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 *   defaultGetRegions:
 *     fn::invoke:
 *       Function: alicloud:ebs:getRegions
 *       Arguments:
 *         regionId: ${default.regions[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * EBS Disk Replica Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ebs/diskReplicaGroup:DiskReplicaGroup example <id>
 * ```
 * @property description The description of the consistent replication group.
 * @property destinationRegionId The ID of the region to which the disaster recovery site belongs.
 * @property destinationZoneId The ID of the zone to which the disaster recovery site belongs.
 * @property groupName Consistent replication group name.
 * @property rpo The recovery point objective (RPO) of the replication pair-consistent group. Unit: seconds.
 * @property sourceRegionId The ID of the region to which the production site belongs.
 * @property sourceZoneId The ID of the zone to which the production site belongs.
 */
public data class DiskReplicaGroupArgs(
    public val description: Output<String>? = null,
    public val destinationRegionId: Output<String>? = null,
    public val destinationZoneId: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val rpo: Output<Int>? = null,
    public val sourceRegionId: Output<String>? = null,
    public val sourceZoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.DiskReplicaGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.DiskReplicaGroupArgs =
        com.pulumi.alicloud.ebs.DiskReplicaGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationRegionId(destinationRegionId?.applyValue({ args0 -> args0 }))
            .destinationZoneId(destinationZoneId?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .rpo(rpo?.applyValue({ args0 -> args0 }))
            .sourceRegionId(sourceRegionId?.applyValue({ args0 -> args0 }))
            .sourceZoneId(sourceZoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskReplicaGroupArgs].
 */
@PulumiTagMarker
public class DiskReplicaGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationRegionId: Output<String>? = null

    private var destinationZoneId: Output<String>? = null

    private var groupName: Output<String>? = null

    private var rpo: Output<Int>? = null

    private var sourceRegionId: Output<String>? = null

    private var sourceZoneId: Output<String>? = null

    /**
     * @param value The description of the consistent replication group.
     */
    @JvmName("leqixoosdqwhwrbs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the region to which the disaster recovery site belongs.
     */
    @JvmName("tbgmwtdulipbxtwf")
    public suspend fun destinationRegionId(`value`: Output<String>) {
        this.destinationRegionId = value
    }

    /**
     * @param value The ID of the zone to which the disaster recovery site belongs.
     */
    @JvmName("dbfoxcmtoeslqlnd")
    public suspend fun destinationZoneId(`value`: Output<String>) {
        this.destinationZoneId = value
    }

    /**
     * @param value Consistent replication group name.
     */
    @JvmName("ohvlqognhmyxnqcv")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The recovery point objective (RPO) of the replication pair-consistent group. Unit: seconds.
     */
    @JvmName("jihhisbkcldrqelj")
    public suspend fun rpo(`value`: Output<Int>) {
        this.rpo = value
    }

    /**
     * @param value The ID of the region to which the production site belongs.
     */
    @JvmName("wfrnlfomlkdgpdan")
    public suspend fun sourceRegionId(`value`: Output<String>) {
        this.sourceRegionId = value
    }

    /**
     * @param value The ID of the zone to which the production site belongs.
     */
    @JvmName("hpmmxtjsdwdlotqf")
    public suspend fun sourceZoneId(`value`: Output<String>) {
        this.sourceZoneId = value
    }

    /**
     * @param value The description of the consistent replication group.
     */
    @JvmName("tcpsvqdixehomfjl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the region to which the disaster recovery site belongs.
     */
    @JvmName("qckhigglaqdxrxuc")
    public suspend fun destinationRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationRegionId = mapped
    }

    /**
     * @param value The ID of the zone to which the disaster recovery site belongs.
     */
    @JvmName("luujpsjxumllcnjk")
    public suspend fun destinationZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationZoneId = mapped
    }

    /**
     * @param value Consistent replication group name.
     */
    @JvmName("wgouffxnxsakrihf")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value The recovery point objective (RPO) of the replication pair-consistent group. Unit: seconds.
     */
    @JvmName("fhopogccslsesujv")
    public suspend fun rpo(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rpo = mapped
    }

    /**
     * @param value The ID of the region to which the production site belongs.
     */
    @JvmName("ijaesyqfyrhjmibm")
    public suspend fun sourceRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRegionId = mapped
    }

    /**
     * @param value The ID of the zone to which the production site belongs.
     */
    @JvmName("abjsrpjnsyucyawu")
    public suspend fun sourceZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceZoneId = mapped
    }

    internal fun build(): DiskReplicaGroupArgs = DiskReplicaGroupArgs(
        description = description,
        destinationRegionId = destinationRegionId,
        destinationZoneId = destinationZoneId,
        groupName = groupName,
        rpo = rpo,
        sourceRegionId = sourceRegionId,
        sourceZoneId = sourceZoneId,
    )
}
