@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DiskReplicaPair].
 */
@PulumiTagMarker
public class DiskReplicaPairResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiskReplicaPairArgs = DiskReplicaPairArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiskReplicaPairArgsBuilder.() -> Unit) {
        val builder = DiskReplicaPairArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DiskReplicaPair {
        val builtJavaResource = com.pulumi.alicloud.ebs.DiskReplicaPair(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DiskReplicaPair(builtJavaResource)
    }
}

/**
 * Provides a Ebs Disk Replica Pair resource.
 * For information about Ebs Disk Replica Pair and how to use it, see [What is Disk Replica Pair](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-ebs-2021-07-30-creatediskreplicapair).
 * > **NOTE:** Available since v1.196.0.
 * ## Import
 * Ebs Disk Replica Pair can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ebs/diskReplicaPair:DiskReplicaPair example <id>
 * ```
 */
public class DiskReplicaPair internal constructor(
    override val javaResource: com.pulumi.alicloud.ebs.DiskReplicaPair,
) : KotlinCustomResource(javaResource, DiskReplicaPairMapper) {
    /**
     * The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:-10240 Kbps: equal to 10 Mbps.-20480 Kbps: equal to 20 Mbps.-51200 Kbps: equal to 50 Mbps.-102400 Kbps: equal to 100 Mbps.Default value: 10240.This parameter cannot be specified when the ChargeType value is POSTPAY. The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
     */
    public val bandwidth: Output<String>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the standby disk.
     */
    public val destinationDiskId: Output<String>
        get() = javaResource.destinationDiskId().applyValue({ args0 -> args0 })

    /**
     * The ID of the region to which the disaster recovery site belongs.
     */
    public val destinationRegionId: Output<String>
        get() = javaResource.destinationRegionId().applyValue({ args0 -> args0 })

    /**
     * The ID of the zone to which the disaster recovery site belongs.
     */
    public val destinationZoneId: Output<String>
        get() = javaResource.destinationZoneId().applyValue({ args0 -> args0 })

    /**
     * The ID of the primary disk.
     */
    public val diskId: Output<String>
        get() = javaResource.diskId().applyValue({ args0 -> args0 })

    /**
     * The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
     */
    public val pairName: Output<String>?
        get() = javaResource.pairName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The payment type of the resource
     */
    public val paymentType: Output<String>?
        get() = javaResource.paymentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The length of the purchase for the asynchronous replication relationship. When ChargeType=PrePay, this parameter is mandatory. The unit of duration is specified by PeriodUnit and takes on a range of values. When PeriodUnit=Week, this parameter takes values in the range `1`, `2`, `3` and `4`. When PeriodUnit=Month, the parameter takes on the values `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
     */
    public val period: Output<String>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The units of asynchronous replication relationship purchase length. Valid values: `Week` and `Month`. Default value: `Month`.
     */
    public val periodUnit: Output<String>?
        get() = javaResource.periodUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The first ID of the resource.
     */
    public val replicaPairId: Output<String>
        get() = javaResource.replicaPairId().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
     */
    public val rpo: Output<String>
        get() = javaResource.rpo().applyValue({ args0 -> args0 })

    /**
     * The ID of the zone to which the production site belongs.
     */
    public val sourceZoneId: Output<String>
        get() = javaResource.sourceZoneId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object DiskReplicaPairMapper : ResourceMapper<DiskReplicaPair> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ebs.DiskReplicaPair::class == javaResource::class

    override fun map(javaResource: Resource): DiskReplicaPair = DiskReplicaPair(
        javaResource as
            com.pulumi.alicloud.ebs.DiskReplicaPair,
    )
}

/**
 * @see [DiskReplicaPair].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DiskReplicaPair].
 */
public suspend fun diskReplicaPair(
    name: String,
    block: suspend DiskReplicaPairResourceBuilder.() -> Unit,
): DiskReplicaPair {
    val builder = DiskReplicaPairResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DiskReplicaPair].
 * @param name The _unique_ name of the resulting resource.
 */
public fun diskReplicaPair(name: String): DiskReplicaPair {
    val builder = DiskReplicaPairResourceBuilder()
    builder.name(name)
    return builder.build()
}
