@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin

import com.pulumi.alicloud.ebs.DiskReplicaPairArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Ebs Disk Replica Pair resource.
 * For information about Ebs Disk Replica Pair and how to use it, see [What is Disk Replica Pair](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-ebs-2021-07-30-creatediskreplicapair).
 * > **NOTE:** Available since v1.196.0.
 * ## Import
 * Ebs Disk Replica Pair can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ebs/diskReplicaPair:DiskReplicaPair example <id>
 * ```
 * @property bandwidth The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:-10240 Kbps: equal to 10 Mbps.-20480 Kbps: equal to 20 Mbps.-51200 Kbps: equal to 50 Mbps.-102400 Kbps: equal to 100 Mbps.Default value: 10240.This parameter cannot be specified when the ChargeType value is POSTPAY. The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
 * @property description The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
 * @property destinationDiskId The ID of the standby disk.
 * @property destinationRegionId The ID of the region to which the disaster recovery site belongs.
 * @property destinationZoneId The ID of the zone to which the disaster recovery site belongs.
 * @property diskId The ID of the primary disk.
 * @property pairName The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
 * @property paymentType The payment type of the resource
 * @property period The length of the purchase for the asynchronous replication relationship. When ChargeType=PrePay, this parameter is mandatory. The unit of duration is specified by PeriodUnit and takes on a range of values. When PeriodUnit=Week, this parameter takes values in the range `1`, `2`, `3` and `4`. When PeriodUnit=Month, the parameter takes on the values `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
 * @property periodUnit The units of asynchronous replication relationship purchase length. Valid values: `Week` and `Month`. Default value: `Month`.
 * @property replicaPairId The first ID of the resource.
 * @property rpo The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
 * @property sourceZoneId The ID of the zone to which the production site belongs.
 */
public data class DiskReplicaPairArgs(
    public val bandwidth: Output<String>? = null,
    public val description: Output<String>? = null,
    public val destinationDiskId: Output<String>? = null,
    public val destinationRegionId: Output<String>? = null,
    public val destinationZoneId: Output<String>? = null,
    public val diskId: Output<String>? = null,
    public val pairName: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<String>? = null,
    public val periodUnit: Output<String>? = null,
    public val replicaPairId: Output<String>? = null,
    public val rpo: Output<String>? = null,
    public val sourceZoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.DiskReplicaPairArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.DiskReplicaPairArgs =
        com.pulumi.alicloud.ebs.DiskReplicaPairArgs.builder()
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationDiskId(destinationDiskId?.applyValue({ args0 -> args0 }))
            .destinationRegionId(destinationRegionId?.applyValue({ args0 -> args0 }))
            .destinationZoneId(destinationZoneId?.applyValue({ args0 -> args0 }))
            .diskId(diskId?.applyValue({ args0 -> args0 }))
            .pairName(pairName?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .replicaPairId(replicaPairId?.applyValue({ args0 -> args0 }))
            .rpo(rpo?.applyValue({ args0 -> args0 }))
            .sourceZoneId(sourceZoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskReplicaPairArgs].
 */
@PulumiTagMarker
public class DiskReplicaPairArgsBuilder internal constructor() {
    private var bandwidth: Output<String>? = null

    private var description: Output<String>? = null

    private var destinationDiskId: Output<String>? = null

    private var destinationRegionId: Output<String>? = null

    private var destinationZoneId: Output<String>? = null

    private var diskId: Output<String>? = null

    private var pairName: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<String>? = null

    private var periodUnit: Output<String>? = null

    private var replicaPairId: Output<String>? = null

    private var rpo: Output<String>? = null

    private var sourceZoneId: Output<String>? = null

    /**
     * @param value The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:-10240 Kbps: equal to 10 Mbps.-20480 Kbps: equal to 20 Mbps.-51200 Kbps: equal to 50 Mbps.-102400 Kbps: equal to 100 Mbps.Default value: 10240.This parameter cannot be specified when the ChargeType value is POSTPAY. The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
     */
    @JvmName("xdxkfrokcretdkwn")
    public suspend fun bandwidth(`value`: Output<String>) {
        this.bandwidth = value
    }

    /**
     * @param value The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
     */
    @JvmName("uaeqyoarbuwhwdco")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the standby disk.
     */
    @JvmName("wjkruqhqbnmlfpae")
    public suspend fun destinationDiskId(`value`: Output<String>) {
        this.destinationDiskId = value
    }

    /**
     * @param value The ID of the region to which the disaster recovery site belongs.
     */
    @JvmName("sbpyqoiquagnvkus")
    public suspend fun destinationRegionId(`value`: Output<String>) {
        this.destinationRegionId = value
    }

    /**
     * @param value The ID of the zone to which the disaster recovery site belongs.
     */
    @JvmName("dkyucgairfkwdtvd")
    public suspend fun destinationZoneId(`value`: Output<String>) {
        this.destinationZoneId = value
    }

    /**
     * @param value The ID of the primary disk.
     */
    @JvmName("lbayxmcxphoxfhsq")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
     */
    @JvmName("vvtgtsivkvoetjqd")
    public suspend fun pairName(`value`: Output<String>) {
        this.pairName = value
    }

    /**
     * @param value The payment type of the resource
     */
    @JvmName("ildjjvewabwwxcts")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The length of the purchase for the asynchronous replication relationship. When ChargeType=PrePay, this parameter is mandatory. The unit of duration is specified by PeriodUnit and takes on a range of values. When PeriodUnit=Week, this parameter takes values in the range `1`, `2`, `3` and `4`. When PeriodUnit=Month, the parameter takes on the values `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
     */
    @JvmName("dyltrbeonkrmjarv")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value The units of asynchronous replication relationship purchase length. Valid values: `Week` and `Month`. Default value: `Month`.
     */
    @JvmName("uedliudpiccqyyrj")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value The first ID of the resource.
     */
    @JvmName("aobgkggccmwxqone")
    public suspend fun replicaPairId(`value`: Output<String>) {
        this.replicaPairId = value
    }

    /**
     * @param value The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
     */
    @JvmName("jamnscwedfnpwsdb")
    public suspend fun rpo(`value`: Output<String>) {
        this.rpo = value
    }

    /**
     * @param value The ID of the zone to which the production site belongs.
     */
    @JvmName("yqfybaydbaogitix")
    public suspend fun sourceZoneId(`value`: Output<String>) {
        this.sourceZoneId = value
    }

    /**
     * @param value The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:-10240 Kbps: equal to 10 Mbps.-20480 Kbps: equal to 20 Mbps.-51200 Kbps: equal to 50 Mbps.-102400 Kbps: equal to 100 Mbps.Default value: 10240.This parameter cannot be specified when the ChargeType value is POSTPAY. The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
     */
    @JvmName("bkqscvxojtcpmrme")
    public suspend fun bandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
     */
    @JvmName("dlideiliylfbyyxk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the standby disk.
     */
    @JvmName("pmnchcxeireuqcso")
    public suspend fun destinationDiskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationDiskId = mapped
    }

    /**
     * @param value The ID of the region to which the disaster recovery site belongs.
     */
    @JvmName("pddohhlplcfvprto")
    public suspend fun destinationRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationRegionId = mapped
    }

    /**
     * @param value The ID of the zone to which the disaster recovery site belongs.
     */
    @JvmName("wntbdaurwbjdwdfy")
    public suspend fun destinationZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationZoneId = mapped
    }

    /**
     * @param value The ID of the primary disk.
     */
    @JvmName("jpwwxhbigycpmabw")
    public suspend fun diskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
     */
    @JvmName("yhlrnanypecacqrv")
    public suspend fun pairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pairName = mapped
    }

    /**
     * @param value The payment type of the resource
     */
    @JvmName("koqioeltbrsmpjrc")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The length of the purchase for the asynchronous replication relationship. When ChargeType=PrePay, this parameter is mandatory. The unit of duration is specified by PeriodUnit and takes on a range of values. When PeriodUnit=Week, this parameter takes values in the range `1`, `2`, `3` and `4`. When PeriodUnit=Month, the parameter takes on the values `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
     */
    @JvmName("vvalvrqwnqwgreqw")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The units of asynchronous replication relationship purchase length. Valid values: `Week` and `Month`. Default value: `Month`.
     */
    @JvmName("jryityolxetdxsdo")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value The first ID of the resource.
     */
    @JvmName("ecaddqqbkaaxnndi")
    public suspend fun replicaPairId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaPairId = mapped
    }

    /**
     * @param value The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
     */
    @JvmName("xtglsolusgmvhtgs")
    public suspend fun rpo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rpo = mapped
    }

    /**
     * @param value The ID of the zone to which the production site belongs.
     */
    @JvmName("axhqfvfwnwbxcirf")
    public suspend fun sourceZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceZoneId = mapped
    }

    internal fun build(): DiskReplicaPairArgs = DiskReplicaPairArgs(
        bandwidth = bandwidth,
        description = description,
        destinationDiskId = destinationDiskId,
        destinationRegionId = destinationRegionId,
        destinationZoneId = destinationZoneId,
        diskId = diskId,
        pairName = pairName,
        paymentType = paymentType,
        period = period,
        periodUnit = periodUnit,
        replicaPairId = replicaPairId,
        rpo = rpo,
        sourceZoneId = sourceZoneId,
    )
}
