@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin

import com.pulumi.alicloud.ebs.EbsFunctions.getDedicatedBlockStorageClustersPlain
import com.pulumi.alicloud.ebs.EbsFunctions.getDiskReplicaGroupsPlain
import com.pulumi.alicloud.ebs.EbsFunctions.getDiskReplicaPairsPlain
import com.pulumi.alicloud.ebs.EbsFunctions.getRegionsPlain
import com.pulumi.alicloud.ebs.kotlin.inputs.GetDedicatedBlockStorageClustersPlainArgs
import com.pulumi.alicloud.ebs.kotlin.inputs.GetDedicatedBlockStorageClustersPlainArgsBuilder
import com.pulumi.alicloud.ebs.kotlin.inputs.GetDiskReplicaGroupsPlainArgs
import com.pulumi.alicloud.ebs.kotlin.inputs.GetDiskReplicaGroupsPlainArgsBuilder
import com.pulumi.alicloud.ebs.kotlin.inputs.GetDiskReplicaPairsPlainArgs
import com.pulumi.alicloud.ebs.kotlin.inputs.GetDiskReplicaPairsPlainArgsBuilder
import com.pulumi.alicloud.ebs.kotlin.inputs.GetRegionsPlainArgs
import com.pulumi.alicloud.ebs.kotlin.inputs.GetRegionsPlainArgsBuilder
import com.pulumi.alicloud.ebs.kotlin.outputs.GetDedicatedBlockStorageClustersResult
import com.pulumi.alicloud.ebs.kotlin.outputs.GetDiskReplicaGroupsResult
import com.pulumi.alicloud.ebs.kotlin.outputs.GetDiskReplicaPairsResult
import com.pulumi.alicloud.ebs.kotlin.outputs.GetRegionsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.ebs.kotlin.outputs.GetDedicatedBlockStorageClustersResult.Companion.toKotlin as getDedicatedBlockStorageClustersResultToKotlin
import com.pulumi.alicloud.ebs.kotlin.outputs.GetDiskReplicaGroupsResult.Companion.toKotlin as getDiskReplicaGroupsResultToKotlin
import com.pulumi.alicloud.ebs.kotlin.outputs.GetDiskReplicaPairsResult.Companion.toKotlin as getDiskReplicaPairsResultToKotlin
import com.pulumi.alicloud.ebs.kotlin.outputs.GetRegionsResult.Companion.toKotlin as getRegionsResultToKotlin

public object EbsFunctions {
    /**
     * This data source provides Ebs Dedicated Block Storage Cluster available to the user.
     * > **NOTE:** Available in 1.196.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ebs.getDedicatedBlockStorageClusters({
     *     ids: ["example_id"],
     *     nameRegex: defaultAlicloudEbsDedicatedBlockStorageCluster.name,
     * });
     * export const alicloudEbsDedicatedBlockStorageClusterExampleId = _default.then(_default => _default.clusters?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ebs.get_dedicated_block_storage_clusters(ids=["example_id"],
     *     name_regex=default_alicloud_ebs_dedicated_block_storage_cluster["name"])
     * pulumi.export("alicloudEbsDedicatedBlockStorageClusterExampleId", default.clusters[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ebs.GetDedicatedBlockStorageClusters.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         NameRegex = defaultAlicloudEbsDedicatedBlockStorageCluster.Name,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudEbsDedicatedBlockStorageClusterExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getDedicatedBlockStorageClustersResult => getDedicatedBlockStorageClustersResult&#46;Clusters[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ebs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := ebs.GetDedicatedBlockStorageClusters(ctx, &ebs.GetDedicatedBlockStorageClustersArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			NameRegex: pulumi.StringRef(defaultAlicloudEbsDedicatedBlockStorageCluster.Name),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudEbsDedicatedBlockStorageClusterExampleId", _default.Clusters[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ebs.EbsFunctions;
     * import com.pulumi.alicloud.ebs.inputs.GetDedicatedBlockStorageClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EbsFunctions.getDedicatedBlockStorageClusters(GetDedicatedBlockStorageClustersArgs.builder()
     *             .ids("example_id")
     *             .nameRegex(defaultAlicloudEbsDedicatedBlockStorageCluster.name())
     *             .build());
     *         ctx.export("alicloudEbsDedicatedBlockStorageClusterExampleId", default_.clusters()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ebs:getDedicatedBlockStorageClusters
     *       Arguments:
     *         ids:
     *           - example_id
     *         nameRegex: ${defaultAlicloudEbsDedicatedBlockStorageCluster.name}
     * outputs:
     *   alicloudEbsDedicatedBlockStorageClusterExampleId: ${default.clusters[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDedicatedBlockStorageClusters.
     * @return A collection of values returned by getDedicatedBlockStorageClusters.
     */
    public suspend fun getDedicatedBlockStorageClusters(argument: GetDedicatedBlockStorageClustersPlainArgs): GetDedicatedBlockStorageClustersResult =
        getDedicatedBlockStorageClustersResultToKotlin(getDedicatedBlockStorageClustersPlain(argument.toJava()).await())

    /**
     * @see [getDedicatedBlockStorageClusters].
     * @param ids A list of Dedicated Block Storage Cluster IDs.
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getDedicatedBlockStorageClusters.
     */
    public suspend fun getDedicatedBlockStorageClusters(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetDedicatedBlockStorageClustersResult {
        val argument = GetDedicatedBlockStorageClustersPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getDedicatedBlockStorageClustersResultToKotlin(getDedicatedBlockStorageClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getDedicatedBlockStorageClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ebs&#46;kotlin&#46;inputs&#46;GetDedicatedBlockStorageClustersPlainArgs].
     * @return A collection of values returned by getDedicatedBlockStorageClusters.
     */
    public suspend fun getDedicatedBlockStorageClusters(argument: suspend GetDedicatedBlockStorageClustersPlainArgsBuilder.() -> Unit): GetDedicatedBlockStorageClustersResult {
        val builder = GetDedicatedBlockStorageClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDedicatedBlockStorageClustersResultToKotlin(getDedicatedBlockStorageClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ebs Disk Replica Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.187.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ebs.getDiskReplicaGroups({
     *     ids: ["example_id"],
     * });
     * export const ebsDiskReplicaGroupId1 = ids.then(ids => ids.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ebs.get_disk_replica_groups(ids=["example_id"])
     * pulumi.export("ebsDiskReplicaGroupId1", ids.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ebs.GetDiskReplicaGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ebsDiskReplicaGroupId1"] = ids&#46;Apply(getDiskReplicaGroupsResult => getDiskReplicaGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ebs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ebs.GetDiskReplicaGroups(ctx, &ebs.GetDiskReplicaGroupsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ebsDiskReplicaGroupId1", ids.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ebs.EbsFunctions;
     * import com.pulumi.alicloud.ebs.inputs.GetDiskReplicaGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EbsFunctions.getDiskReplicaGroups(GetDiskReplicaGroupsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("ebsDiskReplicaGroupId1", ids.applyValue(getDiskReplicaGroupsResult -> getDiskReplicaGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ebs:getDiskReplicaGroups
     *       Arguments:
     *         ids:
     *           - example_id
     * outputs:
     *   ebsDiskReplicaGroupId1: ${ids.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDiskReplicaGroups.
     * @return A collection of values returned by getDiskReplicaGroups.
     */
    public suspend fun getDiskReplicaGroups(argument: GetDiskReplicaGroupsPlainArgs): GetDiskReplicaGroupsResult =
        getDiskReplicaGroupsResultToKotlin(getDiskReplicaGroupsPlain(argument.toJava()).await())

    /**
     * @see [getDiskReplicaGroups].
     * @param ids A list of Disk Replica Group IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getDiskReplicaGroups.
     */
    public suspend fun getDiskReplicaGroups(ids: List<String>? = null, outputFile: String? = null): GetDiskReplicaGroupsResult {
        val argument = GetDiskReplicaGroupsPlainArgs(
            ids = ids,
            outputFile = outputFile,
        )
        return getDiskReplicaGroupsResultToKotlin(getDiskReplicaGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDiskReplicaGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ebs&#46;kotlin&#46;inputs&#46;GetDiskReplicaGroupsPlainArgs].
     * @return A collection of values returned by getDiskReplicaGroups.
     */
    public suspend fun getDiskReplicaGroups(argument: suspend GetDiskReplicaGroupsPlainArgsBuilder.() -> Unit): GetDiskReplicaGroupsResult {
        val builder = GetDiskReplicaGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiskReplicaGroupsResultToKotlin(getDiskReplicaGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Ebs Disk Replica Pair available to the user.
     * > **NOTE:** Available in 1.196.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ebs.getDiskReplicaPairs({
     *     ids: [defaultAlicloudEbsDiskReplicaPair&#46;id],
     * });
     * export const alicloudEbsDiskReplicaPairExampleId = _default.then(_default => _default.pairs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ebs.get_disk_replica_pairs(ids=[default_alicloud_ebs_disk_replica_pair["id"]])
     * pulumi.export("alicloudEbsDiskReplicaPairExampleId", default.pairs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ebs.GetDiskReplicaPairs.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudEbsDiskReplicaPair.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudEbsDiskReplicaPairExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getDiskReplicaPairsResult => getDiskReplicaPairsResult&#46;Pairs[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ebs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := ebs.GetDiskReplicaPairs(ctx, &ebs.GetDiskReplicaPairsArgs{
     * Ids: interface{}{
     * defaultAlicloudEbsDiskReplicaPair.Id,
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudEbsDiskReplicaPairExampleId", _default.Pairs[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ebs.EbsFunctions;
     * import com.pulumi.alicloud.ebs.inputs.GetDiskReplicaPairsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EbsFunctions.getDiskReplicaPairs(GetDiskReplicaPairsArgs.builder()
     *             .ids(defaultAlicloudEbsDiskReplicaPair.id())
     *             .build());
     *         ctx.export("alicloudEbsDiskReplicaPairExampleId", default_.pairs()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ebs:getDiskReplicaPairs
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudEbsDiskReplicaPair.id}
     * outputs:
     *   alicloudEbsDiskReplicaPairExampleId: ${default.pairs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDiskReplicaPairs.
     * @return A collection of values returned by getDiskReplicaPairs.
     */
    public suspend fun getDiskReplicaPairs(argument: GetDiskReplicaPairsPlainArgs): GetDiskReplicaPairsResult =
        getDiskReplicaPairsResultToKotlin(getDiskReplicaPairsPlain(argument.toJava()).await())

    /**
     * @see [getDiskReplicaPairs].
     * @param ids A list of Disk Replica Pair IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param replicaGroupId Consistent Replication Group ID, you can specify a consistent replication group ID to query the replication pairs within the group.
     * @param site Get data for replication pairs where this Region is the production site or the disaster recovery site.
     * @return A collection of values returned by getDiskReplicaPairs.
     */
    public suspend fun getDiskReplicaPairs(
        ids: List<String>? = null,
        outputFile: String? = null,
        replicaGroupId: String? = null,
        site: String? = null,
    ): GetDiskReplicaPairsResult {
        val argument = GetDiskReplicaPairsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            replicaGroupId = replicaGroupId,
            site = site,
        )
        return getDiskReplicaPairsResultToKotlin(getDiskReplicaPairsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDiskReplicaPairs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ebs&#46;kotlin&#46;inputs&#46;GetDiskReplicaPairsPlainArgs].
     * @return A collection of values returned by getDiskReplicaPairs.
     */
    public suspend fun getDiskReplicaPairs(argument: suspend GetDiskReplicaPairsPlainArgsBuilder.() -> Unit): GetDiskReplicaPairsResult {
        val builder = GetDiskReplicaPairsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiskReplicaPairsResultToKotlin(getDiskReplicaPairsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ebs Regions of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.187.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ebs.getRegions({
     *     regionId: "cn-hangzhou",
     * });
     * export const regions = _default.then(_default => _default.regions);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ebs.get_regions(region_id="cn-hangzhou")
     * pulumi.export("regions", default.regions)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ebs.GetRegions.Invoke(new()
     *     {
     *         RegionId = "cn-hangzhou",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["regions"] = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ebs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := ebs.GetRegions(ctx, &ebs.GetRegionsArgs{
     * 			RegionId: pulumi.StringRef("cn-hangzhou"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("regions", _default.Regions)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ebs.EbsFunctions;
     * import com.pulumi.alicloud.ebs.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EbsFunctions.getRegions(GetRegionsArgs.builder()
     *             .regionId("cn-hangzhou")
     *             .build());
     *         ctx.export("regions", default_.regions());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ebs:getRegions
     *       Arguments:
     *         regionId: cn-hangzhou
     * outputs:
     *   regions: ${default.regions}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRegions.
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(argument: GetRegionsPlainArgs): GetRegionsResult =
        getRegionsResultToKotlin(getRegionsPlain(argument.toJava()).await())

    /**
     * @see [getRegions].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param regionId A list of Disk Replica Group IDs.
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(outputFile: String? = null, regionId: String? = null): GetRegionsResult {
        val argument = GetRegionsPlainArgs(
            outputFile = outputFile,
            regionId = regionId,
        )
        return getRegionsResultToKotlin(getRegionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ebs&#46;kotlin&#46;inputs&#46;GetRegionsPlainArgs].
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(argument: suspend GetRegionsPlainArgsBuilder.() -> Unit): GetRegionsResult {
        val builder = GetRegionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegionsResultToKotlin(getRegionsPlain(builtArgument.toJava()).await())
    }
}
