@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin

import com.pulumi.alicloud.ebs.kotlin.outputs.EnterpriseSnapshotPolicyCrossRegionCopyInfo
import com.pulumi.alicloud.ebs.kotlin.outputs.EnterpriseSnapshotPolicyRetainRule
import com.pulumi.alicloud.ebs.kotlin.outputs.EnterpriseSnapshotPolicySchedule
import com.pulumi.alicloud.ebs.kotlin.outputs.EnterpriseSnapshotPolicySpecialRetainRules
import com.pulumi.alicloud.ebs.kotlin.outputs.EnterpriseSnapshotPolicyStorageRule
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.alicloud.ebs.kotlin.outputs.EnterpriseSnapshotPolicyCrossRegionCopyInfo.Companion.toKotlin as enterpriseSnapshotPolicyCrossRegionCopyInfoToKotlin
import com.pulumi.alicloud.ebs.kotlin.outputs.EnterpriseSnapshotPolicyRetainRule.Companion.toKotlin as enterpriseSnapshotPolicyRetainRuleToKotlin
import com.pulumi.alicloud.ebs.kotlin.outputs.EnterpriseSnapshotPolicySchedule.Companion.toKotlin as enterpriseSnapshotPolicyScheduleToKotlin
import com.pulumi.alicloud.ebs.kotlin.outputs.EnterpriseSnapshotPolicySpecialRetainRules.Companion.toKotlin as enterpriseSnapshotPolicySpecialRetainRulesToKotlin
import com.pulumi.alicloud.ebs.kotlin.outputs.EnterpriseSnapshotPolicyStorageRule.Companion.toKotlin as enterpriseSnapshotPolicyStorageRuleToKotlin

/**
 * Builder for [EnterpriseSnapshotPolicy].
 */
@PulumiTagMarker
public class EnterpriseSnapshotPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnterpriseSnapshotPolicyArgs = EnterpriseSnapshotPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnterpriseSnapshotPolicyArgsBuilder.() -> Unit) {
        val builder = EnterpriseSnapshotPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnterpriseSnapshotPolicy {
        val builtJavaResource =
            com.pulumi.alicloud.ebs.EnterpriseSnapshotPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EnterpriseSnapshotPolicy(builtJavaResource)
    }
}

/**
 * Provides a EBS Enterprise Snapshot Policy resource. enterprise snapshot policy.
 * For information about EBS Enterprise Snapshot Policy and how to use it, see [What is Enterprise Snapshot Policy](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.215.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultJkW46o = new alicloud.ecs.EcsDisk("defaultJkW46o", {
 *     category: "cloud_essd",
 *     description: "esp-attachment-test",
 *     zoneId: "cn-hangzhou-i",
 *     performanceLevel: "PL1",
 *     size: 20,
 *     diskName: name,
 * });
 * const defaultPE3jjR = new alicloud.ebs.EnterpriseSnapshotPolicy("defaultPE3jjR", {
 *     status: "DISABLED",
 *     desc: "DESC",
 *     schedule: {
 *         cronExpression: "0 0 0 1 * ?",
 *     },
 *     enterpriseSnapshotPolicyName: name,
 *     targetType: "DISK",
 *     retainRule: {
 *         timeInterval: 120,
 *         timeUnit: "DAYS",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_jk_w46o = alicloud.ecs.EcsDisk("defaultJkW46o",
 *     category="cloud_essd",
 *     description="esp-attachment-test",
 *     zone_id="cn-hangzhou-i",
 *     performance_level="PL1",
 *     size=20,
 *     disk_name=name)
 * default_pe3jj_r = alicloud.ebs.EnterpriseSnapshotPolicy("defaultPE3jjR",
 *     status="DISABLED",
 *     desc="DESC",
 *     schedule={
 *         "cron_expression": "0 0 0 1 * ?",
 *     },
 *     enterprise_snapshot_policy_name=name,
 *     target_type="DISK",
 *     retain_rule={
 *         "time_interval": 120,
 *         "time_unit": "DAYS",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultJkW46o = new AliCloud.Ecs.EcsDisk("defaultJkW46o", new()
 *     {
 *         Category = "cloud_essd",
 *         Description = "esp-attachment-test",
 *         ZoneId = "cn-hangzhou-i",
 *         PerformanceLevel = "PL1",
 *         Size = 20,
 *         DiskName = name,
 *     });
 *     var defaultPE3jjR = new AliCloud.Ebs.EnterpriseSnapshotPolicy("defaultPE3jjR", new()
 *     {
 *         Status = "DISABLED",
 *         Desc = "DESC",
 *         Schedule = new AliCloud.Ebs.Inputs.EnterpriseSnapshotPolicyScheduleArgs
 *         {
 *             CronExpression = "0 0 0 1 * ?",
 *         },
 *         EnterpriseSnapshotPolicyName = name,
 *         TargetType = "DISK",
 *         RetainRule = new AliCloud.Ebs.Inputs.EnterpriseSnapshotPolicyRetainRuleArgs
 *         {
 *             TimeInterval = 120,
 *             TimeUnit = "DAYS",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ebs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ecs.NewEcsDisk(ctx, "defaultJkW46o", &ecs.EcsDiskArgs{
 * 			Category:         pulumi.String("cloud_essd"),
 * 			Description:      pulumi.String("esp-attachment-test"),
 * 			ZoneId:           pulumi.String("cn-hangzhou-i"),
 * 			PerformanceLevel: pulumi.String("PL1"),
 * 			Size:             pulumi.Int(20),
 * 			DiskName:         pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ebs.NewEnterpriseSnapshotPolicy(ctx, "defaultPE3jjR", &ebs.EnterpriseSnapshotPolicyArgs{
 * 			Status: pulumi.String("DISABLED"),
 * 			Desc:   pulumi.String("DESC"),
 * 			Schedule: &ebs.EnterpriseSnapshotPolicyScheduleArgs{
 * 				CronExpression: pulumi.String("0 0 0 1 * ?"),
 * 			},
 * 			EnterpriseSnapshotPolicyName: pulumi.String(name),
 * 			TargetType:                   pulumi.String("DISK"),
 * 			RetainRule: &ebs.EnterpriseSnapshotPolicyRetainRuleArgs{
 * 				TimeInterval: pulumi.Int(120),
 * 				TimeUnit:     pulumi.String("DAYS"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsDisk;
 * import com.pulumi.alicloud.ecs.EcsDiskArgs;
 * import com.pulumi.alicloud.ebs.EnterpriseSnapshotPolicy;
 * import com.pulumi.alicloud.ebs.EnterpriseSnapshotPolicyArgs;
 * import com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyScheduleArgs;
 * import com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyRetainRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultJkW46o = new EcsDisk("defaultJkW46o", EcsDiskArgs.builder()
 *             .category("cloud_essd")
 *             .description("esp-attachment-test")
 *             .zoneId("cn-hangzhou-i")
 *             .performanceLevel("PL1")
 *             .size("20")
 *             .diskName(name)
 *             .build());
 *         var defaultPE3jjR = new EnterpriseSnapshotPolicy("defaultPE3jjR", EnterpriseSnapshotPolicyArgs.builder()
 *             .status("DISABLED")
 *             .desc("DESC")
 *             .schedule(EnterpriseSnapshotPolicyScheduleArgs.builder()
 *                 .cronExpression("0 0 0 1 * ?")
 *                 .build())
 *             .enterpriseSnapshotPolicyName(name)
 *             .targetType("DISK")
 *             .retainRule(EnterpriseSnapshotPolicyRetainRuleArgs.builder()
 *                 .timeInterval("120")
 *                 .timeUnit("DAYS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultJkW46o:
 *     type: alicloud:ecs:EcsDisk
 *     properties:
 *       category: cloud_essd
 *       description: esp-attachment-test
 *       zoneId: cn-hangzhou-i
 *       performanceLevel: PL1
 *       size: '20'
 *       diskName: ${name}
 *   defaultPE3jjR:
 *     type: alicloud:ebs:EnterpriseSnapshotPolicy
 *     properties:
 *       status: DISABLED
 *       desc: DESC
 *       schedule:
 *         cronExpression: 0 0 0 1 * ?
 *       enterpriseSnapshotPolicyName: ${name}
 *       targetType: DISK
 *       retainRule:
 *         timeInterval: '120'
 *         timeUnit: DAYS
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * EBS Enterprise Snapshot Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ebs/enterpriseSnapshotPolicy:EnterpriseSnapshotPolicy example <id>
 * ```
 */
public class EnterpriseSnapshotPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.ebs.EnterpriseSnapshotPolicy,
) : KotlinCustomResource(javaResource, EnterpriseSnapshotPolicyMapper) {
    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Snapshot replication information. See `cross_region_copy_info` below.
     */
    public val crossRegionCopyInfo: Output<EnterpriseSnapshotPolicyCrossRegionCopyInfo>
        get() = javaResource.crossRegionCopyInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                enterpriseSnapshotPolicyCrossRegionCopyInfoToKotlin(args0)
            })
        })

    /**
     * Description information representing the resource.
     */
    public val desc: Output<String>?
        get() = javaResource.desc().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val enterpriseSnapshotPolicyName: Output<String>
        get() = javaResource.enterpriseSnapshotPolicyName().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Snapshot retention policy representing resources. See `retain_rule` below.
     */
    public val retainRule: Output<EnterpriseSnapshotPolicyRetainRule>
        get() = javaResource.retainRule().applyValue({ args0 ->
            args0.let({ args0 ->
                enterpriseSnapshotPolicyRetainRuleToKotlin(args0)
            })
        })

    /**
     * The scheduling plan that represents the resource. See `schedule` below.
     */
    public val schedule: Output<EnterpriseSnapshotPolicySchedule>
        get() = javaResource.schedule().applyValue({ args0 ->
            args0.let({ args0 ->
                enterpriseSnapshotPolicyScheduleToKotlin(args0)
            })
        })

    /**
     * Snapshot special retention rules. See `special_retain_rules` below.
     */
    public val specialRetainRules: Output<EnterpriseSnapshotPolicySpecialRetainRules>
        get() = javaResource.specialRetainRules().applyValue({ args0 ->
            args0.let({ args0 ->
                enterpriseSnapshotPolicySpecialRetainRulesToKotlin(args0)
            })
        })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Snapshot storage policy. See `storage_rule` below.
     */
    public val storageRule: Output<EnterpriseSnapshotPolicyStorageRule>?
        get() = javaResource.storageRule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    enterpriseSnapshotPolicyStorageRuleToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The tag of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Represents the target type of resource binding.
     */
    public val targetType: Output<String>
        get() = javaResource.targetType().applyValue({ args0 -> args0 })
}

public object EnterpriseSnapshotPolicyMapper : ResourceMapper<EnterpriseSnapshotPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ebs.EnterpriseSnapshotPolicy::class == javaResource::class

    override fun map(javaResource: Resource): EnterpriseSnapshotPolicy =
        EnterpriseSnapshotPolicy(javaResource as com.pulumi.alicloud.ebs.EnterpriseSnapshotPolicy)
}

/**
 * @see [EnterpriseSnapshotPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnterpriseSnapshotPolicy].
 */
public suspend fun enterpriseSnapshotPolicy(
    name: String,
    block: suspend EnterpriseSnapshotPolicyResourceBuilder.() -> Unit,
): EnterpriseSnapshotPolicy {
    val builder = EnterpriseSnapshotPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnterpriseSnapshotPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun enterpriseSnapshotPolicy(name: String): EnterpriseSnapshotPolicy {
    val builder = EnterpriseSnapshotPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
