@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin

import com.pulumi.alicloud.ebs.EnterpriseSnapshotPolicyArgs.builder
import com.pulumi.alicloud.ebs.kotlin.inputs.EnterpriseSnapshotPolicyCrossRegionCopyInfoArgs
import com.pulumi.alicloud.ebs.kotlin.inputs.EnterpriseSnapshotPolicyCrossRegionCopyInfoArgsBuilder
import com.pulumi.alicloud.ebs.kotlin.inputs.EnterpriseSnapshotPolicyRetainRuleArgs
import com.pulumi.alicloud.ebs.kotlin.inputs.EnterpriseSnapshotPolicyRetainRuleArgsBuilder
import com.pulumi.alicloud.ebs.kotlin.inputs.EnterpriseSnapshotPolicyScheduleArgs
import com.pulumi.alicloud.ebs.kotlin.inputs.EnterpriseSnapshotPolicyScheduleArgsBuilder
import com.pulumi.alicloud.ebs.kotlin.inputs.EnterpriseSnapshotPolicySpecialRetainRulesArgs
import com.pulumi.alicloud.ebs.kotlin.inputs.EnterpriseSnapshotPolicySpecialRetainRulesArgsBuilder
import com.pulumi.alicloud.ebs.kotlin.inputs.EnterpriseSnapshotPolicyStorageRuleArgs
import com.pulumi.alicloud.ebs.kotlin.inputs.EnterpriseSnapshotPolicyStorageRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a EBS Enterprise Snapshot Policy resource. enterprise snapshot policy.
 * For information about EBS Enterprise Snapshot Policy and how to use it, see [What is Enterprise Snapshot Policy](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.215.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultJkW46o = new alicloud.ecs.EcsDisk("defaultJkW46o", {
 *     category: "cloud_essd",
 *     description: "esp-attachment-test",
 *     zoneId: "cn-hangzhou-i",
 *     performanceLevel: "PL1",
 *     size: 20,
 *     diskName: name,
 * });
 * const defaultPE3jjR = new alicloud.ebs.EnterpriseSnapshotPolicy("defaultPE3jjR", {
 *     status: "DISABLED",
 *     desc: "DESC",
 *     schedule: {
 *         cronExpression: "0 0 0 1 * ?",
 *     },
 *     enterpriseSnapshotPolicyName: name,
 *     targetType: "DISK",
 *     retainRule: {
 *         timeInterval: 120,
 *         timeUnit: "DAYS",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_jk_w46o = alicloud.ecs.EcsDisk("defaultJkW46o",
 *     category="cloud_essd",
 *     description="esp-attachment-test",
 *     zone_id="cn-hangzhou-i",
 *     performance_level="PL1",
 *     size=20,
 *     disk_name=name)
 * default_pe3jj_r = alicloud.ebs.EnterpriseSnapshotPolicy("defaultPE3jjR",
 *     status="DISABLED",
 *     desc="DESC",
 *     schedule={
 *         "cron_expression": "0 0 0 1 * ?",
 *     },
 *     enterprise_snapshot_policy_name=name,
 *     target_type="DISK",
 *     retain_rule={
 *         "time_interval": 120,
 *         "time_unit": "DAYS",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultJkW46o = new AliCloud.Ecs.EcsDisk("defaultJkW46o", new()
 *     {
 *         Category = "cloud_essd",
 *         Description = "esp-attachment-test",
 *         ZoneId = "cn-hangzhou-i",
 *         PerformanceLevel = "PL1",
 *         Size = 20,
 *         DiskName = name,
 *     });
 *     var defaultPE3jjR = new AliCloud.Ebs.EnterpriseSnapshotPolicy("defaultPE3jjR", new()
 *     {
 *         Status = "DISABLED",
 *         Desc = "DESC",
 *         Schedule = new AliCloud.Ebs.Inputs.EnterpriseSnapshotPolicyScheduleArgs
 *         {
 *             CronExpression = "0 0 0 1 * ?",
 *         },
 *         EnterpriseSnapshotPolicyName = name,
 *         TargetType = "DISK",
 *         RetainRule = new AliCloud.Ebs.Inputs.EnterpriseSnapshotPolicyRetainRuleArgs
 *         {
 *             TimeInterval = 120,
 *             TimeUnit = "DAYS",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ebs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ecs.NewEcsDisk(ctx, "defaultJkW46o", &ecs.EcsDiskArgs{
 * 			Category:         pulumi.String("cloud_essd"),
 * 			Description:      pulumi.String("esp-attachment-test"),
 * 			ZoneId:           pulumi.String("cn-hangzhou-i"),
 * 			PerformanceLevel: pulumi.String("PL1"),
 * 			Size:             pulumi.Int(20),
 * 			DiskName:         pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ebs.NewEnterpriseSnapshotPolicy(ctx, "defaultPE3jjR", &ebs.EnterpriseSnapshotPolicyArgs{
 * 			Status: pulumi.String("DISABLED"),
 * 			Desc:   pulumi.String("DESC"),
 * 			Schedule: &ebs.EnterpriseSnapshotPolicyScheduleArgs{
 * 				CronExpression: pulumi.String("0 0 0 1 * ?"),
 * 			},
 * 			EnterpriseSnapshotPolicyName: pulumi.String(name),
 * 			TargetType:                   pulumi.String("DISK"),
 * 			RetainRule: &ebs.EnterpriseSnapshotPolicyRetainRuleArgs{
 * 				TimeInterval: pulumi.Int(120),
 * 				TimeUnit:     pulumi.String("DAYS"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ecs.EcsDisk;
 * import com.pulumi.alicloud.ecs.EcsDiskArgs;
 * import com.pulumi.alicloud.ebs.EnterpriseSnapshotPolicy;
 * import com.pulumi.alicloud.ebs.EnterpriseSnapshotPolicyArgs;
 * import com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyScheduleArgs;
 * import com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyRetainRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultJkW46o = new EcsDisk("defaultJkW46o", EcsDiskArgs.builder()
 *             .category("cloud_essd")
 *             .description("esp-attachment-test")
 *             .zoneId("cn-hangzhou-i")
 *             .performanceLevel("PL1")
 *             .size("20")
 *             .diskName(name)
 *             .build());
 *         var defaultPE3jjR = new EnterpriseSnapshotPolicy("defaultPE3jjR", EnterpriseSnapshotPolicyArgs.builder()
 *             .status("DISABLED")
 *             .desc("DESC")
 *             .schedule(EnterpriseSnapshotPolicyScheduleArgs.builder()
 *                 .cronExpression("0 0 0 1 * ?")
 *                 .build())
 *             .enterpriseSnapshotPolicyName(name)
 *             .targetType("DISK")
 *             .retainRule(EnterpriseSnapshotPolicyRetainRuleArgs.builder()
 *                 .timeInterval("120")
 *                 .timeUnit("DAYS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultJkW46o:
 *     type: alicloud:ecs:EcsDisk
 *     properties:
 *       category: cloud_essd
 *       description: esp-attachment-test
 *       zoneId: cn-hangzhou-i
 *       performanceLevel: PL1
 *       size: '20'
 *       diskName: ${name}
 *   defaultPE3jjR:
 *     type: alicloud:ebs:EnterpriseSnapshotPolicy
 *     properties:
 *       status: DISABLED
 *       desc: DESC
 *       schedule:
 *         cronExpression: 0 0 0 1 * ?
 *       enterpriseSnapshotPolicyName: ${name}
 *       targetType: DISK
 *       retainRule:
 *         timeInterval: '120'
 *         timeUnit: DAYS
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * EBS Enterprise Snapshot Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ebs/enterpriseSnapshotPolicy:EnterpriseSnapshotPolicy example <id>
 * ```
 * @property crossRegionCopyInfo Snapshot replication information. See `cross_region_copy_info` below.
 * @property desc Description information representing the resource.
 * @property enterpriseSnapshotPolicyName The name of the resource.
 * @property resourceGroupId The ID of the resource group.
 * @property retainRule Snapshot retention policy representing resources. See `retain_rule` below.
 * @property schedule The scheduling plan that represents the resource. See `schedule` below.
 * @property specialRetainRules Snapshot special retention rules. See `special_retain_rules` below.
 * @property status The status of the resource.
 * @property storageRule Snapshot storage policy. See `storage_rule` below.
 * @property tags The tag of the resource.
 * @property targetType Represents the target type of resource binding.
 */
public data class EnterpriseSnapshotPolicyArgs(
    public val crossRegionCopyInfo: Output<EnterpriseSnapshotPolicyCrossRegionCopyInfoArgs>? = null,
    public val desc: Output<String>? = null,
    public val enterpriseSnapshotPolicyName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val retainRule: Output<EnterpriseSnapshotPolicyRetainRuleArgs>? = null,
    public val schedule: Output<EnterpriseSnapshotPolicyScheduleArgs>? = null,
    public val specialRetainRules: Output<EnterpriseSnapshotPolicySpecialRetainRulesArgs>? = null,
    public val status: Output<String>? = null,
    public val storageRule: Output<EnterpriseSnapshotPolicyStorageRuleArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.EnterpriseSnapshotPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.EnterpriseSnapshotPolicyArgs =
        com.pulumi.alicloud.ebs.EnterpriseSnapshotPolicyArgs.builder()
            .crossRegionCopyInfo(
                crossRegionCopyInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .desc(desc?.applyValue({ args0 -> args0 }))
            .enterpriseSnapshotPolicyName(enterpriseSnapshotPolicyName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .retainRule(retainRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .specialRetainRules(
                specialRetainRules?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .status(status?.applyValue({ args0 -> args0 }))
            .storageRule(storageRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetType(targetType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnterpriseSnapshotPolicyArgs].
 */
@PulumiTagMarker
public class EnterpriseSnapshotPolicyArgsBuilder internal constructor() {
    private var crossRegionCopyInfo: Output<EnterpriseSnapshotPolicyCrossRegionCopyInfoArgs>? = null

    private var desc: Output<String>? = null

    private var enterpriseSnapshotPolicyName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var retainRule: Output<EnterpriseSnapshotPolicyRetainRuleArgs>? = null

    private var schedule: Output<EnterpriseSnapshotPolicyScheduleArgs>? = null

    private var specialRetainRules: Output<EnterpriseSnapshotPolicySpecialRetainRulesArgs>? = null

    private var status: Output<String>? = null

    private var storageRule: Output<EnterpriseSnapshotPolicyStorageRuleArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetType: Output<String>? = null

    /**
     * @param value Snapshot replication information. See `cross_region_copy_info` below.
     */
    @JvmName("uaryyghmlwatqfoo")
    public suspend fun crossRegionCopyInfo(`value`: Output<EnterpriseSnapshotPolicyCrossRegionCopyInfoArgs>) {
        this.crossRegionCopyInfo = value
    }

    /**
     * @param value Description information representing the resource.
     */
    @JvmName("pxujyqmwqoehpvbl")
    public suspend fun desc(`value`: Output<String>) {
        this.desc = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("jqrlpfshhbiiabin")
    public suspend fun enterpriseSnapshotPolicyName(`value`: Output<String>) {
        this.enterpriseSnapshotPolicyName = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("sidmxqubwjqmvmrj")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Snapshot retention policy representing resources. See `retain_rule` below.
     */
    @JvmName("iwsgjpuehmqpehsw")
    public suspend fun retainRule(`value`: Output<EnterpriseSnapshotPolicyRetainRuleArgs>) {
        this.retainRule = value
    }

    /**
     * @param value The scheduling plan that represents the resource. See `schedule` below.
     */
    @JvmName("jumcghkmjqirkvcc")
    public suspend fun schedule(`value`: Output<EnterpriseSnapshotPolicyScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Snapshot special retention rules. See `special_retain_rules` below.
     */
    @JvmName("pfaqyyphekkwvfcp")
    public suspend fun specialRetainRules(`value`: Output<EnterpriseSnapshotPolicySpecialRetainRulesArgs>) {
        this.specialRetainRules = value
    }

    /**
     * @param value The status of the resource.
     */
    @JvmName("koxieqbvrkiwceyu")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Snapshot storage policy. See `storage_rule` below.
     */
    @JvmName("svhrsxjgetmmopbb")
    public suspend fun storageRule(`value`: Output<EnterpriseSnapshotPolicyStorageRuleArgs>) {
        this.storageRule = value
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("khmlwrqiyqalxmbh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Represents the target type of resource binding.
     */
    @JvmName("saovbnbotwteymus")
    public suspend fun targetType(`value`: Output<String>) {
        this.targetType = value
    }

    /**
     * @param value Snapshot replication information. See `cross_region_copy_info` below.
     */
    @JvmName("jianosohlpshnfuj")
    public suspend fun crossRegionCopyInfo(`value`: EnterpriseSnapshotPolicyCrossRegionCopyInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossRegionCopyInfo = mapped
    }

    /**
     * @param argument Snapshot replication information. See `cross_region_copy_info` below.
     */
    @JvmName("tdtjnbgeppjylucb")
    public suspend fun crossRegionCopyInfo(argument: suspend EnterpriseSnapshotPolicyCrossRegionCopyInfoArgsBuilder.() -> Unit) {
        val toBeMapped = EnterpriseSnapshotPolicyCrossRegionCopyInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.crossRegionCopyInfo = mapped
    }

    /**
     * @param value Description information representing the resource.
     */
    @JvmName("afhlrhaarqpxmwik")
    public suspend fun desc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desc = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("bydugighgiopdqye")
    public suspend fun enterpriseSnapshotPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enterpriseSnapshotPolicyName = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("jetxfpyxacexexdt")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Snapshot retention policy representing resources. See `retain_rule` below.
     */
    @JvmName("sxnwpbyjauvbekvx")
    public suspend fun retainRule(`value`: EnterpriseSnapshotPolicyRetainRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainRule = mapped
    }

    /**
     * @param argument Snapshot retention policy representing resources. See `retain_rule` below.
     */
    @JvmName("jgchwiufuiikpydw")
    public suspend fun retainRule(argument: suspend EnterpriseSnapshotPolicyRetainRuleArgsBuilder.() -> Unit) {
        val toBeMapped = EnterpriseSnapshotPolicyRetainRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.retainRule = mapped
    }

    /**
     * @param value The scheduling plan that represents the resource. See `schedule` below.
     */
    @JvmName("xtoqmulomggstgxe")
    public suspend fun schedule(`value`: EnterpriseSnapshotPolicyScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument The scheduling plan that represents the resource. See `schedule` below.
     */
    @JvmName("jkdgrhwksrdhoqpc")
    public suspend fun schedule(argument: suspend EnterpriseSnapshotPolicyScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = EnterpriseSnapshotPolicyScheduleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value Snapshot special retention rules. See `special_retain_rules` below.
     */
    @JvmName("qvkxccrnyrqwrqpo")
    public suspend fun specialRetainRules(`value`: EnterpriseSnapshotPolicySpecialRetainRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specialRetainRules = mapped
    }

    /**
     * @param argument Snapshot special retention rules. See `special_retain_rules` below.
     */
    @JvmName("howxkjlweajctvsk")
    public suspend fun specialRetainRules(argument: suspend EnterpriseSnapshotPolicySpecialRetainRulesArgsBuilder.() -> Unit) {
        val toBeMapped = EnterpriseSnapshotPolicySpecialRetainRulesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.specialRetainRules = mapped
    }

    /**
     * @param value The status of the resource.
     */
    @JvmName("cytdjysgxpelxlwa")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Snapshot storage policy. See `storage_rule` below.
     */
    @JvmName("dkjxnccvqxfnwywa")
    public suspend fun storageRule(`value`: EnterpriseSnapshotPolicyStorageRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageRule = mapped
    }

    /**
     * @param argument Snapshot storage policy. See `storage_rule` below.
     */
    @JvmName("ifbuajgwbetadrqd")
    public suspend fun storageRule(argument: suspend EnterpriseSnapshotPolicyStorageRuleArgsBuilder.() -> Unit) {
        val toBeMapped = EnterpriseSnapshotPolicyStorageRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageRule = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("bmbubojxyamhndff")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("nrijrtjrmtxicfgu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Represents the target type of resource binding.
     */
    @JvmName("dfxnivjjalckabej")
    public suspend fun targetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    internal fun build(): EnterpriseSnapshotPolicyArgs = EnterpriseSnapshotPolicyArgs(
        crossRegionCopyInfo = crossRegionCopyInfo,
        desc = desc,
        enterpriseSnapshotPolicyName = enterpriseSnapshotPolicyName,
        resourceGroupId = resourceGroupId,
        retainRule = retainRule,
        schedule = schedule,
        specialRetainRules = specialRetainRules,
        status = status,
        storageRule = storageRule,
        tags = tags,
        targetType = targetType,
    )
}
