@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin

import com.pulumi.alicloud.ebs.ReplicaGroupDrillArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a EBS Replica Group Drill resource.
 * For information about EBS Replica Group Drill and how to use it, see [What is Replica Group Drill](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.215.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ebs.ReplicaGroupDrill("default", {groupId: "pg-m1H9aaOUIGsDUwgZ"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ebs.ReplicaGroupDrill("default", group_id="pg-m1H9aaOUIGsDUwgZ")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ebs.ReplicaGroupDrill("default", new()
 *     {
 *         GroupId = "pg-m1H9aaOUIGsDUwgZ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ebs.NewReplicaGroupDrill(ctx, "default", &ebs.ReplicaGroupDrillArgs{
 * 			GroupId: pulumi.String("pg-m1H9aaOUIGsDUwgZ"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ebs.ReplicaGroupDrill;
 * import com.pulumi.alicloud.ebs.ReplicaGroupDrillArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ReplicaGroupDrill("default", ReplicaGroupDrillArgs.builder()
 *             .groupId("pg-m1H9aaOUIGsDUwgZ")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ebs:ReplicaGroupDrill
 *     properties:
 *       groupId: pg-m1H9aaOUIGsDUwgZ
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * EBS Replica Group Drill can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ebs/replicaGroupDrill:ReplicaGroupDrill example <group_id>:<replica_group_drill_id>
 * ```
 * @property groupId The ID of the replication group. You can use the describediskreplicaggroups interface to query the asynchronous replication group list to obtain the value of the replication group ID input parameter.
 */
public data class ReplicaGroupDrillArgs(
    public val groupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.ReplicaGroupDrillArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.ReplicaGroupDrillArgs =
        com.pulumi.alicloud.ebs.ReplicaGroupDrillArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicaGroupDrillArgs].
 */
@PulumiTagMarker
public class ReplicaGroupDrillArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    /**
     * @param value The ID of the replication group. You can use the describediskreplicaggroups interface to query the asynchronous replication group list to obtain the value of the replication group ID input parameter.
     */
    @JvmName("ktfbahcaefixagyi")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The ID of the replication group. You can use the describediskreplicaggroups interface to query the asynchronous replication group list to obtain the value of the replication group ID input parameter.
     */
    @JvmName("ltqwtekarjxtmajx")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    internal fun build(): ReplicaGroupDrillArgs = ReplicaGroupDrillArgs(
        groupId = groupId,
    )
}
