@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicaPairDrill].
 */
@PulumiTagMarker
public class ReplicaPairDrillResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicaPairDrillArgs = ReplicaPairDrillArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicaPairDrillArgsBuilder.() -> Unit) {
        val builder = ReplicaPairDrillArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReplicaPairDrill {
        val builtJavaResource = com.pulumi.alicloud.ebs.ReplicaPairDrill(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicaPairDrill(builtJavaResource)
    }
}

/**
 * Provides a EBS Replica Pair Drill resource.
 * For information about EBS Replica Pair Drill and how to use it, see [What is Replica Pair Drill](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.215.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ebs.ReplicaPairDrill("default", {pairId: "pair-cn-wwo3kjfq5001"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ebs.ReplicaPairDrill("default", pair_id="pair-cn-wwo3kjfq5001")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ebs.ReplicaPairDrill("default", new()
 *     {
 *         PairId = "pair-cn-wwo3kjfq5001",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ebs.NewReplicaPairDrill(ctx, "default", &ebs.ReplicaPairDrillArgs{
 * 			PairId: pulumi.String("pair-cn-wwo3kjfq5001"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ebs.ReplicaPairDrill;
 * import com.pulumi.alicloud.ebs.ReplicaPairDrillArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ReplicaPairDrill("default", ReplicaPairDrillArgs.builder()
 *             .pairId("pair-cn-wwo3kjfq5001")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ebs:ReplicaPairDrill
 *     properties:
 *       pairId: pair-cn-wwo3kjfq5001
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * EBS Replica Pair Drill can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ebs/replicaPairDrill:ReplicaPairDrill example <pair_id>:<replica_pair_drill_id>
 * ```
 */
public class ReplicaPairDrill internal constructor(
    override val javaResource: com.pulumi.alicloud.ebs.ReplicaPairDrill,
) : KotlinCustomResource(javaResource, ReplicaPairDrillMapper) {
    /**
     * Copy the ID of the pair. You can call DescribeDiskReplicaPairs to query the list of asynchronous replication pairs to obtain the replication pair ID.
     */
    public val pairId: Output<String>
        get() = javaResource.pairId().applyValue({ args0 -> args0 })

    /**
     * The first ID of the resource.
     */
    public val replicaPairDrillId: Output<String>
        get() = javaResource.replicaPairDrillId().applyValue({ args0 -> args0 })

    /**
     * Walkthrough status. _failed: Execution failed._failed: Cleanup failed.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ReplicaPairDrillMapper : ResourceMapper<ReplicaPairDrill> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ebs.ReplicaPairDrill::class == javaResource::class

    override fun map(javaResource: Resource): ReplicaPairDrill = ReplicaPairDrill(
        javaResource as
            com.pulumi.alicloud.ebs.ReplicaPairDrill,
    )
}

/**
 * @see [ReplicaPairDrill].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicaPairDrill].
 */
public suspend fun replicaPairDrill(
    name: String,
    block: suspend ReplicaPairDrillResourceBuilder.() -> Unit,
): ReplicaPairDrill {
    val builder = ReplicaPairDrillResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicaPairDrill].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicaPairDrill(name: String): ReplicaPairDrill {
    val builder = ReplicaPairDrillResourceBuilder()
    builder.name(name)
    return builder.build()
}
