@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin

import com.pulumi.alicloud.ebs.ReplicaPairDrillArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a EBS Replica Pair Drill resource.
 * For information about EBS Replica Pair Drill and how to use it, see [What is Replica Pair Drill](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.215.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ebs.ReplicaPairDrill("default", {pairId: "pair-cn-wwo3kjfq5001"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ebs.ReplicaPairDrill("default", pair_id="pair-cn-wwo3kjfq5001")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ebs.ReplicaPairDrill("default", new()
 *     {
 *         PairId = "pair-cn-wwo3kjfq5001",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ebs.NewReplicaPairDrill(ctx, "default", &ebs.ReplicaPairDrillArgs{
 * 			PairId: pulumi.String("pair-cn-wwo3kjfq5001"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ebs.ReplicaPairDrill;
 * import com.pulumi.alicloud.ebs.ReplicaPairDrillArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ReplicaPairDrill("default", ReplicaPairDrillArgs.builder()
 *             .pairId("pair-cn-wwo3kjfq5001")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ebs:ReplicaPairDrill
 *     properties:
 *       pairId: pair-cn-wwo3kjfq5001
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * EBS Replica Pair Drill can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ebs/replicaPairDrill:ReplicaPairDrill example <pair_id>:<replica_pair_drill_id>
 * ```
 * @property pairId Copy the ID of the pair. You can call DescribeDiskReplicaPairs to query the list of asynchronous replication pairs to obtain the replication pair ID.
 */
public data class ReplicaPairDrillArgs(
    public val pairId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.ReplicaPairDrillArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.ReplicaPairDrillArgs =
        com.pulumi.alicloud.ebs.ReplicaPairDrillArgs.builder()
            .pairId(pairId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicaPairDrillArgs].
 */
@PulumiTagMarker
public class ReplicaPairDrillArgsBuilder internal constructor() {
    private var pairId: Output<String>? = null

    /**
     * @param value Copy the ID of the pair. You can call DescribeDiskReplicaPairs to query the list of asynchronous replication pairs to obtain the replication pair ID.
     */
    @JvmName("gidohlsgeyrybtps")
    public suspend fun pairId(`value`: Output<String>) {
        this.pairId = value
    }

    /**
     * @param value Copy the ID of the pair. You can call DescribeDiskReplicaPairs to query the list of asynchronous replication pairs to obtain the replication pair ID.
     */
    @JvmName("ofxqmlvwapefucqr")
    public suspend fun pairId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pairId = mapped
    }

    internal fun build(): ReplicaPairDrillArgs = ReplicaPairDrillArgs(
        pairId = pairId,
    )
}
