@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.inputs

import com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyCrossRegionCopyInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enable Snapshot replication.
 * @property regions Destination region for Snapshot replication. See `regions` below.
 */
public data class EnterpriseSnapshotPolicyCrossRegionCopyInfoArgs(
    public val enabled: Output<Boolean>? = null,
    public val regions: Output<List<EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyCrossRegionCopyInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyCrossRegionCopyInfoArgs =
        com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyCrossRegionCopyInfoArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .regions(
                regions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EnterpriseSnapshotPolicyCrossRegionCopyInfoArgs].
 */
@PulumiTagMarker
public class EnterpriseSnapshotPolicyCrossRegionCopyInfoArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var regions: Output<List<EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs>>? = null

    /**
     * @param value Enable Snapshot replication.
     */
    @JvmName("sowovehatndymwqn")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Destination region for Snapshot replication. See `regions` below.
     */
    @JvmName("atqnsnpohybsfhhp")
    public suspend fun regions(`value`: Output<List<EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs>>) {
        this.regions = value
    }

    @JvmName("xcrxwltggadkccjl")
    public suspend fun regions(vararg values: Output<EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values Destination region for Snapshot replication. See `regions` below.
     */
    @JvmName("soivrtcpaafrgtkd")
    public suspend fun regions(values: List<Output<EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value Enable Snapshot replication.
     */
    @JvmName("jivjdvvjoklutipi")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Destination region for Snapshot replication. See `regions` below.
     */
    @JvmName("oebvtcslfceaxppq")
    public suspend fun regions(`value`: List<EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param argument Destination region for Snapshot replication. See `regions` below.
     */
    @JvmName("clojshlucsyelamr")
    public suspend fun regions(argument: List<suspend EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param argument Destination region for Snapshot replication. See `regions` below.
     */
    @JvmName("tlhxuskjulwqupks")
    public suspend fun regions(vararg argument: suspend EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param argument Destination region for Snapshot replication. See `regions` below.
     */
    @JvmName("geyxrmubwsopyfhv")
    public suspend fun regions(argument: suspend EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param values Destination region for Snapshot replication. See `regions` below.
     */
    @JvmName("xurrftbakaguswox")
    public suspend fun regions(vararg values: EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    internal fun build(): EnterpriseSnapshotPolicyCrossRegionCopyInfoArgs =
        EnterpriseSnapshotPolicyCrossRegionCopyInfoArgs(
            enabled = enabled,
            regions = regions,
        )
}
