@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.inputs

import com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property regionId Destination region ID.
 * @property retainDays Number of days of snapshot retention for replication.
 */
public data class EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs(
    public val regionId: Output<String>? = null,
    public val retainDays: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs =
        com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs.builder()
            .regionId(regionId?.applyValue({ args0 -> args0 }))
            .retainDays(retainDays?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs].
 */
@PulumiTagMarker
public class EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgsBuilder internal constructor() {
    private var regionId: Output<String>? = null

    private var retainDays: Output<Int>? = null

    /**
     * @param value Destination region ID.
     */
    @JvmName("kfjpyoupeyiwfeks")
    public suspend fun regionId(`value`: Output<String>) {
        this.regionId = value
    }

    /**
     * @param value Number of days of snapshot retention for replication.
     */
    @JvmName("qylshtjtgqfrsauo")
    public suspend fun retainDays(`value`: Output<Int>) {
        this.retainDays = value
    }

    /**
     * @param value Destination region ID.
     */
    @JvmName("ykkphsyvkvbqaosg")
    public suspend fun regionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionId = mapped
    }

    /**
     * @param value Number of days of snapshot retention for replication.
     */
    @JvmName("lqkfhyseexcofdpk")
    public suspend fun retainDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainDays = mapped
    }

    internal fun build(): EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs =
        EnterpriseSnapshotPolicyCrossRegionCopyInfoRegionArgs(
            regionId = regionId,
            retainDays = retainDays,
        )
}
