@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.inputs

import com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyRetainRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property number Retention based on counting method.
 * @property timeInterval Time unit.
 * @property timeUnit Time-based retention.
 */
public data class EnterpriseSnapshotPolicyRetainRuleArgs(
    public val number: Output<Int>? = null,
    public val timeInterval: Output<Int>? = null,
    public val timeUnit: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyRetainRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyRetainRuleArgs =
        com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyRetainRuleArgs.builder()
            .number(number?.applyValue({ args0 -> args0 }))
            .timeInterval(timeInterval?.applyValue({ args0 -> args0 }))
            .timeUnit(timeUnit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnterpriseSnapshotPolicyRetainRuleArgs].
 */
@PulumiTagMarker
public class EnterpriseSnapshotPolicyRetainRuleArgsBuilder internal constructor() {
    private var number: Output<Int>? = null

    private var timeInterval: Output<Int>? = null

    private var timeUnit: Output<String>? = null

    /**
     * @param value Retention based on counting method.
     */
    @JvmName("rqbwwkvwqonlyqmv")
    public suspend fun number(`value`: Output<Int>) {
        this.number = value
    }

    /**
     * @param value Time unit.
     */
    @JvmName("oxqwfirpxrcibuti")
    public suspend fun timeInterval(`value`: Output<Int>) {
        this.timeInterval = value
    }

    /**
     * @param value Time-based retention.
     */
    @JvmName("cgrpyahbhnafqenr")
    public suspend fun timeUnit(`value`: Output<String>) {
        this.timeUnit = value
    }

    /**
     * @param value Retention based on counting method.
     */
    @JvmName("fbohywdhsnnenrei")
    public suspend fun number(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.number = mapped
    }

    /**
     * @param value Time unit.
     */
    @JvmName("bdjvfauhfxvrvsse")
    public suspend fun timeInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeInterval = mapped
    }

    /**
     * @param value Time-based retention.
     */
    @JvmName("yqbusyqgdeeylwnx")
    public suspend fun timeUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeUnit = mapped
    }

    internal fun build(): EnterpriseSnapshotPolicyRetainRuleArgs =
        EnterpriseSnapshotPolicyRetainRuleArgs(
            number = number,
            timeInterval = timeInterval,
            timeUnit = timeUnit,
        )
}
