@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.inputs

import com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cronExpression CronTab expression.
 */
public data class EnterpriseSnapshotPolicyScheduleArgs(
    public val cronExpression: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyScheduleArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyScheduleArgs =
        com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyScheduleArgs.builder()
            .cronExpression(cronExpression.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnterpriseSnapshotPolicyScheduleArgs].
 */
@PulumiTagMarker
public class EnterpriseSnapshotPolicyScheduleArgsBuilder internal constructor() {
    private var cronExpression: Output<String>? = null

    /**
     * @param value CronTab expression.
     */
    @JvmName("xtujshifgtldsrnr")
    public suspend fun cronExpression(`value`: Output<String>) {
        this.cronExpression = value
    }

    /**
     * @param value CronTab expression.
     */
    @JvmName("gxsshfayuqwrjwbd")
    public suspend fun cronExpression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cronExpression = mapped
    }

    internal fun build(): EnterpriseSnapshotPolicyScheduleArgs = EnterpriseSnapshotPolicyScheduleArgs(
        cronExpression = cronExpression ?: throw PulumiNullFieldException("cronExpression"),
    )
}
