@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.inputs

import com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicySpecialRetainRulesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether special reservations are enabled. Value range:
 * - true
 * - false.
 * @property rules List of special retention rules. See `rules` below.
 */
public data class EnterpriseSnapshotPolicySpecialRetainRulesArgs(
    public val enabled: Output<Boolean>? = null,
    public val rules: Output<List<EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicySpecialRetainRulesArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicySpecialRetainRulesArgs =
        com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicySpecialRetainRulesArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EnterpriseSnapshotPolicySpecialRetainRulesArgs].
 */
@PulumiTagMarker
public class EnterpriseSnapshotPolicySpecialRetainRulesArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var rules: Output<List<EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs>>? = null

    /**
     * @param value Whether special reservations are enabled. Value range:
     * - true
     * - false.
     */
    @JvmName("abnqkrelmtujyhgn")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value List of special retention rules. See `rules` below.
     */
    @JvmName("ehsixirgtmwrdbxx")
    public suspend fun rules(`value`: Output<List<EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs>>) {
        this.rules = value
    }

    @JvmName("eifhjksgiouanusf")
    public suspend fun rules(vararg values: Output<EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values List of special retention rules. See `rules` below.
     */
    @JvmName("yfxsnmahfiraexqq")
    public suspend fun rules(values: List<Output<EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Whether special reservations are enabled. Value range:
     * - true
     * - false.
     */
    @JvmName("sutskhkqcvtqgdle")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value List of special retention rules. See `rules` below.
     */
    @JvmName("ycppmbvamknoqexi")
    public suspend fun rules(`value`: List<EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument List of special retention rules. See `rules` below.
     */
    @JvmName("pppxapbqoonaawrv")
    public suspend fun rules(argument: List<suspend EnterpriseSnapshotPolicySpecialRetainRulesRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnterpriseSnapshotPolicySpecialRetainRulesRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of special retention rules. See `rules` below.
     */
    @JvmName("aupgyrcubrokpxqc")
    public suspend fun rules(vararg argument: suspend EnterpriseSnapshotPolicySpecialRetainRulesRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EnterpriseSnapshotPolicySpecialRetainRulesRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of special retention rules. See `rules` below.
     */
    @JvmName("lrtjnaicefivwtuw")
    public suspend fun rules(argument: suspend EnterpriseSnapshotPolicySpecialRetainRulesRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EnterpriseSnapshotPolicySpecialRetainRulesRuleArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values List of special retention rules. See `rules` below.
     */
    @JvmName("wbhgkcdmnguhsgae")
    public suspend fun rules(vararg values: EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): EnterpriseSnapshotPolicySpecialRetainRulesArgs =
        EnterpriseSnapshotPolicySpecialRetainRulesArgs(
            enabled = enabled,
            rules = rules,
        )
}
