@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.inputs

import com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property specialPeriodUnit The cycle unit of the special reserved snapshot. If the value is set to WEEKS, the first snapshot of each week is reserved. The retention time is determined by TimeUnit and TimeInterval. The value range is:
 * - WEEKS
 * - MONTHS
 * - YEARS.
 * @property timeInterval
 * @property timeUnit
 */
public data class EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs(
    public val specialPeriodUnit: Output<String>? = null,
    public val timeInterval: Output<Int>? = null,
    public val timeUnit: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs =
        com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs.builder()
            .specialPeriodUnit(specialPeriodUnit?.applyValue({ args0 -> args0 }))
            .timeInterval(timeInterval?.applyValue({ args0 -> args0 }))
            .timeUnit(timeUnit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs].
 */
@PulumiTagMarker
public class EnterpriseSnapshotPolicySpecialRetainRulesRuleArgsBuilder internal constructor() {
    private var specialPeriodUnit: Output<String>? = null

    private var timeInterval: Output<Int>? = null

    private var timeUnit: Output<String>? = null

    /**
     * @param value The cycle unit of the special reserved snapshot. If the value is set to WEEKS, the first snapshot of each week is reserved. The retention time is determined by TimeUnit and TimeInterval. The value range is:
     * - WEEKS
     * - MONTHS
     * - YEARS.
     */
    @JvmName("osvqhxajqgvalhdq")
    public suspend fun specialPeriodUnit(`value`: Output<String>) {
        this.specialPeriodUnit = value
    }

    /**
     * @param value
     */
    @JvmName("dmaxxsndkcgcytnn")
    public suspend fun timeInterval(`value`: Output<Int>) {
        this.timeInterval = value
    }

    /**
     * @param value
     */
    @JvmName("ctbetcrtbdjyvwma")
    public suspend fun timeUnit(`value`: Output<String>) {
        this.timeUnit = value
    }

    /**
     * @param value The cycle unit of the special reserved snapshot. If the value is set to WEEKS, the first snapshot of each week is reserved. The retention time is determined by TimeUnit and TimeInterval. The value range is:
     * - WEEKS
     * - MONTHS
     * - YEARS.
     */
    @JvmName("ybaawoesrvvukdab")
    public suspend fun specialPeriodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specialPeriodUnit = mapped
    }

    /**
     * @param value
     */
    @JvmName("iylskmxvgngeifaw")
    public suspend fun timeInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("otyogpdmfqybwmln")
    public suspend fun timeUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeUnit = mapped
    }

    internal fun build(): EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs =
        EnterpriseSnapshotPolicySpecialRetainRulesRuleArgs(
            specialPeriodUnit = specialPeriodUnit,
            timeInterval = timeInterval,
            timeUnit = timeUnit,
        )
}
